/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.timepicker.wheel;

import android.content.Context;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;

public class FixedScroller {
    private final Interpolator mInterpolator;
    private int mMode;
    private int mStartX;
    private int mStartY;
    private int mFinalX;
    private int mFinalY;
    private int mMinX;
    private int mMaxX;
    private int mMinY;
    private int mMaxY;
    private int mCurrX;
    private int mCurrY;
    private long mStartTime;
    private int mDuration;
    private float mDurationReciprocal;
    private float mDeltaX;
    private float mDeltaY;
    private boolean mFinished = true;
    private boolean mFlywheel;
    private float mVelocity;
    private float mCurrVelocity;
    private int mDistance;
    private float mFixedFlingValue;
    private float mFlingFriction = ViewConfiguration.getScrollFriction();
    private static final int DEFAULT_DURATION = 250;
    private static final int SCROLL_MODE = 0;
    private static final int FLING_MODE = 1;
    private static float DECELERATION_RATE = (float)(Math.log(0.78) / Math.log(0.9));
    private static final float INFLEXION = 0.35f;
    private static final float START_TENSION = 0.5f;
    private static final float END_TENSION = 1.0f;
    private static final float P1 = 0.175f;
    private static final float P2 = 0.35000002f;
    private static final int NB_SAMPLES = 100;
    private static final float[] SPLINE_POSITION = new float[101];
    private static final float[] SPLINE_TIME = new float[101];
    private float mDeceleration;
    private final float mPpi;
    private float mPhysicalCoeff;

    public FixedScroller(Context context) {
        this(context, null);
    }

    public FixedScroller(Context context, Interpolator interpolator) {
        this(context, interpolator, context.getApplicationInfo().targetSdkVersion >= 11);
    }

    public FixedScroller(Context context, Interpolator interpolator, boolean flywheel) {
        this.mInterpolator = interpolator == null ? new ViscousFluidInterpolator() : interpolator;
        this.mPpi = context.getResources().getDisplayMetrics().density * 160.0f;
        this.mDeceleration = this.computeDeceleration(ViewConfiguration.getScrollFriction());
        this.mFlywheel = flywheel;
        this.mPhysicalCoeff = this.computeDeceleration(0.25f);
    }

    public final void setFriction(float friction) {
        this.mDeceleration = this.computeDeceleration(friction);
        this.mFlingFriction = friction;
    }

    private float computeDeceleration(float friction) {
        return 386.0878f * this.mPpi * friction;
    }

    public final boolean isFinished() {
        return this.mFinished;
    }

    public final void forceFinished(boolean finished) {
        this.mFinished = finished;
    }

    public final int getDuration() {
        return this.mDuration;
    }

    public final int getCurrX() {
        return this.mCurrX;
    }

    public final int getCurrY() {
        return this.mCurrY;
    }

    public float getCurrVelocity() {
        return this.mMode == 1 ? this.mCurrVelocity : this.mVelocity - this.mDeceleration * (float)this.timePassed() / 2000.0f;
    }

    public final int getStartX() {
        return this.mStartX;
    }

    public final int getStartY() {
        return this.mStartY;
    }

    public final int getFinalX() {
        return this.mFinalX;
    }

    public final int getFinalY() {
        return this.mFinalY;
    }

    public boolean computeScrollOffset() {
        if (this.mFinished) {
            return false;
        }
        int timePassed = (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
        if (timePassed < this.mDuration) {
            switch (this.mMode) {
                case 0: {
                    float x = this.mInterpolator.getInterpolation((float)timePassed * this.mDurationReciprocal);
                    this.mCurrX = this.mStartX + Math.round(x * this.mDeltaX);
                    this.mCurrY = this.mStartY + Math.round(x * this.mDeltaY);
                    break;
                }
                case 1: {
                    float t = (float)timePassed / (float)this.mDuration;
                    int index = (int)(100.0f * t);
                    float distanceCoef = 1.0f;
                    float velocityCoef = 0.0f;
                    if (index < 100) {
                        float t_inf = (float)index / 100.0f;
                        float t_sup = (float)(index + 1) / 100.0f;
                        float d_inf = SPLINE_POSITION[index];
                        float d_sup = SPLINE_POSITION[index + 1];
                        velocityCoef = (d_sup - d_inf) / (t_sup - t_inf);
                        distanceCoef = d_inf + (t - t_inf) * velocityCoef;
                    }
                    this.mCurrVelocity = velocityCoef * (float)this.mDistance / (float)this.mDuration * 1000.0f;
                    this.mCurrX = this.mStartX + Math.round(distanceCoef * (float)(this.mFinalX - this.mStartX));
                    this.mCurrX = Math.min(this.mCurrX, this.mMaxX);
                    this.mCurrX = Math.max(this.mCurrX, this.mMinX);
                    this.mCurrY = this.mStartY + Math.round(distanceCoef * (float)(this.mFinalY - this.mStartY));
                    this.mCurrY = Math.min(this.mCurrY, this.mMaxY);
                    this.mCurrY = Math.max(this.mCurrY, this.mMinY);
                    if (this.mCurrX != this.mFinalX || this.mCurrY != this.mFinalY) break;
                    this.mFinished = true;
                }
            }
        } else {
            this.mCurrX = this.mFinalX;
            this.mCurrY = this.mFinalY;
            this.mFinished = true;
        }
        return true;
    }

    public void startScroll(int startX, int startY, int dx, int dy) {
        this.startScroll(startX, startY, dx, dy, 250);
    }

    public void startScroll(int startX, int startY, int dx, int dy, int duration) {
        this.mMode = 0;
        this.mFinished = false;
        this.mDuration = duration;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStartX = startX;
        this.mStartY = startY;
        this.mFinalX = startX + dx;
        this.mFinalY = startY + dy;
        this.mDeltaX = dx;
        this.mDeltaY = dy;
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
        this.mFixedFlingValue = 0.0f;
    }

    public void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
        float velocity;
        if (this.mFlywheel && !this.mFinished) {
            float oldVel = this.getCurrVelocity();
            float dx = this.mFinalX - this.mStartX;
            float dy = this.mFinalY - this.mStartY;
            float hyp = (float)Math.hypot(dx, dy);
            float ndx = dx / hyp;
            float ndy = dy / hyp;
            float oldVelocityX = ndx * oldVel;
            float oldVelocityY = ndy * oldVel;
            if (Math.signum(velocityX) == Math.signum(oldVelocityX) && Math.signum(velocityY) == Math.signum(oldVelocityY)) {
                velocityX = (int)((float)velocityX + oldVelocityX);
                velocityY = (int)((float)velocityY + oldVelocityY);
            }
        }
        this.mMode = 1;
        this.mFinished = false;
        this.mVelocity = velocity = (float)Math.hypot(velocityX, velocityY);
        this.mDuration = this.getSplineFlingDuration(velocity);
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStartX = startX;
        this.mStartY = startY;
        float coeffX = velocity == 0.0f ? 1.0f : (float)velocityX / velocity;
        float coeffY = velocity == 0.0f ? 1.0f : (float)velocityY / velocity;
        double totalDistance = this.getSplineFlingDistance(velocity);
        this.mDistance = (int)(totalDistance * (double)Math.signum(velocity));
        this.mMinX = minX;
        this.mMaxX = maxX;
        this.mMinY = minY;
        this.mMaxY = maxY;
        this.mFinalX = startX + (int)Math.round(totalDistance * (double)coeffX);
        this.mFinalX = Math.min(this.mFinalX, this.mMaxX);
        this.mFinalX = Math.max(this.mFinalX, this.mMinX);
        this.mFinalY = startY + (int)Math.round(totalDistance * (double)coeffY);
        this.mFinalY = Math.min(this.mFinalY, this.mMaxY);
        this.mFinalY = Math.max(this.mFinalY, this.mMinY);
        this.mFixedFlingValue = 0.0f;
    }

    public void setFixedFlingValue(float fixFlingValue) {
        this.mFixedFlingValue = fixFlingValue;
    }

    public float getFixedFlingValue() {
        if (this.mMode != 1) {
            return 0.0f;
        }
        int timePassed = (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
        if (timePassed >= this.mDuration || this.mDuration <= 0) {
            return this.mFixedFlingValue;
        }
        float t = (float)timePassed / (float)this.mDuration;
        if (this.mInterpolator != null) {
            t = this.mInterpolator.getInterpolation(t);
        }
        return t * this.mFixedFlingValue;
    }

    private double getSplineDeceleration(float velocity) {
        return Math.log(0.35f * Math.abs(velocity) / (this.mFlingFriction * this.mPhysicalCoeff));
    }

    private int getSplineFlingDuration(float velocity) {
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)DECELERATION_RATE - 1.0;
        return (int)(1000.0 * Math.exp(l / decelMinusOne));
    }

    private double getSplineFlingDistance(float velocity) {
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)DECELERATION_RATE - 1.0;
        return (double)(this.mFlingFriction * this.mPhysicalCoeff) * Math.exp((double)DECELERATION_RATE / decelMinusOne * l);
    }

    public void abortAnimation() {
        this.mCurrX = this.mFinalX;
        this.mCurrY = this.mFinalY;
        this.mFinished = true;
    }

    public void extendDuration(int extend) {
        int passed = this.timePassed();
        this.mDuration = passed + extend;
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
        this.mFinished = false;
    }

    public int timePassed() {
        return (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
    }

    public void setFinalX(int newX) {
        this.mFinalX = newX;
        this.mDeltaX = this.mFinalX - this.mStartX;
        this.mFinished = false;
    }

    public void setFinalY(int newY) {
        this.mFinalY = newY;
        this.mDeltaY = this.mFinalY - this.mStartY;
        this.mFinished = false;
    }

    public boolean isScrollingInDirection(float xvel, float yvel) {
        return !this.mFinished && Math.signum(xvel) == Math.signum(this.mFinalX - this.mStartX) && Math.signum(yvel) == Math.signum(this.mFinalY - this.mStartY);
    }

    static {
        float x_min = 0.0f;
        float y_min = 0.0f;
        for (int i = 0; i < 100; ++i) {
            float y;
            float dy;
            float x;
            float coef;
            float tx;
            float alpha = (float)i / 100.0f;
            float x_max = 1.0f;
            while (!((double)Math.abs((tx = (coef = 3.0f * (x = x_min + (x_max - x_min) / 2.0f) * (1.0f - x)) * ((1.0f - x) * 0.175f + x * 0.35000002f) + x * x * x) - alpha) < 1.0E-5)) {
                if (tx > alpha) {
                    x_max = x;
                    continue;
                }
                x_min = x;
            }
            FixedScroller.SPLINE_POSITION[i] = coef * ((1.0f - x) * 0.5f + x) + x * x * x;
            float y_max = 1.0f;
            while (!((double)Math.abs((dy = (coef = 3.0f * (y = y_min + (y_max - y_min) / 2.0f) * (1.0f - y)) * ((1.0f - y) * 0.5f + y) + y * y * y) - alpha) < 1.0E-5)) {
                if (dy > alpha) {
                    y_max = y;
                    continue;
                }
                y_min = y;
            }
            FixedScroller.SPLINE_TIME[i] = coef * ((1.0f - y) * 0.175f + y * 0.35000002f) + y * y * y;
        }
        FixedScroller.SPLINE_TIME[100] = 1.0f;
        FixedScroller.SPLINE_POSITION[100] = 1.0f;
    }

    static class ViscousFluidInterpolator
    implements Interpolator {
        private static final float VISCOUS_FLUID_SCALE = 8.0f;
        private static final float VISCOUS_FLUID_NORMALIZE = 1.0f / ViscousFluidInterpolator.viscousFluid(1.0f);
        private static final float VISCOUS_FLUID_OFFSET = 1.0f - VISCOUS_FLUID_NORMALIZE * ViscousFluidInterpolator.viscousFluid(1.0f);

        ViscousFluidInterpolator() {
        }

        private static float viscousFluid(float x) {
            if ((x *= 8.0f) < 1.0f) {
                x -= 1.0f - (float)Math.exp(-x);
            } else {
                float start = 0.36787945f;
                x = 1.0f - (float)Math.exp(1.0f - x);
                x = start + x * (1.0f - start);
            }
            return x;
        }

        public float getInterpolation(float input) {
            float interpolated = VISCOUS_FLUID_NORMALIZE * ViscousFluidInterpolator.viscousFluid(input);
            if (interpolated > 0.0f) {
                return interpolated + VISCOUS_FLUID_OFFSET;
            }
            return interpolated;
        }
    }
}

