/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.timepicker.wheel;

import com.transsion.widgetslib.widget.timepicker.wheel.WheelAdapter;
import java.util.Locale;

public class NumericWheelAdapter
implements WheelAdapter {
    public static final int DEFAULT_MAX_VALUE = 9;
    private static final int DEFAULT_MIN_VALUE = 0;
    public int minValue;
    private int maxValue;
    private String format;
    private boolean isNumberNeedTranslate;
    private static final String EG_AR = "EG_ar";
    private static final String IR_FA = "IR_fa";

    public NumericWheelAdapter() {
        this(0, 9);
    }

    public NumericWheelAdapter(int minValue, int maxValue) {
        this(minValue, maxValue, null);
    }

    public NumericWheelAdapter(int minValue, int maxValue, String format) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.format = format;
        Locale locale = Locale.getDefault();
        this.isNumberNeedTranslate = (locale.getCountry() + "_" + locale.getLanguage()).equals(EG_AR) || (locale.getCountry() + "_" + locale.getLanguage()).equals(IR_FA);
    }

    @Override
    public String getItem(int index) {
        if (index >= 0 && index < this.getItemsCount()) {
            int value = this.minValue + index;
            if (this.isNumberNeedTranslate) {
                return this.format != null ? String.format(this.format, value) : String.format(Locale.getDefault(), "%d", value) + "";
            }
            return this.format != null ? String.format(this.format, value) : Integer.toString(value);
        }
        return null;
    }

    @Override
    public int getItemsCount() {
        return this.maxValue - this.minValue + 1;
    }

    @Override
    public int getMaximumLength() {
        int max = Math.max(Math.abs(this.maxValue), Math.abs(this.minValue));
        int maxLen = Integer.toString(max).length();
        if (this.minValue < 0) {
            ++maxLen;
        }
        return maxLen;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }
}

