/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.sort;

import android.content.Context;
import com.transsion.sort.ContactLocaleHelper;
import com.transsion.sort.IContactLocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class SortUtil {
    public IContactLocale mLocaleUtil;
    NameComparator mNameComparator;
    NormalComparator mNormalComparator;
    ArrayList<String> mLabels;
    private HashMap<String, String> mCachedKeys = new HashMap();

    public SortUtil(Context context) {
        this.mLocaleUtil = ContactLocaleHelper.getContactLocaleUtils(context);
        this.mLabels = this.mLocaleUtil.getLabels();
        this.mNameComparator = new NameComparator();
        this.mNormalComparator = new NormalComparator();
    }

    public String getLable(String s) {
        String key = this.mCachedKeys.get(s);
        if (key == null) {
            key = this.mLocaleUtil.getLabel(s);
            this.mCachedKeys.put(s, key);
        }
        return key.equals("") ? "#" : key;
    }

    public void clearCache() {
        this.mCachedKeys.clear();
    }

    public String getAllLabels() {
        return this.getStringFormList(this.mLabels);
    }

    public void sortString(List<String> strings) {
        Collections.sort(strings, this.mNameComparator);
    }

    public void sortCompare(List<? extends Comparable> strings) {
        Collections.sort(strings, this.mNormalComparator);
    }

    public int compare(String lhs, String rhs) {
        int rIndex;
        int lIndex = this.mLabels.indexOf(this.getLable(lhs));
        return lIndex != (rIndex = this.mLabels.indexOf(this.getLable(rhs))) ? lIndex - rIndex : lhs.compareToIgnoreCase(rhs);
    }

    public <E extends Comparable> int compareComparable(E lhs, E rhs) {
        return this.compare(lhs.getString(), rhs.getString());
    }

    private String getStringFormList(ArrayList<String> list) {
        String string = "";
        for (String s : list) {
            string = String.valueOf(string) + s;
        }
        return string;
    }

    public static interface Comparable {
        public String getString();
    }

    private class NameComparator
    implements Comparator<String> {
        private NameComparator() {
        }

        @Override
        public int compare(String lhs, String rhs) {
            return SortUtil.this.compare(lhs, rhs);
        }
    }

    private class NormalComparator
    implements Comparator<Comparable> {
        private NormalComparator() {
        }

        @Override
        public int compare(Comparable lhs, Comparable rhs) {
            return SortUtil.this.compare(lhs.getString(), rhs.getString());
        }
    }
}

