/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.sort24;

import android.icu.util.ULocale;
import android.os.LocaleList;
import java.util.Locale;

public class LocaleSet {
    private static final String SCRIPT_SIMPLIFIED_CHINESE = "Hans";
    private static final String SCRIPT_TRADITIONAL_CHINESE = "Hant";
    private final Locale mDefaultLocaleOverrideForTest;
    private final LocaleList mLocaleList;

    private LocaleSet(LocaleList localeList, Locale defaultLocaleOverrideForTest) {
        this.mLocaleList = localeList;
        this.mDefaultLocaleOverrideForTest = defaultLocaleOverrideForTest;
    }

    public static LocaleSet newDefault() {
        return new LocaleSet(LocaleList.getDefault(), null);
    }

    public static LocaleSet newForTest(Locale ... locales) {
        return new LocaleSet(new LocaleList(locales), locales[0]);
    }

    static boolean isLanguageChinese(Locale locale) {
        return locale != null && "zh".equals(locale.getLanguage());
    }

    static boolean isLanguageJapanese(Locale locale) {
        return locale != null && "ja".equals(locale.getLanguage());
    }

    static boolean isLanguageKorean(Locale locale) {
        return locale != null && "ko".equals(locale.getLanguage());
    }

    static boolean isLocaleCJK(Locale locale) {
        return LocaleSet.isLanguageChinese(locale) || LocaleSet.isLanguageJapanese(locale) || LocaleSet.isLanguageKorean(locale);
    }

    private static String getLikelyScript(Locale locale) {
        String script = locale.getScript();
        if (!script.isEmpty()) {
            return script;
        }
        return ULocale.addLikelySubtags((ULocale)ULocale.forLocale((Locale)locale)).getScript();
    }

    static String getScriptIfChinese(Locale locale) {
        return LocaleSet.isLanguageChinese(locale) ? LocaleSet.getLikelyScript(locale) : null;
    }

    static boolean isLocaleSimplifiedChinese(Locale locale) {
        return SCRIPT_SIMPLIFIED_CHINESE.equals(LocaleSet.getScriptIfChinese(locale));
    }

    static boolean isLocaleTraditionalChinese(Locale locale) {
        return SCRIPT_TRADITIONAL_CHINESE.equals(LocaleSet.getScriptIfChinese(locale));
    }

    public Locale getPrimaryLocale() {
        if (this.mDefaultLocaleOverrideForTest != null) {
            return this.mDefaultLocaleOverrideForTest;
        }
        return Locale.getDefault();
    }

    public LocaleList getAllLocales() {
        return this.mLocaleList;
    }

    public boolean isPrimaryLocaleCJK() {
        return LocaleSet.isLocaleCJK(this.getPrimaryLocale());
    }

    public boolean shouldPreferJapanese() {
        if (LocaleSet.isLanguageJapanese(this.getPrimaryLocale())) {
            return true;
        }
        int i = 0;
        while (i < this.mLocaleList.size()) {
            Locale l = this.mLocaleList.get(i);
            if (LocaleSet.isLanguageJapanese(l)) {
                return true;
            }
            if (LocaleSet.isLocaleSimplifiedChinese(l)) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public boolean shouldPreferSimplifiedChinese() {
        if (LocaleSet.isLocaleSimplifiedChinese(this.getPrimaryLocale())) {
            return true;
        }
        int i = 0;
        while (i < this.mLocaleList.size()) {
            Locale l = this.mLocaleList.get(i);
            if (LocaleSet.isLocaleSimplifiedChinese(l)) {
                return true;
            }
            if (LocaleSet.isLanguageJapanese(l)) {
                return false;
            }
            if (LocaleSet.isLocaleTraditionalChinese(l)) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof LocaleSet) {
            LocaleSet other = (LocaleSet)object;
            return this.mLocaleList.equals((Object)other.mLocaleList);
        }
        return false;
    }

    public final String toString() {
        return this.mLocaleList.toString();
    }
}

