/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.seekbar;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;

public class OSSectionSeekbar
extends View {
    private String TAG = OSSectionSeekbar.class.getSimpleName();
    private float mMin;
    private float mMax;
    private float mProgress;
    private boolean isFloatType;
    private int mTrackSize;
    private int mSecondTrackSize;
    private int mSectionTextSize;
    private int mSectionCount;
    private int mThumbRadius;
    private int mTrackColor;
    private int mSecondTrackColor;
    private int mThumbOutColor;
    private int mThumbInsideColor;
    private int mDotsColor;
    private int mSectionTextColor;
    private int mSectionTextInterval;
    private boolean mDisplayCharacters;
    private float mDelta;
    private float mSectionValue;
    private int mCurrentSection;
    private float mThumbCenterX;
    private float mTrackLength;
    private float mSectionOffset;
    private boolean isThumbOnDragging;
    private final int mTextSpace;
    private SparseArray<String> mSectionTextArray = new SparseArray();
    private float mPreThumbCenterX;
    private OnProgressChangedListener mProgressListener;
    private float mLeft;
    private float mRight;
    private final Paint mPaint;
    private final Paint mCirclePaint;
    private final Rect mRectText;
    private final Context mContext;
    private OSSectionSeekBarBuilder mOSSectionSeekBarBuilder;

    public OSSectionSeekbar(Context context) {
        this(context, null);
    }

    public OSSectionSeekbar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public OSSectionSeekbar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.getConfigBuilder().build();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OSSectionSeekbar, defStyleAttr, 0);
        this.mMin = a.getFloat(R.styleable.OSSectionSeekbar_osSectionSeekbarMin, 0.0f);
        this.mMax = a.getFloat(R.styleable.OSSectionSeekbar_osSectionSeekbarMax, 100.0f);
        this.mProgress = a.getFloat(R.styleable.OSSectionSeekbar_osSectionSeekbarProgress, this.mMin);
        this.mCurrentSection = this.calculateCurrentSection();
        this.mSectionCount = a.getInteger(R.styleable.OSSectionSeekbar_osSectionSeekbarSectionCount, 5);
        this.mDisplayCharacters = a.getBoolean(R.styleable.OSSectionSeekbar_osSectionSeekbarDisplayCharacters, true);
        this.setEnabled(a.getBoolean(R.styleable.OSSectionSeekbar_android_enabled, this.isEnabled()));
        a.recycle();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mCirclePaint = new Paint();
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setStrokeCap(Paint.Cap.ROUND);
        this.mCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mRectText = new Rect();
        this.mTextSpace = OSSectionSeekbar.dp2px(2);
        this.initConfigByPriority();
    }

    private void initConfigByPriority() {
        if (this.mMin == this.mMax) {
            this.mMin = 0.0f;
            this.mMax = 100.0f;
        }
        if (this.mMin > this.mMax) {
            float tmp = this.mMax;
            this.mMax = this.mMin;
            this.mMin = tmp;
        }
        if (this.mProgress < this.mMin) {
            this.mProgress = this.mMin;
        }
        if (this.mProgress > this.mMax) {
            this.mProgress = this.mMax;
        }
        if (this.mSecondTrackSize < this.mTrackSize) {
            this.mSecondTrackSize = this.mTrackSize + OSSectionSeekbar.dp2px(2);
        }
        if (this.mThumbRadius * 2 <= this.mSecondTrackSize) {
            this.mThumbRadius = this.mSecondTrackSize / 2 + OSSectionSeekbar.dp2px(2);
        }
        if (this.mSectionCount <= 0) {
            this.mSectionCount = 10;
        }
        this.mDelta = this.mMax - this.mMin;
        this.mSectionValue = this.mDelta / (float)this.mSectionCount;
        if (this.mSectionValue < 1.0f) {
            this.isFloatType = true;
        }
        if (this.mSectionTextInterval < 1) {
            this.mSectionTextInterval = 1;
        }
        this.initSectionTextArray();
        this.setProgress(this.mProgress);
    }

    private void initSectionTextArray() {
        boolean ifInterval = this.mSectionTextInterval > 1 && this.mSectionCount % 2 == 0;
        for (int i = 0; i <= this.mSectionCount; ++i) {
            float sectionValue = this.mMin + this.mSectionValue * (float)i;
            if (ifInterval) {
                if (i % this.mSectionTextInterval != 0) continue;
                sectionValue = this.mMin + this.mSectionValue * (float)i;
            }
            this.mSectionTextArray.put(i, (Object)(this.isFloatType ? this.float2String(sectionValue) : String.valueOf((int)sectionValue)));
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int height = this.mThumbRadius * 2;
        this.mPaint.setTextSize((float)this.mSectionTextSize);
        String text = (String)this.mSectionTextArray.get(0);
        this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
        if (this.mDisplayCharacters) {
            height = Math.max(height, this.mThumbRadius * 2 + this.mRectText.height());
            height += this.mRectText.height();
        }
        this.setMeasuredDimension(OSSectionSeekbar.resolveSize((int)OSSectionSeekbar.dp2px(180), (int)widthMeasureSpec), height);
        this.mLeft = this.getPaddingLeft() + this.mThumbRadius;
        this.mRight = this.getMeasuredWidth() - this.getPaddingRight() - this.mThumbRadius;
        this.mPaint.setTextSize((float)this.mSectionTextSize);
        float max = Math.max((float)this.mThumbRadius, (float)this.mRectText.width() / 2.0f);
        this.mLeft = (float)this.getPaddingLeft() + max + (float)this.mTextSpace;
        text = (String)this.mSectionTextArray.get(this.mSectionCount);
        this.mPaint.getTextBounds(text, 0, text.length(), this.mRectText);
        max = Math.max((float)this.mThumbRadius, (float)this.mRectText.width() / 2.0f);
        this.mRight = (float)(this.getMeasuredWidth() - this.getPaddingRight()) - max - (float)this.mTextSpace;
        this.mTrackLength = this.mRight - this.mLeft;
        this.mSectionOffset = this.mTrackLength * 1.0f / (float)this.mSectionCount;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float yTop = this.getPaddingTop() + this.mThumbRadius;
        this.mPaint.setColor(this.mSectionTextColor);
        this.mPaint.setTextSize((float)this.mSectionTextSize);
        float xLeft = this.mLeft;
        float xRight = this.mRight;
        float y_ = yTop + (float)this.mRectText.height() + (float)this.mThumbRadius + (float)OSSectionSeekbar.dp2px(6);
        float r = (float)(this.mThumbRadius - OSSectionSeekbar.dp2px(4)) / 2.0f;
        for (int i = 0; i <= this.mSectionCount; ++i) {
            float x_ = Utils.isRtl() ? xRight - (float)i * this.mSectionOffset : xLeft + (float)i * this.mSectionOffset;
            this.mPaint.setColor(this.mDotsColor);
            if (i != this.mCurrentSection) {
                canvas.drawCircle(x_, yTop, r, this.mPaint);
            }
            this.mPaint.setColor(this.mSectionTextColor);
            if (this.mSectionTextArray.get(Utils.isRtl() ? this.mSectionCount - i : i, null) == null || !this.mDisplayCharacters) continue;
            canvas.drawText((String)this.mSectionTextArray.get(i), x_, y_, this.mPaint);
        }
        if (!this.isThumbOnDragging) {
            this.mThumbCenterX = Utils.isRtl() ? xRight - this.mTrackLength / this.mDelta * (this.mProgress - this.mMin) : xLeft + this.mTrackLength / this.mDelta * (this.mProgress - this.mMin);
        }
        this.mPaint.setColor(this.mSecondTrackColor);
        this.mPaint.setStrokeWidth((float)this.mSecondTrackSize);
        canvas.drawLine(xLeft, yTop, this.mThumbCenterX, yTop, this.mPaint);
        this.mPaint.setColor(this.mTrackColor);
        this.mPaint.setStrokeWidth((float)this.mTrackSize);
        canvas.drawLine(this.mThumbCenterX, yTop, xRight, yTop, this.mPaint);
        this.mCirclePaint.setColor(this.mThumbOutColor);
        this.mCirclePaint.setStyle(Paint.Style.STROKE);
        this.mCirclePaint.setStrokeWidth((float)(this.mThumbRadius >> 1));
        canvas.drawCircle(this.mThumbCenterX, yTop, (float)(this.mThumbRadius * 3 >> 2), this.mCirclePaint);
        this.mCirclePaint.setStyle(Paint.Style.FILL);
        this.mCirclePaint.setColor(this.mThumbInsideColor);
        canvas.drawCircle(this.mThumbCenterX, yTop, (float)(this.mThumbRadius >> 1), this.mCirclePaint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.post(new Runnable(){

            @Override
            public void run() {
                OSSectionSeekbar.this.requestLayout();
            }
        });
    }

    public boolean performClick() {
        return super.performClick();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.performClick();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.isThumbOnDragging = this.isEnabled();
                if (!this.isThumbOnDragging) break;
                this.mThumbCenterX = this.mPreThumbCenterX = this.calThumbCxWhenSeekStepSection(event.getX());
                this.mProgress = this.calculateProgress();
                this.mCurrentSection = this.calculateCurrentSection();
                this.invalidate();
                if (this.mProgressListener == null) break;
                this.mProgressListener.onStartTrackingTouch(this);
                break;
            }
            case 2: {
                this.isThumbOnDragging = this.isEnabled();
                if (!this.isThumbOnDragging) break;
                boolean flag = true;
                float x = this.calThumbCxWhenSeekStepSection(event.getX());
                if (x != this.mPreThumbCenterX) {
                    this.mThumbCenterX = this.mPreThumbCenterX = x;
                } else {
                    flag = false;
                }
                if (!flag) break;
                this.mProgress = this.calculateProgress();
                this.mCurrentSection = this.calculateCurrentSection();
                this.invalidate();
                if (this.mProgressListener == null) break;
                this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), true);
                break;
            }
            case 1: 
            case 3: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                this.isThumbOnDragging = false;
                if (this.mProgressListener == null) break;
                this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), true);
                this.mProgressListener.onStopTrackingTouch(this);
            }
        }
        return this.isThumbOnDragging || super.onTouchEvent(event);
    }

    private float calThumbCxWhenSeekStepSection(float touchedX) {
        int i;
        if (touchedX <= this.mLeft) {
            return this.mLeft;
        }
        if (touchedX >= this.mRight) {
            return this.mRight;
        }
        float x = 0.0f;
        for (i = 0; !(i > this.mSectionCount || (x = (float)i * this.mSectionOffset + this.mLeft) <= touchedX && touchedX - x <= this.mSectionOffset); ++i) {
        }
        if (touchedX - x <= this.mSectionOffset / 2.0f) {
            return x;
        }
        return (float)(i + 1) * this.mSectionOffset + this.mLeft;
    }

    private String float2String(float value) {
        return String.valueOf(this.formatFloat(value));
    }

    private float formatFloat(float value) {
        BigDecimal bigDecimal = BigDecimal.valueOf(value);
        return bigDecimal.setScale(1, 4).floatValue();
    }

    private float calculateProgress() {
        if (Utils.isRtl()) {
            return (this.mRight - this.mThumbCenterX) * this.mDelta / this.mTrackLength + this.mMin;
        }
        return (this.mThumbCenterX - this.mLeft) * this.mDelta / this.mTrackLength + this.mMin;
    }

    private int calculateCurrentSection() {
        return Math.round(this.mProgress / this.mDelta * (float)this.mSectionCount);
    }

    public float getMin() {
        return this.mMin;
    }

    public float getMax() {
        return this.mMax;
    }

    public void setProgress(float progress) {
        this.mProgress = (float)Math.round(progress / this.mDelta * (float)this.mSectionCount) * this.mDelta / (float)this.mSectionCount;
        this.mCurrentSection = this.calculateCurrentSection();
        if (this.mProgressListener != null) {
            this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), false);
        }
        this.postInvalidate();
    }

    public int getProgress() {
        return Math.round(this.mProgress);
    }

    public float getProgressFloat() {
        return this.mProgress;
    }

    public OnProgressChangedListener getOnProgressChangedListener() {
        return this.mProgressListener;
    }

    public void setOnProgressChangedListener(OnProgressChangedListener onProgressChangedListener) {
        this.mProgressListener = onProgressChangedListener;
    }

    public void setTrackColor(int trackColor) {
        if (this.mTrackColor != trackColor) {
            this.mTrackColor = trackColor;
            this.invalidate();
        }
    }

    public void setSecondTrackColor(int secondTrackColor) {
        if (this.mSecondTrackColor != secondTrackColor) {
            this.mSecondTrackColor = secondTrackColor;
            this.invalidate();
        }
    }

    public void setThumbOutColor(int thumbColor) {
        if (this.mThumbOutColor != thumbColor) {
            this.mThumbOutColor = thumbColor;
            this.invalidate();
        }
    }

    public void setThumbInsideColor(int thumbColor) {
        if (this.mThumbInsideColor != thumbColor) {
            this.mThumbInsideColor = thumbColor;
            this.invalidate();
        }
    }

    public void setCustomSectionTextArray(CustomSectionTextArray customSectionTextArray) {
        this.mSectionTextArray = customSectionTextArray.onCustomize(this.mSectionCount, this.mSectionTextArray);
        for (int i = 0; i <= this.mSectionCount; ++i) {
            if (this.mSectionTextArray.get(i) != null) continue;
            this.mSectionTextArray.put(i, (Object)"");
        }
        this.requestLayout();
        this.invalidate();
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("save_instance", super.onSaveInstanceState());
        bundle.putFloat("progress", this.mProgress);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mProgress = bundle.getFloat("progress");
            this.mCurrentSection = this.calculateCurrentSection();
            super.onRestoreInstanceState(bundle.getParcelable("save_instance"));
            this.setProgress(this.mProgress);
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mThumbOutColor = enabled ? this.thumbOutColor() : ContextCompat.getColor((Context)this.mContext, (int)R.color.os_gray_solid_primary_color);
        this.invalidate();
    }

    private int thumbOutColor() {
        TypedValue typedValue = new TypedValue();
        if (this.mContext.getTheme().resolveAttribute(R.attr.os_platform_basic_color, typedValue, true)) {
            return ContextCompat.getColor((Context)this.mContext, (int)typedValue.resourceId);
        }
        return ContextCompat.getColor((Context)this.mContext, (int)R.color.os_platform_basic_color_hios);
    }

    public OSSectionSeekBarBuilder getConfigBuilder() {
        if (this.mOSSectionSeekBarBuilder == null) {
            this.mOSSectionSeekBarBuilder = new OSSectionSeekBarBuilder(this);
        }
        return this.mOSSectionSeekBarBuilder;
    }

    void config(OSSectionSeekBarBuilder builder) {
        this.mMin = builder.min;
        this.mMax = builder.max;
        this.mProgress = builder.progress;
        this.isFloatType = builder.floatType;
        this.mTrackSize = builder.trackSize;
        this.mSecondTrackSize = builder.secondTrackSize;
        this.mThumbRadius = builder.thumbRadius;
        this.mTrackColor = builder.trackColor;
        this.mSecondTrackColor = builder.secondTrackColor;
        this.mThumbOutColor = builder.thumbOutColor;
        this.mThumbInsideColor = builder.thumbInsideColor;
        this.mDotsColor = builder.dotsColor;
        this.mSectionCount = builder.sectionCount;
        this.mSectionTextSize = builder.sectionTextSize;
        this.mSectionTextColor = builder.sectionTextColor;
        this.mSectionTextInterval = builder.sectionTextInterval;
        this.mDisplayCharacters = builder.displayCharacters;
        this.initConfigByPriority();
        if (this.mProgressListener != null) {
            this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), false);
        }
        this.mOSSectionSeekBarBuilder = null;
        this.requestLayout();
    }

    static int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    static int sp2px(int sp) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static class OSSectionSeekBarBuilder {
        float min;
        float max;
        float progress;
        boolean floatType;
        boolean displayCharacters;
        int trackSize;
        int secondTrackSize;
        int sectionTextSize;
        int thumbRadius;
        int sectionCount;
        int trackColor;
        int secondTrackColor;
        int thumbOutColor;
        int thumbInsideColor;
        int sectionTextColor;
        int dotsColor;
        int sectionTextInterval;
        private WeakReference<OSSectionSeekbar> osSectionSeekbarWeakReference;

        OSSectionSeekBarBuilder(OSSectionSeekbar osSectionSeekbar) {
            if (osSectionSeekbar != null) {
                this.osSectionSeekbarWeakReference = new WeakReference<OSSectionSeekbar>(osSectionSeekbar);
                this.min = 0.0f;
                this.max = 100.0f;
                this.progress = 0.0f;
                this.trackSize = OSSectionSeekbar.dp2px(16);
                this.secondTrackSize = OSSectionSeekbar.dp2px(16);
                this.sectionTextSize = OSSectionSeekbar.sp2px(12);
                this.thumbRadius = OSSectionSeekbar.dp2px(10);
                this.sectionCount = 5;
                this.floatType = false;
                this.displayCharacters = true;
                this.trackColor = ContextCompat.getColor((Context)osSectionSeekbar.mContext, (int)R.color.os_gray_tertiary_color);
                this.secondTrackColor = ContextCompat.getColor((Context)osSectionSeekbar.mContext, (int)R.color.os_gray_tertiary_color);
                this.thumbOutColor = osSectionSeekbar.thumbOutColor();
                this.thumbInsideColor = ContextCompat.getColor((Context)osSectionSeekbar.mContext, (int)R.color.os_section_seekbar_thumbinside_color);
                this.sectionTextColor = ContextCompat.getColor((Context)osSectionSeekbar.mContext, (int)R.color.os_text_tertiary_color);
                this.dotsColor = ContextCompat.getColor((Context)osSectionSeekbar.mContext, (int)R.color.os_gray_primary_color);
            }
        }

        public void build() {
            if (this.osSectionSeekbarWeakReference.get() != null) {
                ((OSSectionSeekbar)((Object)this.osSectionSeekbarWeakReference.get())).config(this);
            }
        }

        @Deprecated
        public OSSectionSeekBarBuilder min(float min) {
            this.min = min;
            this.progress = min;
            return this;
        }

        public OSSectionSeekBarBuilder max(float max) {
            this.max = max;
            return this;
        }

        public OSSectionSeekBarBuilder progress(float progress) {
            this.progress = progress;
            return this;
        }

        public OSSectionSeekBarBuilder floatType() {
            this.floatType = true;
            return this;
        }

        public OSSectionSeekBarBuilder trackSize(int dp) {
            this.trackSize = OSSectionSeekbar.dp2px(dp);
            return this;
        }

        public OSSectionSeekBarBuilder secondTrackSize(int dp) {
            this.secondTrackSize = OSSectionSeekbar.dp2px(dp);
            return this;
        }

        public OSSectionSeekBarBuilder thumbRadius(int dp) {
            this.thumbRadius = OSSectionSeekbar.dp2px(dp);
            return this;
        }

        public OSSectionSeekBarBuilder trackColor(int color2) {
            this.trackColor = color2;
            return this;
        }

        public OSSectionSeekBarBuilder dotsColor(int color2) {
            this.dotsColor = color2;
            return this;
        }

        public OSSectionSeekBarBuilder secondTrackColor(int color2) {
            this.secondTrackColor = color2;
            return this;
        }

        public OSSectionSeekBarBuilder thumbOutColor(int color2) {
            this.thumbOutColor = color2;
            return this;
        }

        public OSSectionSeekBarBuilder thumbInsideColor(int color2) {
            this.thumbInsideColor = color2;
            return this;
        }

        public OSSectionSeekBarBuilder sectionCount(int count) {
            this.sectionCount = count;
            return this;
        }

        public OSSectionSeekBarBuilder displayCharacters(boolean displayCharacters) {
            this.displayCharacters = displayCharacters;
            return this;
        }

        public OSSectionSeekBarBuilder sectionTextSize(int sp) {
            this.sectionTextSize = OSSectionSeekbar.sp2px(sp);
            return this;
        }

        public OSSectionSeekBarBuilder sectionTextColor(int color2) {
            this.sectionTextColor = color2;
            return this;
        }

        public OSSectionSeekBarBuilder sectionTextInterval(int interval) {
            this.sectionTextInterval = interval;
            return this;
        }
    }

    public static interface CustomSectionTextArray {
        public SparseArray<String> onCustomize(int var1, SparseArray<String> var2);
    }

    public static interface OnProgressChangedListener {
        public void onProgressChanged(OSSectionSeekbar var1, int var2, float var3, boolean var4);

        public void onStartTrackingTouch(OSSectionSeekbar var1);

        public void onStopTrackingTouch(OSSectionSeekbar var1);
    }
}

