/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.tablayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.TextView;
import androidx.annotation.ArrayRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.widget.tablayout.TabLayout;
import java.util.Arrays;
import java.util.List;

public class OSTabLayout
extends LinearLayout
implements View.OnClickListener {
    private TabLayout mTabLayout;
    private ImageView mOverflowButton;
    private List<String> mPopupItems;
    private ListPopupWindow mPopupWindow;
    private OnItemClickListener mItemClickListener;
    private boolean[] mOverflowState;
    private boolean mIsFirstLevelTab;

    public OSTabLayout(Context context) {
        this(context, null);
    }

    public OSTabLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.os_tab_layout, null);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OSTabLayout);
        this.mIsFirstLevelTab = a.getBoolean(R.styleable.OSTabLayout_osIsFirstLevelTab, false);
        int[] attrBg = new int[]{R.attr.OsBgPrimary};
        TypedArray typedArray = context.obtainStyledAttributes(attrBg);
        int defaultColor = typedArray.getColor(0, ContextCompat.getColor((Context)context, (int)R.color.os_bg_primary_color));
        typedArray.recycle();
        int background = a.getColor(R.styleable.OSTabLayout_osTabLayoutBackground, defaultColor);
        view.setBackgroundColor(background);
        a.recycle();
        View line = view.findViewById(R.id.tablayout_underline);
        if (this.mIsFirstLevelTab) {
            line.setVisibility(8);
        } else {
            line.setVisibility(0);
        }
        this.mTabLayout = (TabLayout)view.findViewById(R.id.tablayout);
        this.mOverflowButton = (ImageView)view.findViewById(R.id.overFlowButton);
        this.mOverflowButton.setOnClickListener((View.OnClickListener)this);
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    public TabLayout getTabLayout() {
        this.mTabLayout.isFirstLevelTab(this.mIsFirstLevelTab);
        return this.mTabLayout;
    }

    public void onClick(View v) {
        if (v == this.mOverflowButton && this.mPopupWindow != null) {
            this.mPopupWindow.show();
        }
    }

    public void setBackground(int resId) {
        this.setBackgroundResource(resId);
    }

    public void setOverflowImage(@DrawableRes int resId) {
        if (this.mOverflowButton != null) {
            this.mOverflowButton.setBackground(this.getResources().getDrawable(resId));
        }
    }

    public void setOverflowItemState(int position, boolean enable) {
        if (this.mOverflowState != null) {
            this.mOverflowState[position] = enable;
        }
    }

    public void setOverFlowMenuItem(@ArrayRes int resId) {
        this.mOverflowButton.setVisibility(0);
        this.mPopupItems = Arrays.asList(this.getResources().getStringArray(resId));
        this.initOverflowItemState(this.mPopupItems);
        TabOverflowPopupAdapter adapter = new TabOverflowPopupAdapter();
        this.mPopupWindow = new ListPopupWindow(this.getContext(), null, 0, R.style.OsFootOptPopupStyle);
        this.mPopupWindow.setAnchorView((View)this.mOverflowButton);
        this.mPopupWindow.setAdapter((ListAdapter)adapter);
        this.mPopupWindow.setContentWidth(this.measureMaxWidth((ListAdapter)adapter, this.getResources().getDisplayMetrics().widthPixels / 2));
    }

    private void initOverflowItemState(List<String> popupItems) {
        if (popupItems != null) {
            this.mOverflowState = new boolean[this.mPopupItems.size()];
            for (int i = 0; i < popupItems.size(); ++i) {
                this.mOverflowState[i] = true;
            }
        }
    }

    private int measureMaxWidth(ListAdapter adapter, int maxAllowedWidth) {
        int maxWidth = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            itemView = adapter.getView(i, itemView, null);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            int itemWidth = itemView.getMeasuredWidth();
            if (itemWidth >= maxAllowedWidth) {
                return maxAllowedWidth;
            }
            if (itemWidth <= maxWidth) continue;
            maxWidth = itemWidth;
        }
        return maxWidth;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mItemClickListener = onItemClickListener;
    }

    private void viewEnable(View view, boolean enAble) {
        view.setEnabled(enAble);
        view.setAlpha(enAble ? 1.0f : 0.3f);
    }

    private class TabOverflowPopupAdapter
    extends BaseAdapter {
        private TabOverflowPopupAdapter() {
        }

        public int getCount() {
            return OSTabLayout.this.mPopupItems.size();
        }

        public Object getItem(int position) {
            return OSTabLayout.this.mPopupItems.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(final int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                holder = new ViewHolder();
                convertView = LayoutInflater.from((Context)OSTabLayout.this.getContext()).inflate(R.layout.os_tab_overflow_popup_item, parent, false);
                holder.title = (TextView)convertView.findViewById(R.id.os_tab_overflow_popup_item_text);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            convertView.setBackgroundResource(R.drawable.os_press_primary_bg);
            holder.title.setText((CharSequence)OSTabLayout.this.mPopupItems.get(position));
            OSTabLayout.this.viewEnable(convertView, OSTabLayout.this.mOverflowState[position]);
            convertView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (OSTabLayout.this.mItemClickListener != null) {
                        OSTabLayout.this.mItemClickListener.onItemClick(position);
                    }
                    OSTabLayout.this.mPopupWindow.dismiss();
                }
            });
            return convertView;
        }

        private class ViewHolder {
            private TextView title;

            private ViewHolder() {
            }
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);
    }
}

