/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.zeroscreencore.card.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.gemini.gamefolder.util.DataTools;
import com.transsion.core.log.LogUtils;
import com.transsion.zeroscreencore.R;
import com.transsion.zeroscreencore.card.view.CBLoopViewPager;
import com.transsion.zeroscreencore.card.view.f;
import com.transsion.zeroscreencore.utils.AssetsUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class ConvenientBanner<T>
extends LinearLayout {
    private static final String TAG = "ConvenientBanner";
    private List<T> mDatas;
    private int[] page_indicatorId;
    private ArrayList<ImageView> mPointViews = new ArrayList();
    private com.transsion.zeroscreencore.card.a.a pageChangeListener;
    private ViewPager.OnPageChangeListener onPageChangeListener;
    private com.transsion.zeroscreencore.card.a.f listener;
    private com.transsion.zeroscreencore.card.b.b pageAdapter;
    private CBLoopViewPager viewPager;
    private f scroller;
    private ViewGroup loPageTurningPoint;
    private long autoTurningTime;
    private boolean canTurn = false;
    private boolean canLoop = true;
    public static boolean isScrollingAllowed = true;
    public static boolean isTurning = false;
    public boolean needDefaultTurning = true;
    private a adSwitchTask;
    private static Handler timeHandler = new Handler();

    public ConvenientBanner(Context context, boolean bl) {
        super(context);
        this.init(context);
    }

    public ConvenientBanner(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ConvenientBanner);
        this.canLoop = typedArray.getBoolean(R.styleable.ConvenientBanner_canLoop, true);
        typedArray.recycle();
        this.init(context);
    }

    @TargetApi(value=11)
    public ConvenientBanner(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ConvenientBanner);
        this.canLoop = typedArray.getBoolean(R.styleable.ConvenientBanner_canLoop, true);
        typedArray.recycle();
        this.init(context);
    }

    @TargetApi(value=21)
    public ConvenientBanner(Context context, AttributeSet attributeSet, int n2, int n3) {
        super(context, attributeSet, n2, n3);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ConvenientBanner);
        this.canLoop = typedArray.getBoolean(R.styleable.ConvenientBanner_canLoop, true);
        typedArray.recycle();
        this.init(context);
    }

    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.include_viewpager, (ViewGroup)this, true);
        this.viewPager = (CBLoopViewPager)view.findViewById(R.id.cbLoopViewPager);
        this.loPageTurningPoint = (ViewGroup)view.findViewById(R.id.loPageTurningPoint);
        this.needDefaultTurning = !"false".equals(AssetsUtil.getInstance(context).getIfNeedTurning("game_lobby_banner_is_turning_key", "true"));
        this.initViewPagerScroll();
        this.adSwitchTask = new a(this);
    }

    public ConvenientBanner setPages(com.transsion.zeroscreencore.card.a.b b2, List<T> list) {
        this.mDatas = list;
        this.pageAdapter = new com.transsion.zeroscreencore.card.b.b<T>(b2, this.mDatas);
        this.viewPager.a(this.pageAdapter, this.canLoop);
        if (this.page_indicatorId != null) {
            this.setPageIndicator(this.page_indicatorId);
        }
        return this;
    }

    public void notifyDataSetChanged() {
        this.viewPager.getAdapter().notifyDataSetChanged();
        if (this.page_indicatorId != null) {
            this.setPageIndicator(this.page_indicatorId);
        }
    }

    public ConvenientBanner setPointViewVisible(boolean bl) {
        this.loPageTurningPoint.setVisibility(bl ? 0 : 8);
        return this;
    }

    public ConvenientBanner setPageIndicator(int[] nArray) {
        this.loPageTurningPoint.removeAllViews();
        this.mPointViews.clear();
        this.page_indicatorId = nArray;
        if (this.mDatas == null) {
            return this;
        }
        for (int i2 = 0; i2 < this.mDatas.size(); ++i2) {
            ImageView imageView = new ImageView(this.getContext());
            int n2 = DataTools.dip2px((Context)this.getContext(), (float)0.0f);
            int n3 = DataTools.dip2px((Context)this.getContext(), (float)5.0f);
            imageView.setPadding(n3, 0, n3, n2);
            if (this.mPointViews.isEmpty()) {
                imageView.setImageResource(nArray[1]);
            } else {
                imageView.setImageResource(nArray[0]);
            }
            this.mPointViews.add(imageView);
            this.loPageTurningPoint.addView((View)imageView);
        }
        this.pageChangeListener = new com.transsion.zeroscreencore.card.a.a(this.mPointViews, nArray);
        this.viewPager.setOnPageChangeListener(this.pageChangeListener);
        this.pageChangeListener.onPageSelected(this.viewPager.getRealItem());
        if (this.onPageChangeListener != null) {
            this.pageChangeListener.a(this.onPageChangeListener);
        }
        return this;
    }

    public ConvenientBanner setPageIndicatorAlign(b b2) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.loPageTurningPoint.getLayoutParams();
        layoutParams.addRule(9, b2 == b.a ? -1 : 0);
        layoutParams.addRule(11, b2 == b.b ? -1 : 0);
        layoutParams.addRule(14, b2 == b.c ? -1 : 0);
        this.loPageTurningPoint.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return this;
    }

    public boolean isTurning() {
        return isTurning;
    }

    public ConvenientBanner startTurning(long l2) {
        if (isTurning && this.needDefaultTurning) {
            this.stopTurning();
        }
        this.canTurn = true;
        this.autoTurningTime = l2;
        isTurning = true;
        timeHandler.postDelayed((Runnable)this.adSwitchTask, l2);
        isScrollingAllowed = true;
        LogUtils.i((String)TAG, (Object[])new Object[]{"startTurning" + isScrollingAllowed});
        return this;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startTurning(this.autoTurningTime);
        LogUtils.i((String)TAG, (Object[])new Object[]{"onAttachedToWindow" + isScrollingAllowed});
    }

    public void stopTurning() {
        LogUtils.i((String)TAG, (Object[])new Object[]{"stopTurning"});
        isScrollingAllowed = false;
        isTurning = false;
        timeHandler.removeCallbacks((Runnable)this.adSwitchTask);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        isScrollingAllowed = true;
        isTurning = false;
        timeHandler.removeCallbacks((Runnable)this.adSwitchTask);
    }

    public ConvenientBanner setPageTransformer(ViewPager.PageTransformer pageTransformer) {
        this.viewPager.setPageTransformer(true, pageTransformer);
        return this;
    }

    private void initViewPagerScroll() {
        try {
            Field field = null;
            field = ViewPager.class.getDeclaredField("mScroller");
            field.setAccessible(true);
            this.scroller = new f(this.viewPager.getContext());
            field.set((Object)this.viewPager, (Object)this.scroller);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public boolean isManualPageable() {
        return this.viewPager.a();
    }

    public void setManualPageable(boolean bl) {
        this.viewPager.setCanScroll(bl);
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: 
            case 2: {
                if (!this.canTurn) break;
                this.stopTurning();
                break;
            }
            case 1: 
            case 4: {
                if (!this.canTurn) break;
                this.startTurning(this.autoTurningTime);
                break;
            }
            case 3: {
                this.canTurn = true;
                isTurning = true;
                isScrollingAllowed = true;
                timeHandler.postDelayed((Runnable)this.adSwitchTask, this.autoTurningTime);
                break;
            }
        }
        LogUtils.i((String)"isScrollingAllowed", (Object[])new Object[]{"isScrollingAllowed = " + isScrollingAllowed + motionEvent.getAction() + "turning" + isTurning});
        return super.dispatchTouchEvent(motionEvent);
    }

    public int getCurrentItem() {
        if (this.viewPager != null) {
            return this.viewPager.getRealItem();
        }
        return -1;
    }

    public void setcurrentitem(int n2) {
        if (this.viewPager != null) {
            this.viewPager.setCurrentItem(n2);
        }
    }

    public ViewPager.OnPageChangeListener getOnPageChangeListener() {
        return this.onPageChangeListener;
    }

    public ConvenientBanner setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        this.onPageChangeListener = onPageChangeListener;
        if (this.pageChangeListener != null) {
            this.pageChangeListener.a(onPageChangeListener);
        } else {
            this.viewPager.setOnPageChangeListener(onPageChangeListener);
        }
        return this;
    }

    public boolean isCanLoop() {
        return this.viewPager.b();
    }

    public ConvenientBanner setOnItemClickListener(com.transsion.zeroscreencore.card.a.f f2) {
        if (f2 == null) {
            this.viewPager.setOnItemClickListener(null);
            return this;
        }
        this.viewPager.setOnItemClickListener(f2);
        return this;
    }

    public void setScrollDuration(int n2) {
        this.scroller.a(n2);
    }

    public int getScrollDuration() {
        return this.scroller.a();
    }

    public CBLoopViewPager getViewPager() {
        return this.viewPager;
    }

    public void setCanLoop(boolean bl) {
        this.canLoop = bl;
        this.viewPager.setCanLoop(bl);
    }

    static class a
    implements Runnable {
        private final WeakReference<ConvenientBanner> a;

        a(ConvenientBanner convenientBanner) {
            this.a = new WeakReference<ConvenientBanner>(convenientBanner);
        }

        @Override
        public void run() {
            ConvenientBanner convenientBanner = (ConvenientBanner)((Object)this.a.get());
            if (convenientBanner != null && convenientBanner.viewPager != null && isTurning && convenientBanner.needDefaultTurning) {
                if (convenientBanner.isShown()) {
                    int n2 = convenientBanner.viewPager.getCurrentItem() + 1;
                    convenientBanner.viewPager.setCurrentItem(n2);
                }
                timeHandler.postDelayed((Runnable)convenientBanner.adSwitchTask, convenientBanner.autoTurningTime);
            }
        }
    }

    public static enum b {
        a,
        b,
        c;

    }
}

