/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.zeroscreencore.card.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.transsion.zeroscreencore.R;

public class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    private static final int[] ATTRS = new int[]{16843284};
    private static final int mDividerHeight = 1;
    private float scale;
    private Paint mPaint;
    private Context mContext;

    public DividerItemDecoration(Context context) {
        this.mContext = context;
        this.mPaint = new Paint();
        this.mPaint.setColor(context.getResources().getColor(R.color.divider_bg));
        this.scale = context.getResources().getDisplayMetrics().density;
    }

    public void onDraw(Canvas canvas, RecyclerView recyclerView, RecyclerView.State state) {
        int n2 = recyclerView.getChildCount();
        int n3 = recyclerView.getPaddingLeft() + (int)this.mContext.getResources().getDimension(R.dimen.zero_9dp);
        int n4 = recyclerView.getWidth() - recyclerView.getPaddingRight() - (int)this.mContext.getResources().getDimension(R.dimen.zero_9dp);
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = recyclerView.getChildAt(i2);
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
            int n5 = view.getBottom() + layoutParams.bottomMargin;
            int n6 = n5 + 1;
            canvas.drawRect((float)n3, (float)n5, (float)n4, (float)n6, this.mPaint);
        }
    }

    public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        rect.set(0, 0, 0, 1);
    }
}

