/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.zeroscreencore.manger;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.transsion.core.log.LogUtils;
import com.transsion.core.utils.SharedPreferencesUtil;
import com.transsion.zeroscreencore.R;
import com.transsion.zeroscreencore.bean.CardIndexBean;
import com.transsion.zeroscreencore.bean.PushIndexCardBean;
import com.transsion.zeroscreencore.constants.GlobalValue;
import com.transsion.zeroscreencore.manger.b;
import com.transsion.zeroscreencore.manger.d;
import com.transsion.zeroscreencore.receiver.HomeKeyEventReceiver;
import com.transsion.zeroscreencore.utils.AssetsUtil;
import com.transsion.zeroscreencore.utils.JsonUtil;
import com.transsion.zeroscreencore.utils.TimeUtil;
import com.transsion.zeroscreencore.view.ExternalView;
import com.transsion.zeroscreencore.view.ZeroScreenView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CardManager
implements d<PushIndexCardBean> {
    private static final String TAG = "CardManager";
    public static Boolean isNewCardUpdate = false;
    private static CardManager mCardConfigManager = null;
    public static String ShowCardListKey = "SHOW_CARDLIST_KEY1.2.026";
    public static String HideCardListKey = "HIDE_CARDLIST_KEY1.2.026";
    private Context mContext = null;
    private List<CardIndexBean> listShowCards = new ArrayList<CardIndexBean>();
    private List<CardIndexBean> listHideCards = new ArrayList<CardIndexBean>();
    private List<CardIndexBean> defaultCard = new ArrayList<CardIndexBean>();
    private Map<String, List<CardIndexBean>> mapCardList = new HashMap<String, List<CardIndexBean>>();
    private List<WeakReference<a>> listDataControls = new ArrayList<WeakReference<a>>();
    private Map<Integer, ExternalView> mExternalViewMap = new HashMap<Integer, ExternalView>();
    private SharedPreferencesUtil mPrefUtils = null;
    private HomeKeyEventReceiver mHomeKeyEventReceiver = null;

    private void registerHomeKeyReceiver() {
        if (null == this.mHomeKeyEventReceiver) {
            this.mHomeKeyEventReceiver = new HomeKeyEventReceiver();
            this.mContext.registerReceiver((BroadcastReceiver)this.mHomeKeyEventReceiver, new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
        }
    }

    private void unregisterHomeKeyReceiver() {
        if (null != this.mHomeKeyEventReceiver) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mHomeKeyEventReceiver);
            this.mHomeKeyEventReceiver = null;
        }
    }

    public static CardManager getInstance(Context context) {
        if (null == mCardConfigManager) {
            mCardConfigManager = new CardManager(context.getApplicationContext());
        }
        return mCardConfigManager;
    }

    private CardManager(Context context) {
        this.mContext = context.getApplicationContext();
        if (this.defaultCard == null) {
            this.defaultCard = new ArrayList<CardIndexBean>();
        }
        com.transsion.zeroscreencore.manger.a.a(this.mContext, 1800000L, 1000.0f);
        this.registerHomeKeyReceiver();
        CardIndexBean cardIndexBean = new CardIndexBean();
        if (Build.VERSION.SDK_INT > 20) {
            cardIndexBean.cardName = this.mContext.getResources().getString(R.string.card_video);
            cardIndexBean.cardID = 40;
            cardIndexBean.resCardIcon = R.mipmap.video_icon;
            this.defaultCard.add(cardIndexBean);
        }
        CardIndexBean cardIndexBean2 = new CardIndexBean();
        cardIndexBean2.cardName = this.mContext.getResources().getString(R.string.card_news);
        cardIndexBean2.cardID = 30;
        cardIndexBean2.resCardIcon = R.mipmap.news_icon;
        CardIndexBean cardIndexBean3 = new CardIndexBean();
        cardIndexBean3.cardName = this.mContext.getResources().getString(R.string.card_game);
        cardIndexBean3.cardID = 20;
        cardIndexBean3.resCardIcon = R.mipmap.lobby_game_icon;
        this.defaultCard.add(cardIndexBean2);
        this.defaultCard.add(cardIndexBean3);
        this.mPrefUtils = SharedPreferencesUtil.getInstance((String)"ZeroScreen");
    }

    public void getPushCardListFromNet() {
        b.a().a(this.mContext, PushIndexCardBean.class, this);
    }

    @Override
    public void OnRequestPushCardDataSuccess(List<PushIndexCardBean> list) {
        boolean bl;
        this.mPrefUtils.putString("refresh_pushcard_lasttime", TimeUtil.getCurrentTime());
        this.getCardListConfigInfo();
        for (CardIndexBean object : this.listShowCards) {
            bl = true;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                PushIndexCardBean pushIndexCardBean = list.get(i2);
                if (object.cardID != pushIndexCardBean.getCard_id()) continue;
                this.PushCardBeanTOCardBean(object, pushIndexCardBean);
                bl = false;
                list.remove(i2);
                break;
            }
            if (!bl || object.cardID <= 100) continue;
            object.isCardFailure = 1;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            PushIndexCardBean pushIndexCardBean = list.get(n2);
            if (1 == pushIndexCardBean.getCard_default()) {
                bl = true;
                for (CardIndexBean cardIndexBean : this.listHideCards) {
                    if (cardIndexBean.cardID != pushIndexCardBean.getCard_id()) continue;
                    bl = false;
                    ++n2;
                    break;
                }
                if (!bl) continue;
                this.listShowCards.add(this.PushCardBeanTOCardBean(pushIndexCardBean));
                list.remove(n2);
                continue;
            }
            ++n2;
        }
        for (PushIndexCardBean pushIndexCardBean : list) {
            bl = false;
            for (CardIndexBean cardIndexBean : this.listHideCards) {
                if (pushIndexCardBean.getCard_id() != cardIndexBean.cardID) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            isNewCardUpdate = true;
        }
        int n3 = 0;
        while (n3 < this.listHideCards.size()) {
            if (this.listHideCards.get((int)n3).cardID > 100) {
                this.listHideCards.remove(n3);
                continue;
            }
            ++n3;
        }
        for (PushIndexCardBean pushIndexCardBean : list) {
            this.listHideCards.add(this.PushCardBeanTOCardBean(pushIndexCardBean));
        }
        this.SaveCardConfigInfo();
    }

    private void PushCardBeanTOCardBean(CardIndexBean cardIndexBean, PushIndexCardBean pushIndexCardBean) {
        cardIndexBean.cardID = pushIndexCardBean.getCard_id();
        cardIndexBean.cardName = pushIndexCardBean.getCard_app_name();
        cardIndexBean.strCardIcon = pushIndexCardBean.getCard_icon();
        cardIndexBean.cardWeight = pushIndexCardBean.getCard_weight();
        cardIndexBean.cardLabelText = pushIndexCardBean.getCard_label_text();
        cardIndexBean.isNewCard = pushIndexCardBean.getCard_is_new();
        cardIndexBean.isCardFailure = 2;
    }

    private CardIndexBean PushCardBeanTOCardBean(PushIndexCardBean pushIndexCardBean) {
        CardIndexBean cardIndexBean = new CardIndexBean();
        cardIndexBean.cardID = pushIndexCardBean.getCard_id();
        cardIndexBean.cardName = pushIndexCardBean.getCard_app_name();
        cardIndexBean.strCardIcon = pushIndexCardBean.getCard_icon();
        cardIndexBean.cardWeight = pushIndexCardBean.getCard_weight();
        cardIndexBean.cardLabelText = pushIndexCardBean.getCard_label_text();
        cardIndexBean.isNewCard = pushIndexCardBean.getCard_is_new();
        cardIndexBean.isCardFailure = 2;
        return cardIndexBean;
    }

    @Override
    public void OnRequestPushCardDataFailed(String string2) {
    }

    public void DataListenerRegister(a a2) {
        WeakReference<a> weakReference = new WeakReference<a>(a2);
        this.listDataControls.add(weakReference);
    }

    public void RefreshSettingViewImage() {
        if (null != this.listDataControls && !this.listDataControls.isEmpty()) {
            for (WeakReference<a> weakReference : this.listDataControls) {
                if (weakReference.get() == null) continue;
                ((a)weakReference.get()).a();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<CardIndexBean>> getCardListConfigInfo() {
        CardManager cardManager = this;
        synchronized (cardManager) {
            if (!(null != this.listShowCards && this.listShowCards.size() > 0 || null != this.listHideCards && this.listHideCards.size() > 0)) {
                this.listShowCards = com.transsion.zeroscreencore.c.a.a().b(this.mContext, ShowCardListKey, CardIndexBean.class);
                this.listHideCards = com.transsion.zeroscreencore.c.a.a().b(this.mContext, HideCardListKey, CardIndexBean.class);
                if (!(null != this.listShowCards && this.listShowCards.size() > 0 || null != this.listHideCards && this.listHideCards.size() > 0)) {
                    this.initCardConfigInfoList();
                }
            }
            String string2 = this.mPrefUtils.getString("LANGUAGE", "");
            String string3 = this.mContext.getResources().getConfiguration().locale.getLanguage();
            if (!TextUtils.isEmpty((CharSequence)string2) && !string3.equals(string2)) {
                this.resetCardTitle(this.listHideCards);
                this.resetCardTitle(this.listShowCards);
                this.SaveCardConfigList(this.listShowCards, this.listHideCards, false);
            }
            this.mapCardList.put(ShowCardListKey, this.listShowCards);
            this.mapCardList.put(HideCardListKey, this.listHideCards);
            this.mPrefUtils.putString("LANGUAGE", string3);
            return this.mapCardList;
        }
    }

    private void resetCardTitle(List<CardIndexBean> list) {
        for (CardIndexBean cardIndexBean : list) {
            switch (cardIndexBean.cardID) {
                case 40: {
                    cardIndexBean.cardName = this.mContext.getResources().getString(R.string.card_video);
                    break;
                }
                case 30: {
                    cardIndexBean.cardName = this.mContext.getResources().getString(R.string.card_news);
                    break;
                }
                case 20: {
                    cardIndexBean.cardName = this.mContext.getResources().getString(R.string.card_game);
                    break;
                }
            }
        }
    }

    public void delFailureCard(int n2) {
        for (int i2 = 0; i2 < this.listShowCards.size(); ++i2) {
            if (n2 != this.listShowCards.get((int)i2).cardID) continue;
            this.listShowCards.remove(i2);
            this.SaveCardConfigInfo();
            break;
        }
    }

    public void setCardFailure(int n2) {
        this.getCardListConfigInfo();
        for (CardIndexBean cardIndexBean : this.listShowCards) {
            if (n2 != cardIndexBean.cardID) continue;
            cardIndexBean.isCardFailure = 1;
            break;
        }
        this.SaveCardConfigInfo();
    }

    public void removeToHideCard(int n2, boolean bl) {
        if (n2 < 0 || n2 >= this.listShowCards.size()) {
            return;
        }
        CardIndexBean cardIndexBean = this.listShowCards.get(n2);
        if (1 == cardIndexBean.isCardFailure) {
            this.delFailureCard(cardIndexBean.cardID);
            return;
        }
        if (null == this.listHideCards) {
            this.listHideCards = new ArrayList<CardIndexBean>();
        }
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.listHideCards.size(); ++i2) {
            if (cardIndexBean.cardID >= this.listHideCards.get((int)i2).cardID) continue;
            this.listHideCards.add(i2, cardIndexBean);
            this.listShowCards.remove(cardIndexBean);
            bl2 = false;
            break;
        }
        if (bl2) {
            this.listHideCards.add(cardIndexBean);
            this.listShowCards.remove(cardIndexBean);
        }
        this.SaveCardConfigList(this.listShowCards, this.listHideCards, true);
        Bundle bundle = new Bundle();
        bundle.putString("category", this.mContext.getPackageName());
        bundle.putString("card_id", cardIndexBean.cardID + "-" + cardIndexBean.cardName + "-off");
        if (GlobalValue.sAnalytics != null) {
            GlobalValue.sAnalytics.post("openoff", bundle);
        }
    }

    public void addShowCard(int n2) {
        if (n2 < 0 || n2 >= this.listHideCards.size()) {
            return;
        }
        CardIndexBean cardIndexBean = this.listHideCards.get(n2);
        if (null == this.listShowCards) {
            this.listShowCards = new ArrayList<CardIndexBean>();
        }
        this.listShowCards.add(cardIndexBean);
        this.listHideCards.remove(cardIndexBean);
        this.SaveCardConfigList(this.listShowCards, this.listHideCards, true);
        Bundle bundle = new Bundle();
        bundle.putString("category", this.mContext.getPackageName());
        bundle.putString("card_id", cardIndexBean.cardID + "-" + cardIndexBean.cardName + "-on");
        if (GlobalValue.sAnalytics != null) {
            GlobalValue.sAnalytics.post("openoff", bundle);
        }
    }

    public ExternalView getExternalView(int n2) {
        int n3 = n2 - 0;
        return this.mExternalViewMap.get(n3);
    }

    public void removeNoUsedExternalViewCard() {
        CardIndexBean cardIndexBean;
        int n2;
        this.getCardListConfigInfo();
        if (null != this.listShowCards && this.listShowCards.size() > 0) {
            n2 = 0;
            while (n2 < this.listShowCards.size()) {
                cardIndexBean = this.listShowCards.get(n2);
                if (!(cardIndexBean.cardID < 0 || cardIndexBean.cardID >= 10 || null != this.getExternalView(cardIndexBean.cardID) && null != this.getExternalView(cardIndexBean.cardID).getCarID() && this.getExternalView(cardIndexBean.cardID).getCarID().equals(cardIndexBean.externalViewID))) {
                    this.listShowCards.remove(cardIndexBean);
                    continue;
                }
                ++n2;
            }
        }
        if (null != this.listHideCards && this.listHideCards.size() > 0) {
            n2 = 0;
            while (n2 < this.listHideCards.size()) {
                cardIndexBean = this.listHideCards.get(n2);
                if (!(cardIndexBean.cardID < 0 || cardIndexBean.cardID >= 10 || null != this.getExternalView(cardIndexBean.cardID) && null != this.getExternalView(cardIndexBean.cardID).getCarID() && this.getExternalView(cardIndexBean.cardID).getCarID().equals(cardIndexBean.externalViewID))) {
                    this.listHideCards.remove(cardIndexBean);
                    continue;
                }
                ++n2;
            }
        }
    }

    public boolean addExternalCard(ExternalView externalView) {
        int n2 = -1;
        for (Integer n3 : this.mExternalViewMap.keySet()) {
            if (!this.mExternalViewMap.get(n3).getCarID().equals(externalView.getCarID())) continue;
            this.mExternalViewMap.put(n3, externalView);
            n2 = n3;
            break;
        }
        if (-1 == n2 && null != this.mExternalViewMap && this.mExternalViewMap.size() < 9) {
            n2 = this.mExternalViewMap.size();
            this.mExternalViewMap.put(n2, externalView);
        }
        if (n2 >= 0) {
            int n4;
            String string2;
            CardIndexBean cardIndexBean = new CardIndexBean();
            cardIndexBean.externalViewID = externalView.getCarID();
            cardIndexBean.cardName = externalView.getCardName();
            cardIndexBean.resCardIcon = externalView.getCardIcon();
            cardIndexBean.cardID = n2 + 0;
            this.getCardListConfigInfo();
            if (null != this.listShowCards && this.listShowCards.size() > 0) {
                for (int i2 = 0; i2 < this.listShowCards.size(); ++i2) {
                    string2 = this.listShowCards.get((int)i2).externalViewID;
                    if (null == string2 || !string2.equals(cardIndexBean.externalViewID)) continue;
                    this.listShowCards.set(i2, cardIndexBean);
                    return true;
                }
            }
            if (null != this.listHideCards && this.listHideCards.size() > 0) {
                for (int i3 = 0; i3 < this.listHideCards.size(); ++i3) {
                    string2 = this.listHideCards.get((int)i3).externalViewID;
                    if (null == string2 || !string2.equals(cardIndexBean.externalViewID)) continue;
                    this.listHideCards.set(i3, cardIndexBean);
                    return true;
                }
            }
            if ((n4 = externalView.getCardDefaultPosition()) < this.listShowCards.size()) {
                this.listShowCards.add(n4, cardIndexBean);
            } else {
                this.listShowCards.add(cardIndexBean);
            }
            this.SaveCardConfigInfo();
            return true;
        }
        return false;
    }

    public void removeExternalView(ExternalView externalView) {
        Collection<ExternalView> collection = this.mExternalViewMap.values();
        collection.remove((Object)externalView);
    }

    public void SaveCardConfigInfo() {
        this.SaveCardConfigList(this.listShowCards, this.listHideCards, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SaveCardConfigList(List<CardIndexBean> list, List<CardIndexBean> list2, boolean bl) {
        CardManager cardManager = this;
        synchronized (cardManager) {
            if (null != list) {
                this.listShowCards = list;
                try {
                    com.transsion.zeroscreencore.c.a.a().a(this.mContext, ShowCardListKey, JsonUtil.parseListToJsonStr(this.listShowCards));
                }
                catch (Exception exception) {
                    LogUtils.w((String)TAG, (Object[])new Object[]{exception.toString()});
                }
            }
            if (null != list2) {
                this.listHideCards = list2;
                try {
                    com.transsion.zeroscreencore.c.a.a().a(this.mContext, HideCardListKey, JsonUtil.parseListToJsonStr(this.listHideCards));
                }
                catch (Exception exception) {
                    LogUtils.w((String)TAG, (Object[])new Object[]{exception.toString()});
                }
            }
            if (bl) {
                if (null != ZeroScreenView.sHandler) {
                    ZeroScreenView.sHandler.sendEmptyMessage(1);
                }
                for (WeakReference<a> weakReference : this.listDataControls) {
                    if (weakReference.get() == null) continue;
                    ((a)weakReference.get()).a(this.getCardListConfigInfo());
                }
            }
        }
    }

    private void initCardConfigInfoList() {
        String string2;
        String string3 = this.mContext.getResources().getConfiguration().locale.getLanguage();
        if (null == this.listShowCards) {
            this.listShowCards = new ArrayList<CardIndexBean>();
        }
        if (this.listHideCards == null) {
            this.listHideCards = new ArrayList<CardIndexBean>();
        }
        if ((string2 = AssetsUtil.getInstance(this.mContext).getStrContent()) != null) {
            try {
                int n2;
                Object object;
                JSONObject jSONObject = new JSONObject(string2);
                if (string3.startsWith("en") || string3.startsWith("fr") || string3.startsWith("ar")) {
                    object = jSONObject.getJSONArray(string3);
                    block4: for (n2 = 0; n2 < object.length(); ++n2) {
                        CardIndexBean cardIndexBean = new CardIndexBean();
                        cardIndexBean.cardName = this.getCardNameByKey(object.getString(n2));
                        cardIndexBean.cardID = this.getCardIdByKey(object.getString(n2));
                        cardIndexBean.resCardIcon = this.getCardIconByKey(object.getString(n2));
                        for (CardIndexBean cardIndexBean2 : this.defaultCard) {
                            if (cardIndexBean2.cardID != cardIndexBean.cardID) continue;
                            this.listShowCards.add(cardIndexBean);
                            this.defaultCard.remove(cardIndexBean2);
                            continue block4;
                        }
                    }
                } else {
                    object = jSONObject.getJSONArray("default");
                    block6: for (n2 = 0; n2 < object.length(); ++n2) {
                        CardIndexBean cardIndexBean = new CardIndexBean();
                        cardIndexBean.cardID = this.getCardIdByKey(object.getString(n2));
                        cardIndexBean.cardName = this.getCardNameByKey(object.getString(n2));
                        cardIndexBean.resCardIcon = this.getCardIconByKey(object.getString(n2));
                        for (CardIndexBean cardIndexBean3 : this.defaultCard) {
                            if (cardIndexBean3.cardID != cardIndexBean.cardID) continue;
                            this.listShowCards.add(cardIndexBean);
                            this.defaultCard.remove(cardIndexBean3);
                            continue block6;
                        }
                    }
                }
                this.listHideCards = this.defaultCard;
                try {
                    object = JsonUtil.parseListToJsonStr(this.listShowCards);
                    String string4 = JsonUtil.parseListToJsonStr(this.listHideCards);
                    com.transsion.zeroscreencore.c.a.a().a(this.mContext, ShowCardListKey, (String)object);
                    com.transsion.zeroscreencore.c.a.a().a(this.mContext, HideCardListKey, string4);
                }
                catch (Exception exception) {
                    LogUtils.e((String)TAG, (Object[])new Object[]{exception.getMessage()});
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    private String getCardNameByKey(String string2) {
        String string3 = null;
        switch (string2) {
            case "CARD_VIDEO": {
                string3 = this.mContext.getResources().getString(R.string.card_video);
                break;
            }
            case "CARD_NEWS": {
                string3 = this.mContext.getResources().getString(R.string.card_news);
                break;
            }
            case "CARD_GAME": {
                string3 = this.mContext.getResources().getString(R.string.card_game);
                break;
            }
        }
        return string3;
    }

    private int getCardIdByKey(String string2) {
        int n2 = -1;
        switch (string2) {
            case "CARD_VIDEO": {
                n2 = 40;
                break;
            }
            case "CARD_NEWS": {
                n2 = 30;
                break;
            }
            case "CARD_GAME": {
                n2 = 20;
                break;
            }
        }
        return n2;
    }

    private int getCardIconByKey(String string2) {
        int n2 = -1;
        switch (string2) {
            case "CARD_VIDEO": {
                n2 = R.mipmap.video_icon;
                break;
            }
            case "CARD_NEWS": {
                n2 = R.mipmap.news_icon;
                break;
            }
            case "CARD_GAME": {
                n2 = R.mipmap.icon_game;
                break;
            }
        }
        return n2;
    }

    public static interface a {
        public void a(Map<String, List<CardIndexBean>> var1);

        public void a();
    }
}

