/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.zeroscreencore.utils;

import android.content.Context;
import android.os.Build;
import com.transsion.core.log.LogUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class HttpsConfigUtil {
    private static SSLSocketFactory sSSLSocketFactory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory getSSLSocketFactory(Context context, String string2) {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(context.getAssets().open(string2));
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certificateFactory.generateCertificate(inputStream);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry("cert", certificate);
            String string3 = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string3);
            trustManagerFactory.init(keyStore);
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
            SSLSocketFactory sSLSocketFactory = sSSLSocketFactory = sSLContext.getSocketFactory();
            return sSLSocketFactory;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (KeyManagementException keyManagementException) {
            keyManagementException.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public static String getDefaultUserAgent() {
        String string2;
        String string3 = "Mozilla/5.0 (Linux; Android %s;) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/55.0.2883.91 Mobile Safari/537.36";
        Locale locale = Locale.getDefault();
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = Build.VERSION.RELEASE;
        if (string4.length() > 0) {
            stringBuffer.append(string4);
        } else {
            stringBuffer.append("1.0");
        }
        stringBuffer.append("; ");
        String string5 = locale.getLanguage();
        if (string5 != null) {
            stringBuffer.append(string5.toLowerCase());
            string2 = locale.getCountry();
            if (string2 != null) {
                stringBuffer.append("-");
                stringBuffer.append(string2.toLowerCase());
            }
        } else {
            stringBuffer.append("en");
        }
        if ("REL".equals(Build.VERSION.CODENAME) && (string2 = Build.MODEL).length() > 0) {
            stringBuffer.append("; ");
            stringBuffer.append(string2);
        }
        if ((string2 = Build.ID).length() > 0) {
            stringBuffer.append(" Build/");
            stringBuffer.append(string2);
        }
        return String.format("Mozilla/5.0 (Linux; Android %s;) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/55.0.2883.91 Mobile Safari/537.36", stringBuffer.toString());
    }

    public static void trustAllHosts(HttpsURLConnection httpsURLConnection) {
        String string2 = "trustAllHosts";
        httpsURLConnection.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String string2, SSLSession sSLSession) {
                return true;
            }
        });
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2) {
                LogUtils.i((String)"trustAllHosts", (Object[])new Object[]{"checkClientTrusted"});
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string2) {
                LogUtils.i((String)"trustAllHosts", (Object[])new Object[]{"checkServerTrusted"});
            }
        }};
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

