/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.zeroscreencore.utils;

import android.text.TextUtils;
import com.transsion.zeroscreencore.b.a;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtil {
    public static String parseHashMapToJosnStr(Map<String, String> map) {
        JSONObject jSONObject = new JSONObject();
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        try {
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                jSONObject.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        catch (JSONException jSONException) {
            jSONObject = null;
            jSONException.printStackTrace();
        }
        return jSONObject == null ? "null" : jSONObject.toString();
    }

    public static <T> T parseJsonStrToObject(String string2, Class<T> clazz) {
        Field[] fieldArray;
        if (string2 == null || "null".equals(string2) || "".equals(string2)) {
            return null;
        }
        JSONObject jSONObject = null;
        T t = null;
        try {
            t = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        jSONObject = new JSONObject(string2);
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            Object object;
            Object object2;
            field.setAccessible(true);
            Class<?> clazz2 = field.getType();
            if (clazz2 == Long.TYPE || clazz2 == Long.class) {
                field.setLong(t, jSONObject.optLong(field.getName()));
                continue;
            }
            if (clazz2 == Double.TYPE || clazz2 == Double.class) {
                field.setDouble(t, jSONObject.optDouble(field.getName()));
                continue;
            }
            if (clazz2 == Float.TYPE || clazz2 == Float.class) {
                field.setDouble(t, jSONObject.optDouble(field.getName()));
                continue;
            }
            if (clazz2 == Integer.TYPE || clazz2 == Integer.class) {
                field.setInt(t, jSONObject.optInt(field.getName()));
                continue;
            }
            if (clazz2 == Boolean.TYPE || clazz2 == Boolean.class) {
                field.setBoolean(t, jSONObject.optBoolean(field.getName()));
                continue;
            }
            if (field.getType() == String.class) {
                object2 = jSONObject.optString(field.getName());
                field.set(t, object2 == null || "null".equals(object2) ? null : object2);
                continue;
            }
            if (clazz2 == List.class) {
                object2 = (ParameterizedType)field.getGenericType();
                object = object2.getActualTypeArguments()[0];
                String[] stringArray = object.toString().split(" ");
                String string3 = jSONObject.optString(field.getName());
                Class<?> clazz3 = Class.forName(stringArray[1]);
                field.set(t, JsonUtil.parseJsonStrToList(string3, clazz3));
                continue;
            }
            if (!field.isAnnotationPresent(a.class)) continue;
            object2 = field.getType();
            object = jSONObject.optString(field.getName());
            field.set(t, JsonUtil.parseJsonStrToObject((String)object, object2));
        }
        return t;
    }

    public static String parseObjectToJsonStr(Object object) {
        if (object == null) {
            return "null";
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        if (object instanceof Integer) {
            stringBuilder.append(object);
        } else if (object instanceof Double) {
            stringBuilder.append(object);
        } else if (object instanceof Float) {
            stringBuilder.append(object);
        } else if (object instanceof Integer) {
            stringBuilder.append(object);
        } else if (object instanceof Boolean) {
            stringBuilder.append(object);
        } else if (object instanceof String) {
            stringBuilder.append("\"" + JsonUtil.replaceSpecialChar((String)object) + "\"");
        } else {
            Field[] fieldArray;
            stringBuilder.append("{");
            bl = true;
            Class<?> clazz = object.getClass();
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                String string2;
                field.setAccessible(true);
                if (field.getType() == Long.TYPE) {
                    stringBuilder.append("\"" + field.getName() + "\":" + field.getLong(object) + ",");
                    continue;
                }
                if (field.getType() == Double.TYPE) {
                    stringBuilder.append("\"" + field.getName() + "\":" + field.getDouble(object) + ",");
                    continue;
                }
                if (field.getType() == Float.TYPE) {
                    stringBuilder.append("\"" + field.getName() + "\":" + field.getFloat(object) + ",");
                    continue;
                }
                if (field.getType() == Integer.TYPE) {
                    stringBuilder.append("\"" + field.getName() + "\":" + field.getInt(object) + ",");
                    continue;
                }
                if (field.getType() == Boolean.TYPE) {
                    stringBuilder.append("\"" + field.getName() + "\":" + field.getBoolean(object) + ",");
                    continue;
                }
                if (field.getType() == Integer.class || field.getType() == Boolean.class || field.getType() == Double.class || field.getType() == Float.class || field.getType() == Long.class) {
                    stringBuilder.append("\"" + field.getName() + "\":" + field.get(object) + ",");
                    continue;
                }
                if (field.getType() == String.class) {
                    stringBuilder.append("\"" + field.getName() + "\":" + (field.get(object) == null ? null : "\"" + JsonUtil.replaceSpecialChar((String)field.get(object)) + "\"") + ",");
                    continue;
                }
                if (field.getType() == List.class) {
                    string2 = JsonUtil.parseListToJsonStr((List)field.get(object));
                    stringBuilder.append("\"" + field.getName() + "\":" + string2 + ",");
                    continue;
                }
                if (!field.isAnnotationPresent(a.class)) continue;
                string2 = JsonUtil.parseObjectToJsonStr(field.get(object));
                stringBuilder.append("\"" + field.getName() + "\":" + string2 + ",");
            }
        }
        int n2 = stringBuilder.length();
        if (bl && n2 > 1) {
            stringBuilder.replace(n2 - 1, n2, "}");
        }
        return stringBuilder.toString();
    }

    private static String replaceSpecialChar(String string2) {
        string2 = JsonUtil.getDecodeJSONStr(string2);
        string2 = string2.replace("\"", "\\\"");
        return string2;
    }

    private static String getDecodeJSONStr(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        block3: for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            switch (c2) {
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block3;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String parseListToJsonStr(List<?> list) {
        if (list == null) {
            return "null";
        }
        if (list.size() == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (Object obj : list) {
            stringBuilder.append(JsonUtil.parseObjectToJsonStr(obj) + ",");
        }
        int n2 = stringBuilder.length();
        if (n2 > 1) {
            stringBuilder.replace(n2 - 1, n2, "]");
        }
        return stringBuilder.toString();
    }

    public static <T> ArrayList<T> parseJsonStrToList(String string2, Class<T> clazz) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string2 == null || "null".equals(string2)) {
            return null;
        }
        JSONArray jSONArray = new JSONArray(string2);
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = jSONArray.optString(i2);
            if (clazz == Long.TYPE || clazz == Long.class) {
                arrayList.add(Long.parseLong(string3));
                continue;
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                arrayList.add(Double.parseDouble(string3));
                continue;
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                arrayList.add(Float.valueOf(Float.parseFloat(string3)));
                continue;
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                arrayList.add(Integer.parseInt(string3));
                continue;
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                arrayList.add(Boolean.parseBoolean(string3));
                continue;
            }
            if (clazz == String.class) {
                arrayList.add(string3);
                continue;
            }
            T t = JsonUtil.parseJsonStrToObject(string3, clazz);
            arrayList.add(t);
        }
        return arrayList;
    }

    public static String getString(JSONObject jSONObject, String string2, String string3) {
        if (jSONObject == null || TextUtils.isEmpty((CharSequence)string2)) {
            return string3;
        }
        try {
            return jSONObject.getString(string2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return string3;
        }
    }

    public static String getVideoUrlFormJson(String string2) {
        String string3 = null;
        try {
            JSONObject jSONObject = new JSONObject(string2);
            JSONObject jSONObject2 = jSONObject.optJSONObject("content");
            if (jSONObject2 != null) {
                string3 = jSONObject2.optString("video");
            } else {
                JSONArray jSONArray = jSONObject.optJSONArray("content");
                int n2 = jSONArray.length();
                for (int i2 = 0; i2 < n2 && ((string3 = JsonUtil.getString(jSONArray.getJSONObject(i2), "video", "")) == null || "".equals(string3)); ++i2) {
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    public static String getString(String string2, String string3, String string4) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string4;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            return JsonUtil.getString(jSONObject, string3, string4);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return string4;
        }
    }
}

