/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.zeroscreencore.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.WindowManager;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.core.log.LogUtils;
import com.transsion.core.utils.SharedPreferencesUtil;
import com.transsion.zeroscreencore.activity.ZeroScreenWebActivity;
import com.transsion.zeroscreencore.bean.CardIndexBean;
import com.transsion.zeroscreencore.constants.a;
import com.transsion.zeroscreencore.manger.CardManager;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Util {
    private static final String TAG = "Util";
    public static final long ARG_MAX_RECORD_SIZE = 1024000L;

    public static NetworkInfo getNetworkInfo(Context context) {
        if (context == null) {
            return null;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        return connectivityManager.getActiveNetworkInfo();
    }

    public static boolean isConnected(Context context) {
        NetworkInfo networkInfo = Util.getNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnected();
    }

    public static String dateFormat(long l2, boolean bl) {
        Date date = new Date(l2);
        return bl ? String.format("%04d%02d%02d%02d%02d%02d", date.getYear() + 1900, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds()) : String.format("%04d%02d%02d", date.getYear() + 1900, date.getMonth() + 1, date.getDate());
    }

    public static void record(Context context, String string2, String string3) {
        Closeable closeable;
        int n2 = 0;
        try {
            closeable = context.openFileInput(string2);
            n2 = ((FileInputStream)closeable).available();
            ((FileInputStream)closeable).close();
            if ((long)n2 > 1024000L) {
                context.deleteFile(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            closeable = context.openFileOutput(string2, 32768);
            if (n2 == 0) {
                // empty if block
            }
            String string4 = Util.dateFormat(System.currentTimeMillis(), true);
            if (!string2.equals("bizuserextend")) {
                ((FileOutputStream)closeable).write((string3 + "\n").getBytes());
            } else {
                ((FileOutputStream)closeable).write(string3.getBytes());
            }
            ((FileOutputStream)closeable).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isPad(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static String getNetworkType(Context context) {
        if (context == null) {
            return null;
        }
        String string2 = "";
        NetworkInfo networkInfo = ((ConnectivityManager)context.getApplicationContext().getSystemService("connectivity")).getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (networkInfo.getType() == 1) {
                string2 = "WIFI";
            } else {
                String string3 = networkInfo.getSubtypeName();
                int n2 = networkInfo.getSubtype();
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        string2 = "2G";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        string2 = "3G";
                        break;
                    }
                    case 13: {
                        string2 = "4G";
                        break;
                    }
                    default: {
                        string2 = "TD-SCDMA".equalsIgnoreCase(string3) || "WCDMA".equalsIgnoreCase(string3) || "CDMA2000".equalsIgnoreCase(string3) ? "3G" : string3;
                    }
                }
            }
            return string2;
        }
        return null;
    }

    public static String getResolution(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        int n2 = windowManager.getDefaultDisplay().getWidth();
        int n3 = windowManager.getDefaultDisplay().getHeight();
        return n2 + "*" + n3;
    }

    public static String getSimOperatorName(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return telephonyManager != null ? telephonyManager.getSimOperatorName() : null;
    }

    public static String getCountryCode() {
        String string2 = DeviceInfo.getIMSI();
        String string3 = null;
        try {
            string3 = string2 != null && !"".equals(string2) ? string2.substring(0, 3) : "000";
        }
        catch (Exception exception) {
            string3 = "000";
        }
        return string3;
    }

    public static void recordLog(Context context, String string2, String string3, boolean bl) {
        String string4 = DeviceInfo.getIMEI();
        String string5 = DeviceInfo.getIMSI();
        String string6 = DeviceInfo.getAndroidID();
        String string7 = DeviceInfo.getGAId();
        String string8 = Build.BRAND + "/" + Build.MODEL + "/" + Build.DISPLAY + "/" + Build.VERSION.RELEASE + "/" + Util.getResolution(context);
        String string9 = "1.2.026";
        int n2 = 12026;
        String string10 = context.getPackageName();
        String string11 = context.getApplicationContext().getPackageName();
        String string12 = Util.isPad(context) ? "androidpad" : "android";
        String string13 = Util.getNetworkType(context);
        String string14 = Util.getSimOperatorName(context);
        String string15 = Locale.getDefault().getLanguage();
        String string16 = "";
        try {
            string16 = context.getPackageManager().getPackageInfo((String)context.getApplicationContext().getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IMEI").append("\u001c").append(string4);
        stringBuffer.append("\u001f");
        stringBuffer.append("ANDROIDID").append("\u001c").append(string6);
        stringBuffer.append("\u001f");
        stringBuffer.append("GADID").append("\u001c").append(string7);
        stringBuffer.append("\u001f");
        stringBuffer.append("IMSI").append("\u001c").append(string5);
        stringBuffer.append("\u001f");
        if (!string3.equals("bizuserextend")) {
            stringBuffer.append("CTM").append("\u001c").append(Util.dateFormat(System.currentTimeMillis(), bl));
            stringBuffer.append("\u001f");
            stringBuffer.append("IP").append("\u001c").append(SharedPreferencesUtil.getInstance((String)"ZeroScreenLog").getString("PREFERENCE_IP"));
        } else {
            stringBuffer.append("UA").append("\u001c").append(string8);
            stringBuffer.append("\u001f");
            stringBuffer.append("FDATE").append("\u001c").append(Util.dateFormat(System.currentTimeMillis(), bl));
        }
        stringBuffer.append("\u001f");
        stringBuffer.append("LANGUAGE").append("\u001c").append(string15);
        stringBuffer.append("\u001f");
        stringBuffer.append("BIZID").append("\u001c").append(string11);
        stringBuffer.append("\u001f");
        stringBuffer.append("OSID").append("\u001c").append(string12);
        stringBuffer.append("\u001f");
        stringBuffer.append("APCODE").append("\u001c").append(string13);
        stringBuffer.append("\u001f");
        stringBuffer.append("APKPKGNAME").append("\u001c").append(string10);
        stringBuffer.append("\u001f");
        stringBuffer.append("APKVERCODE").append("\u001c").append(n2);
        stringBuffer.append("\u001f");
        stringBuffer.append("APKVERNAME").append("\u001c").append(string9);
        stringBuffer.append("\u001f");
        if (!string3.equals("bizuserextend")) {
            stringBuffer.append("CVER").append("\u001c").append(string16);
        } else {
            stringBuffer.append("FVER").append("\u001c").append(string16);
        }
        stringBuffer.append("\u001f");
        Util.record(context, string3, stringBuffer.toString() + string2);
    }

    public static String getFileContent(String string2) {
        byte[] byArray = null;
        int n2 = 0;
        File file = new File(string2);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            n2 = (int)file.length();
            byArray = new byte[n2];
            ((InputStream)fileInputStream).read(byArray, 0, n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        String string3 = new String(byArray);
        return string3;
    }

    public static Map<String, String> getParams(Context context, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = context.getPackageName();
        hashMap.put("appName", "ZeroScreen");
        hashMap.put("logName", string2);
        String string4 = Util.getFileContent(context.getFilesDir().getPath() + "/" + string2);
        hashMap.put("logData", String.valueOf(new JSONArray().put((Object)string4)));
        return hashMap;
    }

    private static void upload(List<String> list, Context context) {
        String string2 = "\r\n";
        String string3 = "--";
        String string4 = UUID.randomUUID().toString();
        try {
            String string5;
            int n2;
            URL uRL = new URL(a.f);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setReadTimeout(10000);
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + string4);
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            for (n2 = 0; n2 < list.size(); ++n2) {
                String string6 = list.get(n2);
                string5 = string6.substring(string6.lastIndexOf("/") + 1);
                LogUtils.e((String)TAG, (Object[])new Object[]{"filename=" + string5});
                dataOutputStream.writeBytes(string3 + string4 + string2);
                dataOutputStream.writeBytes("Content-Disposition: form-data;cardName=\"file\";filename=\"" + string5 + "\"" + string2);
                dataOutputStream.writeBytes("Content-Type: text/plain; charset=US-ASCII" + string2);
                dataOutputStream.writeBytes("Content-Transfer-Encoding: 8bit" + string2);
                dataOutputStream.writeBytes(string2);
                FileInputStream fileInputStream = new FileInputStream(string6);
                int n3 = 1024;
                byte[] byArray = new byte[n3];
                int n4 = -1;
                while ((n4 = fileInputStream.read(byArray)) != -1) {
                    dataOutputStream.write(byArray, 0, n4);
                }
                if ("bizuserextend".equals(string5)) {
                    dataOutputStream.writeBytes("IP\u001c" + SharedPreferencesUtil.getInstance((String)"ZeroScreenLog").getString("PREFERENCE_IP"));
                }
                dataOutputStream.writeBytes("\r");
                fileInputStream.close();
            }
            dataOutputStream.writeBytes(string3 + string4 + "-" + string3 + string2);
            dataOutputStream.flush();
            n2 = httpURLConnection.getResponseCode();
            LogUtils.e((String)TAG, (Object[])new Object[]{"upload response code:" + n2});
            if (n2 == 200) {
                LogUtils.e((String)TAG, (Object[])new Object[]{"upload success"});
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    string5 = list.get(i2).substring(list.get(i2).lastIndexOf("/") + 1);
                    LogUtils.e((String)TAG, (Object[])new Object[]{Util.getFileContent(list.get(i2))});
                    if (string5.endsWith(".gz")) {
                        context.deleteFile(list.get(i2));
                    } else {
                        context.deleteFile(string5);
                    }
                    LogUtils.e((String)TAG, (Object[])new Object[]{string5});
                    if ("bizuserextend".equals(string5)) {
                        LogUtils.e((String)TAG, (Object[])new Object[]{"biz true"});
                        SharedPreferencesUtil.getInstance((String)"ZeroScreenLog").putBoolean("PREFERENCE_IS_FIRST_OPEN", false);
                        continue;
                    }
                    LogUtils.e((String)TAG, (Object[])new Object[]{"biz false"});
                    Util.clearCount(context);
                }
                SharedPreferencesUtil.getInstance((String)"ZeroScreenLog").putLong("PREFERENCE_LAST_UPLOAD", System.currentTimeMillis());
                SharedPreferencesUtil.getInstance((String)"ZeroScreenLog").putBoolean("PREFERENCE_IS_UPLOADING", false);
            } else {
                SharedPreferencesUtil.getInstance((String)"ZeroScreenLog").putBoolean("PREFERENCE_IS_UPLOADING", false);
            }
            httpURLConnection.disconnect();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            SharedPreferencesUtil.getInstance((String)"ZeroScreenLog").putBoolean("PREFERENCE_IS_UPLOADING", false);
        }
    }

    public static String getUploadInfo(Context context) {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer();
        HttpURLConnection httpURLConnection = null;
        String string2 = TextUtils.isEmpty((CharSequence)DeviceInfo.getIMSI()) ? "0" : DeviceInfo.getIMSI().subSequence(0, 3).toString();
        try {
            URL uRL = new URL(a.e + string2);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setReadTimeout(10000);
            int n2 = httpURLConnection.getResponseCode();
            LogUtils.e((String)TAG, (Object[])new Object[]{"get option code :" + n2});
            if (n2 == 200) {
                inputStream = httpURLConnection.getInputStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string3 = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string3);
                    stringBuffer.append("\r\n");
                }
                return stringBuffer.toString();
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            SharedPreferencesUtil.getInstance((String)"ZeroScreenLog").putBoolean("PREFERENCE_IS_UPLOADING", false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            SharedPreferencesUtil.getInstance((String)"ZeroScreenLog").putBoolean("PREFERENCE_IS_UPLOADING", false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            SharedPreferencesUtil.getInstance((String)"ZeroScreenLog").putBoolean("PREFERENCE_IS_UPLOADING", false);
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            SharedPreferencesUtil.getInstance((String)"ZeroScreenLog").putBoolean("PREFERENCE_IS_UPLOADING", false);
        }
        return "";
    }

    public static Map<String, Boolean> getUploadFileName(Context context, String string2) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("settings");
        arrayList.add("startrunlog");
        arrayList.add("statlog");
        arrayList.add("bizuserextend");
        try {
            JSONObject jSONObject = new JSONObject(string2);
            JSONObject jSONObject2 = jSONObject.getJSONObject("option");
            String string3 = jSONObject.getString("ip");
            SharedPreferencesUtil.getInstance((String)"ZeroScreenLog").putString("PREFERENCE_IP", string3);
            long l2 = jSONObject2.getLong("duration");
            long l3 = SharedPreferencesUtil.getInstance((String)"ZeroScreenLog").getLong("PREFERENCE_LAST_UPLOAD");
            if (System.currentTimeMillis() - l3 > l2 * 1000L) {
                for (String string4 : arrayList) {
                    if (string4.equals("startrunlog")) {
                        if (jSONObject2.getInt("startrunlog") == 1) {
                            hashMap.put("startrunlog", true);
                            continue;
                        }
                        hashMap.put("startrunlog", false);
                        continue;
                    }
                    if (jSONObject2.getInt(string4) == 1) {
                        hashMap.put(string4, true);
                        continue;
                    }
                    hashMap.put(string4, false);
                }
                if (jSONObject2.getInt("switch") == 1) {
                    hashMap.put("SWITCH", true);
                } else {
                    hashMap.put("SWITCH", false);
                }
                LogUtils.e((String)TAG, (Object[])new Object[]{"option size:" + hashMap.size()});
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            SharedPreferencesUtil.getInstance((String)"ZeroScreenLog").putBoolean("PREFERENCE_IS_UPLOADING", false);
        }
        return hashMap;
    }

    public static void uploadLog(Context context, final int n2) {
        final Context context2 = context.getApplicationContext();
        LogUtils.e((String)TAG, (Object[])new Object[]{"start upload"});
        if (!Util.isConnected(context2)) {
            LogUtils.e((String)TAG, (Object[])new Object[]{"no network"});
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                String string2 = Util.getUploadInfo(context2);
                if (string2 != null) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add("settings");
                    arrayList.add("startrunlog");
                    arrayList.add("statlog");
                    arrayList.add("bizuserextend");
                    Map<String, Boolean> map = Util.getUploadFileName(context2, string2);
                    if (map != null && !map.isEmpty()) {
                        for (String arrayList2 : map.keySet()) {
                            LogUtils.e((String)Util.TAG, (Object[])new Object[]{"key=" + arrayList2 + ":value=" + map.get(arrayList2)});
                        }
                        if (map.get("SWITCH") != null) {
                            ArrayList arrayList3 = new ArrayList();
                            for (String string3 : arrayList) {
                                boolean bl = false;
                                try {
                                    bl = string3.equals("startrunlog") ? map.get("startrunlog").booleanValue() : map.get(string3).booleanValue();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                String string4 = context2.getFilesDir().getPath() + "/" + string3;
                                LogUtils.e((String)Util.TAG, (Object[])new Object[]{"filePath:" + string4});
                                if (!Util.isFileExist(string4)) continue;
                                if (bl) {
                                    if ((long)Util.getFileSize(string4) > 1024000L) {
                                        String string5 = string4 + ".gz";
                                        Util.gzip(string4, string5);
                                        arrayList3.add(string5);
                                        continue;
                                    }
                                    arrayList3.add(string4);
                                    continue;
                                }
                                context2.deleteFile(string3);
                            }
                            if (n2 == a.i) {
                                ArrayList<String> arrayList2 = new ArrayList<String>();
                                arrayList2.add(context2.getFilesDir().getPath() + "/" + "bizuserextend");
                                LogUtils.e((String)Util.TAG, (Object[])new Object[]{"mode single:" + arrayList2.size()});
                                Util.upload(arrayList2, context2);
                            } else if (n2 == a.h) {
                                LogUtils.e((String)Util.TAG, (Object[])new Object[]{"mode default:" + arrayList3.size()});
                                Util.upload(arrayList3, context2);
                            }
                        }
                    }
                }
            }
        }).start();
    }

    public static int getFileSize(String string2) {
        int n2 = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            n2 = fileInputStream.available();
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public static boolean gzip(String string2, String string3) {
        try {
            File file = new File(string2);
            File file2 = new File(string3);
            FileInputStream fileInputStream = new FileInputStream(file);
            GZIPOutputStream gZIPOutputStream = null;
            gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(file2));
            int n2 = 0;
            while ((n2 = ((InputStream)fileInputStream).read()) != -1) {
                gZIPOutputStream.write(n2);
            }
            ((InputStream)fileInputStream).close();
            gZIPOutputStream.finish();
            gZIPOutputStream.flush();
            gZIPOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static void addCount(Context context, String string2) {
        int n2 = SharedPreferencesUtil.getInstance((String)"CountLog").getInt(string2, 0);
        SharedPreferencesUtil.getInstance((String)"CountLog").putInt(string2, ++n2);
    }

    public static boolean isFileExist(String string2) {
        File file = new File(string2);
        return file.exists();
    }

    private static void clearCount(Context context) {
        SharedPreferencesUtil.getInstance((String)"CountLog").clear();
    }

    public static String getStatLog(Context context) {
        Map map = SharedPreferencesUtil.getInstance((String)"CountLog").getAll();
        Set set = map.keySet();
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : set) {
            stringBuffer.append(string2 + ":" + SharedPreferencesUtil.getInstance((String)"CountLog").getInt(string2));
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static void recordSettingLog(Context context) {
        Map<String, List<CardIndexBean>> map = CardManager.getInstance(context).getCardListConfigInfo();
        if (map != null && map.size() > 0) {
            int n2;
            List<CardIndexBean> list = map.get(CardManager.ShowCardListKey);
            List<CardIndexBean> list2 = map.get(CardManager.HideCardListKey);
            StringBuffer stringBuffer = new StringBuffer();
            for (n2 = 0; n2 < list.size(); ++n2) {
                stringBuffer.append(list.get((int)n2).cardID + "#" + (n2 + 1) + ":1,");
            }
            for (n2 = 0; n2 < list2.size(); ++n2) {
                stringBuffer.append(list2.get((int)n2).cardID + "#" + (list.size() + n2 + 1) + ":0,");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            Util.recordLog(context, "SETTINGS\u001c{" + stringBuffer.toString() + "}", "settings", false);
        }
    }

    public static boolean checkNetworkState(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isAvailable();
    }

    public static void startActivity(Context context, String string2) {
        if (string2.startsWith("http://") || string2.startsWith("https://")) {
            Intent intent = new Intent(context, ZeroScreenWebActivity.class);
            intent.setFlags(0x10000000);
            intent.putExtra("showdata", string2);
            context.getApplicationContext().startActivity(intent);
        }
    }

    public static void startActivity(Context context, String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Util.startActivity(context, string3);
        } else {
            String string4 = !TextUtils.isEmpty((CharSequence)string2) ? string2 : string3;
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            Uri uri = Uri.parse((String)string4);
            intent.setData(uri);
            intent.setFlags(0x10008000);
            PackageManager packageManager = context.getPackageManager();
            List list = packageManager.queryIntentActivities(intent, 0);
            if (list.size() > 0) {
                context.startActivity(intent);
            } else {
                Util.startActivity(context, string3);
            }
        }
    }

    public static class Preferences {
        public static final String PREFERENCE_LAST_UPLOAD = "PREFERENCE_LAST_UPLOAD";
        public static final String PREFERENCE_IS_UPLOADING = "PREFERENCE_IS_UPLOADING";
        public static final String PREFERENCE_IS_FIRST_OPEN = "PREFERENCE_IS_FIRST_OPEN";
        public static final String PREFERENCE_HAS_RECORD_FIRST = "PREFERENCE_HAS_RECORD_FIRST";
        public static final String PREFERENCE_IP = "PREFERENCE_IP";
    }

    public static class LogName {
        public static final String STARTRUNLOG = "startrunlog";
        public static final String DOWNLOADINGLOG = "downloading";
        public static final String BIZUSEREXTEND = "bizuserextend";
        public static final String STATLOG = "statlog";
        public static final String SETTINGS = "settings";
    }

    public static class Params {
        public static final String PARAM_UID = "uid";
        public static final String PARAM_CTM = "CTM";
        public static final String PARAM_IP = "IP";
        public static final String PARAM_UA = "UA";
        public static final String PARAM_OPERATOR = "operator";
        public static final String PARAM_APKTYPE = "apktype";
        public static final String PARAM_VERSION = "version";
        public static final String PARAM_LANGUAGE = "LANGUAGE";
        public static final String PARAM_BIZID = "BIZID";
        public static final String PARAM_OSID = "OSID";
        public static final String PARAM_APCODE = "APCODE";
        public static final String PARAM_APKPKGNAME = "APKPKGNAME";
        public static final String PARAM_APKVERNAME = "APKVERNAME";
        public static final String PARAM_APKVERCODE = "APKVERCODE";
        public static final String PARAM_IMEI = "IMEI";
        public static final String PARAM_IMSI = "IMSI";
        public static final String PARAM_GAID = "GADID";
        public static final String PARAM_ANDROIDID = "ANDROIDID";
        public static final String PARAM_FVER = "FVER";
        public static final String PARAM_CVER = "CVER";
        public static final String PARAM_FDATE = "FDATE";
        public static final String PARAM_ACTION = "action";
        public static final String PARAM_APPID = "appid";
        public static final String PARAM_ATTRIBUTE = "attribute";
        public static final String PARAM_CATEGORY = "category";
    }
}

