/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.zeroscreencore.view;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.transsion.core.CoreUtil;
import com.transsion.core.log.LogUtils;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.core.utils.SharedPreferencesUtil;
import com.transsion.zeroscreencore.R;
import com.transsion.zeroscreencore.a.b;
import com.transsion.zeroscreencore.activity.ZeroScreenWebActivity;
import com.transsion.zeroscreencore.bean.CardIndexBean;
import com.transsion.zeroscreencore.card.view.ConvenientBanner;
import com.transsion.zeroscreencore.constants.GlobalValue;
import com.transsion.zeroscreencore.manger.CardManager;
import com.transsion.zeroscreencore.manger.c;
import com.transsion.zeroscreencore.view.CustomContentCallbacks;
import com.transsion.zeroscreencore.view.ExternalUIManager;
import com.transsion.zeroscreencore.view.ExternalView;
import com.transsion.zeroscreencore.view.IExternalUI;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZeroScreenView
extends LinearLayout
implements CustomContentCallbacks {
    private View mRootView = null;
    private Context mContext = null;
    private RecyclerView mCardRecyclerView = null;
    b mCardAdapter = null;
    public static Handler sHandler = null;
    private static final String TAG = "ZeroScreenView";
    private SharedPreferencesUtil mPrefUtils = null;
    public static int LauncherSize;
    public static boolean isCanUpdateView;
    public boolean isWattingUpdateView = false;
    public static boolean isShow;

    public ZeroScreenView(Context context) {
        this(context, null);
        this.initView(context);
    }

    public ZeroScreenView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.initView(context);
    }

    public ZeroScreenView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initView(context);
    }

    @TargetApi(value=21)
    public ZeroScreenView(Context context, AttributeSet attributeSet, int n2, int n3) {
        super(context, attributeSet, n2, n3);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mContext = context;
        this.mRootView = View.inflate((Context)this.mContext, (int)R.layout.zero_screen_view, (ViewGroup)this);
        this.mCardRecyclerView = (RecyclerView)this.mRootView.findViewById(R.id.rv_card);
        this.mCardAdapter = new b(this.mContext);
        this.mCardRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext, 1, false));
        this.mCardRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new CardItemDecoration());
        this.mCardRecyclerView.setAdapter((RecyclerView.Adapter)this.mCardAdapter);
        this.mCardRecyclerView.setNestedScrollingEnabled(false);
        CoreUtil.init((Context)this.mContext);
        this.mPrefUtils = SharedPreferencesUtil.getInstance((String)"ZeroScreenLog");
    }

    private void resetZeroScreenView() {
        if (null != this.mCardAdapter) {
            Map<String, List<CardIndexBean>> map = CardManager.getInstance(this.mContext).getCardListConfigInfo();
            this.mCardAdapter.a(map.get(CardManager.ShowCardListKey));
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        sHandler = new ZeroScreenHandler(this);
        com.transsion.zeroscreencore.aidl.b.b.a(this.getContext()).c();
    }

    protected void onDetachedFromWindow() {
        if (sHandler != null) {
            LogUtils.d((String)TAG, (Object[])new Object[]{"ZeroScreen onDetachedFromWindow"});
            sHandler.removeCallbacksAndMessages(null);
            sHandler = null;
            if (-1 != this.getSdkProcessId()) {
                com.transsion.zeroscreencore.aidl.b.b.a(this.getContext()).d();
            }
        }
        super.onDetachedFromWindow();
    }

    @Override
    public void onInit() {
        LogUtils.d((String)TAG, (Object[])new Object[]{"CustomContentCallbacks  onInit() called..."});
        CardManager.getInstance(this.mContext).removeNoUsedExternalViewCard();
        Map<String, List<CardIndexBean>> map = CardManager.getInstance(this.mContext).getCardListConfigInfo();
        this.mCardAdapter.a(map.get(CardManager.ShowCardListKey));
        c.a().a(this.mContext);
        c.a().b(this.mContext);
        this.recordLog();
    }

    private void recordLog() {
        Bundle bundle = new Bundle();
        bundle.putString("category", this.mContext.getPackageName());
        bundle.putString("card_id", "zeroscreen");
        if (GlobalValue.sAnalytics != null) {
            GlobalValue.sAnalytics.post("start", bundle);
        }
    }

    @Override
    public void isCanReDraw(boolean bl) {
        isCanUpdateView = bl;
    }

    @Override
    public void onShow() {
        isShow = true;
        LogUtils.d((String)TAG, (Object[])new Object[]{"CustomContentCallbacks  onShow() called..."});
        if (!this.isWattingUpdateView) {
            this.isWattingUpdateView = true;
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    LogUtils.v((String)"isCanUpdateView", (Object[])new Object[]{"onShow :" + isCanUpdateView});
                    if (isCanUpdateView) {
                        ZeroScreenView.this.mCardAdapter.notifyDataSetChanged();
                    }
                    ZeroScreenView.this.isWattingUpdateView = false;
                }
            }, 1000L);
        }
        ConvenientBanner.isTurning = true;
    }

    @Override
    public void onHide() {
        LogUtils.d((String)TAG, (Object[])new Object[]{"CustomContentCallbacks  onHide() called..."});
        isShow = false;
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                LogUtils.e((String)"isCanUpdateView", (Object[])new Object[]{"onHide :" + isCanUpdateView});
                if (isCanUpdateView) {
                    c.a().a(ZeroScreenView.this.mContext);
                    c.a().b(ZeroScreenView.this.mContext);
                    c.a().b();
                }
                ConvenientBanner.isTurning = false;
            }
        }, 1000L);
        long l2 = System.currentTimeMillis() - SharedPreferencesUtil.getInstance((String)"ZeroScreen").getLong("log_settings", 0L);
        if (l2 > 21600000L) {
            TranssionPoolManager.getInstance().addTask(new Runnable(){

                @Override
                public void run() {
                    SharedPreferencesUtil.getInstance((String)"ZeroScreen").putLong("log_settings", System.currentTimeMillis());
                    Map<String, List<CardIndexBean>> map = CardManager.getInstance(ZeroScreenView.this.mContext).getCardListConfigInfo();
                    if (map != null && map.size() > 0) {
                        int n2;
                        List<CardIndexBean> list = map.get(CardManager.ShowCardListKey);
                        List<CardIndexBean> list2 = map.get(CardManager.HideCardListKey);
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        for (n2 = 0; n2 < list.size(); ++n2) {
                            hashMap.put(list.get((int)n2).cardID + "#" + (n2 + 1), "0");
                        }
                        for (n2 = 0; n2 < list2.size(); ++n2) {
                            hashMap.put(list2.get((int)n2).cardID + "#" + (list.size() + n2 + 1), "1");
                        }
                    }
                }
            });
        }
    }

    private int getSdkProcessId() {
        ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
        if (activityManager != null && activityManager.getRunningAppProcesses() != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : activityManager.getRunningAppProcesses()) {
                if (!"transsion.sdk.process".equals(runningAppProcessInfo.processName)) continue;
                return runningAppProcessInfo.pid;
            }
        }
        return -1;
    }

    @Override
    public void onShowSettingView() {
        CardManager.getInstance(this.mContext.getApplicationContext()).RefreshSettingViewImage();
    }

    public void onSearch(String string2) {
        Intent intent = new Intent(this.mContext, ZeroScreenWebActivity.class);
        intent.putExtra("showdata", string2);
        this.mContext.startActivity(intent);
    }

    @Override
    public void setLauncherIconSize(int n2) {
        LauncherSize = n2;
    }

    @Override
    public boolean isHasNewCardUpdate() {
        return CardManager.isNewCardUpdate;
    }

    @Override
    public void closeNewCardUpdateFlag() {
        CardManager.isNewCardUpdate = false;
    }

    @Override
    public void onScrollProgressChanged(float f2) {
        LogUtils.d((String)TAG, (Object[])new Object[]{"CustomContentCallbacks  onScrollProgressChanged(float progress) called..."});
    }

    @Override
    public boolean onBackPress() {
        LogUtils.d((String)TAG, (Object[])new Object[]{"CustomContentCallbacks  onBackPress() called..."});
        return false;
    }

    @Override
    public boolean addExternalCard(ExternalView externalView) {
        boolean bl = false;
        bl = CardManager.getInstance(this.mContext).addExternalCard(externalView);
        return bl;
    }

    @Override
    public void removeExternalCard(ExternalView externalView) {
        CardManager.getInstance(this.mContext).removeExternalView(externalView);
    }

    @Override
    public void addExternalUI(IExternalUI iExternalUI) {
        ExternalUIManager.setExternalUI(iExternalUI);
    }

    public void setDebug() {
        CoreUtil.setDebug((boolean)true);
    }

    @Override
    public boolean isScrollingAllowed() {
        return ConvenientBanner.isScrollingAllowed;
    }

    static {
        isCanUpdateView = true;
        isShow = true;
    }

    class CardItemDecoration
    extends RecyclerView.ItemDecoration {
        CardItemDecoration() {
        }

        public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, RecyclerView.State state) {
            rect.set((int)ZeroScreenView.this.getResources().getDimension(R.dimen.card_margin_left), 0, (int)ZeroScreenView.this.getResources().getDimension(R.dimen.card_margin_right), (int)ZeroScreenView.this.getResources().getDimension(R.dimen.card_margin_bottom));
        }
    }

    private static class ZeroScreenHandler
    extends Handler {
        private WeakReference<ZeroScreenView> mZeroScreenView;

        public ZeroScreenHandler(ZeroScreenView zeroScreenView) {
            this.mZeroScreenView = new WeakReference<ZeroScreenView>(zeroScreenView);
        }

        public void handleMessage(Message message) {
            if (this.mZeroScreenView.get() == null) {
                return;
            }
            if (message.what == 1) {
                ((ZeroScreenView)this.mZeroScreenView.get()).resetZeroScreenView();
            }
        }
    }
}

