/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.zeroscreencore.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.gemini.gamefolder.util.DataTools;
import com.transsion.zeroscreencore.R;
import com.transsion.zeroscreencore.widget.MaskedImage;

public class CircularImage
extends MaskedImage {
    private Context context;
    private float roundRids;

    public CircularImage(Context context) {
        this(context, null);
    }

    public CircularImage(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CircularImage(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.context = context;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CircularImage);
        this.roundRids = typedArray.getFloat(R.styleable.CircularImage_roundRids, 12.0f);
        typedArray.recycle();
    }

    @Override
    public Bitmap createMask() {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint(1);
        paint.setColor(-16777216);
        float f2 = this.getWidth();
        float f3 = this.getHeight();
        RectF rectF = new RectF(0.0f, 0.0f, f2, f3);
        float f4 = DataTools.dip2px((Context)this.context, (float)this.roundRids);
        canvas.drawRoundRect(rectF, f4, f4, paint);
        return bitmap;
    }
}

