/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.zeroscreencore.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;

public abstract class MaskedImage
extends ImageView {
    private static final Xfermode MASK_XFERMODE;
    private Bitmap mask;
    private Paint paint;

    public MaskedImage(Context context) {
        this(context, null);
    }

    public MaskedImage(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public MaskedImage(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    public abstract Bitmap createMask();

    protected void onDraw(Canvas canvas) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return;
        }
        try {
            Bitmap bitmap;
            if (this.paint == null) {
                Paint paint;
                this.paint = paint = new Paint();
                this.paint.setFilterBitmap(false);
                Paint paint2 = this.paint;
                Xfermode xfermode = MASK_XFERMODE;
                Xfermode xfermode2 = paint2.setXfermode(xfermode);
            }
            float f2 = this.getWidth();
            float f3 = this.getHeight();
            int n2 = canvas.saveLayer(0.0f, 0.0f, f2, f3, null, 31);
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            drawable2.setBounds(0, 0, n3, n4);
            drawable2.draw(canvas);
            if (this.mask == null || this.mask.isRecycled()) {
                this.mask = bitmap = this.createMask();
            }
            bitmap = this.mask;
            Paint paint = this.paint;
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
            canvas.restoreToCount(n2);
            return;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder().append("Attempting to draw with recycled bitmap. View ID = ");
            System.out.println("localStringBuilder==" + stringBuilder);
            return;
        }
    }

    static {
        PorterDuff.Mode mode = PorterDuff.Mode.DST_IN;
        MASK_XFERMODE = new PorterDuffXfermode(mode);
    }
}

