/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.gamecore.apihelper;

import android.text.TextUtils;
import androidx.annotation.Keep;
import com.transsion.gamecore.GameCoreInitializer;
import com.transsion.gamecore.track.TrackerChannel;
import com.transsion.gamecore.util.EncryptSP;
import com.transsion.gamecore.util.GameSDKUtils;

@Keep
public class ChannelHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = "ChannelHelper";
    private static final String SP_KEY_CHANNEL = "sp.key.channel";
    private static String cacheChannel;

    public static String getChannel() {
        return ChannelHelper.readCacheChannel();
    }

    public static String getChannel(TrackerChannel trackerChannel) {
        return ChannelHelper.readOrCreateChannelSafely(trackerChannel);
    }

    private static String readOrCreateChannelSafely(TrackerChannel trackerChannel) {
        ChannelHelper.lockSafeCheck();
        return ChannelHelper.readOrCreateChannel(trackerChannel);
    }

    private static void lockSafeCheck() {
        if (!Thread.holdsLock(ChannelHelper.class)) {
            return;
        }
        throw new IllegalStateException("\u5373\u5c06\u8fdb\u5165\u5806\u6808\u6ea2\u51fa\u5566");
    }

    private static synchronized String readOrCreateChannel(TrackerChannel object) {
        object = ChannelHelper.readCacheChannel();
        if (TextUtils.isEmpty((CharSequence)object)) {
            object = ChannelHelper.getDefaultChannel();
        } else {
            GameSDKUtils.LOG.i((Object)("Get Channel from storage is " + (String)object));
        }
        return object;
    }

    private static synchronized String readCacheChannel() {
        if (TextUtils.isEmpty((CharSequence)cacheChannel)) {
            cacheChannel = EncryptSP.getString(SP_KEY_CHANNEL, null);
        }
        return cacheChannel;
    }

    private static String getDefaultChannel() {
        return GameCoreInitializer.get().channel;
    }
}

