/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.game.datastore;

import android.content.Context;
import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.room.migration.Migration;
import com.transsion.game.datastore.DataInitializer;
import com.transsion.game.datastore.DbUpgrade;
import com.transsion.game.datastore.dao.Daos;
import com.transsion.game.datastore.table.BaseConfigTable;
import com.transsion.game.datastore.table.GameConfigTable;
import com.transsion.game.datastore.table.OrderCacheTable;
import com.transsion.game.datastore.table.OrderTable;
import com.transsion.game.datastore.table.PriceConverterTable;

@Database(entities={OrderTable.class, BaseConfigTable.class, GameConfigTable.class, OrderCacheTable.class, PriceConverterTable.class}, version=5)
abstract class AppDb
extends RoomDatabase
implements Daos {
    AppDb() {
    }

    static AppDb get() {
        return Singleton.INSTANCE;
    }

    private static class Singleton {
        private static final AppDb INSTANCE = (AppDb)Room.databaseBuilder((Context)DataInitializer.getContext(), AppDb.class, (String)"gamepay.db").addMigrations(new Migration[]{new DbUpgrade.Migration_1_2(), new DbUpgrade.Migration_2_3(), new DbUpgrade.Migration_3_4(), new DbUpgrade.Migration_4_5()}).setJournalMode(RoomDatabase.JournalMode.TRUNCATE).fallbackToDestructiveMigrationOnDowngrade().build();

        private Singleton() {
        }
    }
}

