/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.game.datastore;

import android.content.Context;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.transsion.game.datastore.AppDb;
import com.transsion.game.datastore.dao.BaseConfigDao;
import com.transsion.game.datastore.dao.BaseConfigDao_Impl;
import com.transsion.game.datastore.dao.GameConfigDao;
import com.transsion.game.datastore.dao.GameConfigDao_Impl;
import com.transsion.game.datastore.dao.OrderCacheDao;
import com.transsion.game.datastore.dao.OrderCacheDao_Impl;
import com.transsion.game.datastore.dao.OrderDao;
import com.transsion.game.datastore.dao.OrderDao_Impl;
import com.transsion.game.datastore.dao.PriceConverterDao;
import com.transsion.game.datastore.dao.PriceConverterDao_Impl;
import java.util.HashMap;
import java.util.HashSet;

public final class AppDb_Impl
extends AppDb {
    private volatile BaseConfigDao _baseConfigDao;
    private volatile GameConfigDao _gameConfigDao;
    private volatile OrderDao _orderDao;
    private volatile OrderCacheDao _orderCacheDao;
    private volatile PriceConverterDao _priceConverterDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(5){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `Order` (`id` TEXT NOT NULL, `encryptInfo` TEXT, `key` TEXT, `iv` TEXT, `retryCount` INTEGER NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `BaseConfig` (`configId` TEXT NOT NULL, `mcc` TEXT, `level` TEXT, `amount` TEXT, `mccMnc` TEXT, PRIMARY KEY(`configId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `GameConfig` (`appKey` TEXT NOT NULL, `productId` TEXT NOT NULL, `cpProductId` TEXT, `productName` TEXT, `productDesc` TEXT, `onlineAmount` TEXT, `level` TEXT, PRIMARY KEY(`appKey`, `productId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `order_cache` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `encrypted_pay_params` TEXT NOT NULL, `encrypted_info` TEXT NOT NULL, `encrypted_extra` TEXT, `sp_key` TEXT NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `price_convert` (`mcc` TEXT NOT NULL, `country_code` TEXT NOT NULL, `rate` TEXT NOT NULL, `currency` TEXT NOT NULL, `symbol` TEXT, `timestamp` INTEGER NOT NULL, PRIMARY KEY(`mcc`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'fd9dee2fd29392a1cf0a89f9429ac85d')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `Order`");
                _db.execSQL("DROP TABLE IF EXISTS `BaseConfig`");
                _db.execSQL("DROP TABLE IF EXISTS `GameConfig`");
                _db.execSQL("DROP TABLE IF EXISTS `order_cache`");
                _db.execSQL("DROP TABLE IF EXISTS `price_convert`");
                if (AppDb_Impl.this.mCallbacks != null) {
                    int _size = AppDb_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AppDb_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (AppDb_Impl.this.mCallbacks != null) {
                    int _size = AppDb_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AppDb_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                AppDb_Impl.this.mDatabase = _db;
                AppDb_Impl.this.internalInitInvalidationTracker(_db);
                if (AppDb_Impl.this.mCallbacks != null) {
                    int _size = AppDb_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AppDb_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsOrder = new HashMap<String, TableInfo.Column>(5);
                _columnsOrder.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                _columnsOrder.put("encryptInfo", new TableInfo.Column("encryptInfo", "TEXT", false, 0, null, 1));
                _columnsOrder.put("key", new TableInfo.Column("key", "TEXT", false, 0, null, 1));
                _columnsOrder.put("iv", new TableInfo.Column("iv", "TEXT", false, 0, null, 1));
                _columnsOrder.put("retryCount", new TableInfo.Column("retryCount", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysOrder = new HashSet(0);
                HashSet _indicesOrder = new HashSet(0);
                TableInfo _infoOrder = new TableInfo("Order", _columnsOrder, _foreignKeysOrder, _indicesOrder);
                TableInfo _existingOrder = TableInfo.read((SupportSQLiteDatabase)_db, (String)"Order");
                if (!_infoOrder.equals((Object)_existingOrder)) {
                    return new RoomOpenHelper.ValidationResult(false, "Order(com.transsion.game.datastore.table.OrderTable).\n Expected:\n" + _infoOrder + "\n Found:\n" + _existingOrder);
                }
                HashMap<String, TableInfo.Column> _columnsBaseConfig = new HashMap<String, TableInfo.Column>(5);
                _columnsBaseConfig.put("configId", new TableInfo.Column("configId", "TEXT", true, 1, null, 1));
                _columnsBaseConfig.put("mcc", new TableInfo.Column("mcc", "TEXT", false, 0, null, 1));
                _columnsBaseConfig.put("level", new TableInfo.Column("level", "TEXT", false, 0, null, 1));
                _columnsBaseConfig.put("amount", new TableInfo.Column("amount", "TEXT", false, 0, null, 1));
                _columnsBaseConfig.put("mccMnc", new TableInfo.Column("mccMnc", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysBaseConfig = new HashSet(0);
                HashSet _indicesBaseConfig = new HashSet(0);
                TableInfo _infoBaseConfig = new TableInfo("BaseConfig", _columnsBaseConfig, _foreignKeysBaseConfig, _indicesBaseConfig);
                TableInfo _existingBaseConfig = TableInfo.read((SupportSQLiteDatabase)_db, (String)"BaseConfig");
                if (!_infoBaseConfig.equals((Object)_existingBaseConfig)) {
                    return new RoomOpenHelper.ValidationResult(false, "BaseConfig(com.transsion.game.datastore.table.BaseConfigTable).\n Expected:\n" + _infoBaseConfig + "\n Found:\n" + _existingBaseConfig);
                }
                HashMap<String, TableInfo.Column> _columnsGameConfig = new HashMap<String, TableInfo.Column>(7);
                _columnsGameConfig.put("appKey", new TableInfo.Column("appKey", "TEXT", true, 1, null, 1));
                _columnsGameConfig.put("productId", new TableInfo.Column("productId", "TEXT", true, 2, null, 1));
                _columnsGameConfig.put("cpProductId", new TableInfo.Column("cpProductId", "TEXT", false, 0, null, 1));
                _columnsGameConfig.put("productName", new TableInfo.Column("productName", "TEXT", false, 0, null, 1));
                _columnsGameConfig.put("productDesc", new TableInfo.Column("productDesc", "TEXT", false, 0, null, 1));
                _columnsGameConfig.put("onlineAmount", new TableInfo.Column("onlineAmount", "TEXT", false, 0, null, 1));
                _columnsGameConfig.put("level", new TableInfo.Column("level", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysGameConfig = new HashSet(0);
                HashSet _indicesGameConfig = new HashSet(0);
                TableInfo _infoGameConfig = new TableInfo("GameConfig", _columnsGameConfig, _foreignKeysGameConfig, _indicesGameConfig);
                TableInfo _existingGameConfig = TableInfo.read((SupportSQLiteDatabase)_db, (String)"GameConfig");
                if (!_infoGameConfig.equals((Object)_existingGameConfig)) {
                    return new RoomOpenHelper.ValidationResult(false, "GameConfig(com.transsion.game.datastore.table.GameConfigTable).\n Expected:\n" + _infoGameConfig + "\n Found:\n" + _existingGameConfig);
                }
                HashMap<String, TableInfo.Column> _columnsOrderCache = new HashMap<String, TableInfo.Column>(5);
                _columnsOrderCache.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsOrderCache.put("encrypted_pay_params", new TableInfo.Column("encrypted_pay_params", "TEXT", true, 0, null, 1));
                _columnsOrderCache.put("encrypted_info", new TableInfo.Column("encrypted_info", "TEXT", true, 0, null, 1));
                _columnsOrderCache.put("encrypted_extra", new TableInfo.Column("encrypted_extra", "TEXT", false, 0, null, 1));
                _columnsOrderCache.put("sp_key", new TableInfo.Column("sp_key", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysOrderCache = new HashSet(0);
                HashSet _indicesOrderCache = new HashSet(0);
                TableInfo _infoOrderCache = new TableInfo("order_cache", _columnsOrderCache, _foreignKeysOrderCache, _indicesOrderCache);
                TableInfo _existingOrderCache = TableInfo.read((SupportSQLiteDatabase)_db, (String)"order_cache");
                if (!_infoOrderCache.equals((Object)_existingOrderCache)) {
                    return new RoomOpenHelper.ValidationResult(false, "order_cache(com.transsion.game.datastore.table.OrderCacheTable).\n Expected:\n" + _infoOrderCache + "\n Found:\n" + _existingOrderCache);
                }
                HashMap<String, TableInfo.Column> _columnsPriceConvert = new HashMap<String, TableInfo.Column>(6);
                _columnsPriceConvert.put("mcc", new TableInfo.Column("mcc", "TEXT", true, 1, null, 1));
                _columnsPriceConvert.put("country_code", new TableInfo.Column("country_code", "TEXT", true, 0, null, 1));
                _columnsPriceConvert.put("rate", new TableInfo.Column("rate", "TEXT", true, 0, null, 1));
                _columnsPriceConvert.put("currency", new TableInfo.Column("currency", "TEXT", true, 0, null, 1));
                _columnsPriceConvert.put("symbol", new TableInfo.Column("symbol", "TEXT", false, 0, null, 1));
                _columnsPriceConvert.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysPriceConvert = new HashSet(0);
                HashSet _indicesPriceConvert = new HashSet(0);
                TableInfo _infoPriceConvert = new TableInfo("price_convert", _columnsPriceConvert, _foreignKeysPriceConvert, _indicesPriceConvert);
                TableInfo _existingPriceConvert = TableInfo.read((SupportSQLiteDatabase)_db, (String)"price_convert");
                if (!_infoPriceConvert.equals((Object)_existingPriceConvert)) {
                    return new RoomOpenHelper.ValidationResult(false, "price_convert(com.transsion.game.datastore.table.PriceConverterTable).\n Expected:\n" + _infoPriceConvert + "\n Found:\n" + _existingPriceConvert);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "fd9dee2fd29392a1cf0a89f9429ac85d", "f8c5ba8e8cbfcf783de2590964197418");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"Order", "BaseConfig", "GameConfig", "order_cache", "price_convert"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `Order`");
            _db.execSQL("DELETE FROM `BaseConfig`");
            _db.execSQL("DELETE FROM `GameConfig`");
            _db.execSQL("DELETE FROM `order_cache`");
            _db.execSQL("DELETE FROM `price_convert`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseConfigDao baseConfigDao() {
        if (this._baseConfigDao != null) {
            return this._baseConfigDao;
        }
        AppDb_Impl appDb_Impl = this;
        synchronized (appDb_Impl) {
            if (this._baseConfigDao == null) {
                this._baseConfigDao = new BaseConfigDao_Impl(this);
            }
            return this._baseConfigDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GameConfigDao gameConfigDao() {
        if (this._gameConfigDao != null) {
            return this._gameConfigDao;
        }
        AppDb_Impl appDb_Impl = this;
        synchronized (appDb_Impl) {
            if (this._gameConfigDao == null) {
                this._gameConfigDao = new GameConfigDao_Impl(this);
            }
            return this._gameConfigDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrderDao orderDao() {
        if (this._orderDao != null) {
            return this._orderDao;
        }
        AppDb_Impl appDb_Impl = this;
        synchronized (appDb_Impl) {
            if (this._orderDao == null) {
                this._orderDao = new OrderDao_Impl(this);
            }
            return this._orderDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrderCacheDao orderCacheDao() {
        if (this._orderCacheDao != null) {
            return this._orderCacheDao;
        }
        AppDb_Impl appDb_Impl = this;
        synchronized (appDb_Impl) {
            if (this._orderCacheDao == null) {
                this._orderCacheDao = new OrderCacheDao_Impl(this);
            }
            return this._orderCacheDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PriceConverterDao priceConverterDao() {
        if (this._priceConverterDao != null) {
            return this._priceConverterDao;
        }
        AppDb_Impl appDb_Impl = this;
        synchronized (appDb_Impl) {
            if (this._priceConverterDao == null) {
                this._priceConverterDao = new PriceConverterDao_Impl(this);
            }
            return this._priceConverterDao;
        }
    }
}

