/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.game.datastore;

import androidx.annotation.NonNull;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DbUpgrade {
    public static final String TAG = "DbUpgrade";
    public static final boolean DEBUG = false;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private volatile List<DbMigration> observers;

    public static DbUpgrade get() {
        return Singleton.INSTANCE;
    }

    private DbUpgrade() {
    }

    public boolean addObserver(DbMigration dbMigration) {
        boolean result;
        if (dbMigration == null) {
            return false;
        }
        this.writeLock.lock();
        if (this.observers == null) {
            this.observers = new ArrayList<DbMigration>(1);
        }
        if (this.observers.contains(dbMigration)) {
            result = false;
        } else {
            this.observers.add(dbMigration);
            result = true;
        }
        this.writeLock.unlock();
        return result;
    }

    private List<DbMigration> popObservers() {
        this.writeLock.lock();
        List<DbMigration> observers = this.observers;
        this.observers = null;
        this.writeLock.unlock();
        return observers;
    }

    static class Migration_4_5
    extends MigrationWrapper {
        public Migration_4_5() {
            super(4, 5);
        }

        @Override
        public void onMigrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL("CREATE TABLE IF NOT EXISTS `price_convert` (`mcc` TEXT NOT NULL, `country_code` TEXT NOT NULL, `rate` TEXT NOT NULL, `currency` TEXT NOT NULL, `symbol` TEXT, `timestamp` INTEGER NOT NULL, PRIMARY KEY(`mcc`))");
        }
    }

    static class Migration_3_4
    extends MigrationWrapper {
        public Migration_3_4() {
            super(3, 4);
        }

        @Override
        public void onMigrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL("CREATE TABLE IF NOT EXISTS `order_cache` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `encrypted_pay_params` TEXT NOT NULL, `encrypted_info` TEXT NOT NULL, `encrypted_extra` TEXT, `sp_key` TEXT NOT NULL)");
        }
    }

    static class Migration_2_3
    extends MigrationWrapper {
        public Migration_2_3() {
            super(2, 3);
        }

        @Override
        public void onMigrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `GameConfig` ADD `cpProductId` TEXT");
            database.execSQL("ALTER TABLE `GameConfig` ADD `productDesc` TEXT");
        }
    }

    static class Migration_1_2
    extends MigrationWrapper {
        public Migration_1_2() {
            super(1, 2);
        }

        @Override
        public void onMigrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE `GameConfig` ADD `onlineAmount` TEXT");
        }
    }

    static abstract class MigrationWrapper
    extends Migration {
        public MigrationWrapper(int startVersion, int endVersion) {
            super(startVersion, endVersion);
        }

        public final void migrate(@NonNull SupportSQLiteDatabase database) {
            int size;
            this.onMigrate(database);
            List observers = DbUpgrade.get().popObservers();
            int n = size = observers == null ? 0 : observers.size();
            if (size > 0) {
                for (DbMigration dbMigration : observers) {
                    dbMigration.migrate(this.startVersion, this.endVersion, database);
                }
            }
        }

        public abstract void onMigrate(@NonNull SupportSQLiteDatabase var1);
    }

    public static interface DbMigration {
        public void migrate(int var1, int var2, @NonNull SupportSQLiteDatabase var3);
    }

    private static class Singleton {
        private static final DbUpgrade INSTANCE = new DbUpgrade();

        private Singleton() {
        }
    }
}

