/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.game.datastore.cache;

import android.content.Context;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.transsion.game.datastore.DataInitializer;
import com.transsion.game.datastore.cache.DbInit;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class DbInitRunnable<T>
implements Runnable {
    private final DbInit<T, ?> dbInit;
    private static final String TAG = "DbInitRunnable";
    private static final boolean DEBUG = false;

    public DbInitRunnable(DbInit<T, ?> dbInit) {
        this.dbInit = dbInit;
    }

    @Override
    public void run() {
        this.onRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRun() {
        int[] countArray = this.dbInit.getCounts();
        boolean needInit = false;
        if (countArray.length == 0) {
            needInit = true;
        } else {
            for (int count : countArray) {
                if (count > 0) continue;
                needInit = true;
                break;
            }
        }
        if (!needInit) {
            return;
        }
        String fileName = this.dbInit.getAssetsFileName();
        InputStream is = null;
        Context context = DataInitializer.getContext();
        try {
            is = context.getAssets().open(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (is == null) {
            return;
        }
        InputStreamReader reader = new InputStreamReader(is);
        Gson gson = new Gson();
        Object data = null;
        try {
            data = gson.fromJson((Reader)reader, this.dbInit.getDataType());
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (data == null) {
            return;
        }
        this.dbInit.insertToDb(data);
    }
}

