/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.game.datastore.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.transsion.game.datastore.dao.OrderCacheDao;
import com.transsion.game.datastore.table.OrderCacheTable;
import java.util.ArrayList;
import java.util.List;

public final class OrderCacheDao_Impl
implements OrderCacheDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<OrderCacheTable> __insertionAdapterOfOrderCacheTable;
    private final SharedSQLiteStatement __preparedStmtOfUpdate;
    private final SharedSQLiteStatement __preparedStmtOfUpdateEncryptedExtra;
    private final SharedSQLiteStatement __preparedStmtOfRemove;

    public OrderCacheDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfOrderCacheTable = new EntityInsertionAdapter<OrderCacheTable>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `order_cache` (`id`,`encrypted_pay_params`,`encrypted_info`,`encrypted_extra`,`sp_key`) VALUES (nullif(?, 0),?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, OrderCacheTable value) {
                stmt.bindLong(1, value.id);
                if (value.encryptedPayParams == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.encryptedPayParams);
                }
                if (value.encryptedInfo == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.encryptedInfo);
                }
                if (value.encryptedExtra == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.encryptedExtra);
                }
                if (value.spKey == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.spKey);
                }
            }
        };
        this.__preparedStmtOfUpdate = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "update order_cache set encrypted_info=? where id=?";
                return "update order_cache set encrypted_info=? where id=?";
            }
        };
        this.__preparedStmtOfUpdateEncryptedExtra = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "update order_cache set encrypted_extra=? where id=?";
                return "update order_cache set encrypted_extra=? where id=?";
            }
        };
        this.__preparedStmtOfRemove = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from order_cache where id =?";
                return "delete from order_cache where id =?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insertRecord(OrderCacheTable orderCacheTable) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfOrderCacheTable.insertAndReturnId((Object)orderCacheTable);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(long id, String encryptedInfo) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdate.acquire();
        int _argIndex = 1;
        if (encryptedInfo == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, encryptedInfo);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, id);
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdate.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateEncryptedExtra(long id, String encryptedExtra) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateEncryptedExtra.acquire();
        int _argIndex = 1;
        if (encryptedExtra == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, encryptedExtra);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, id);
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateEncryptedExtra.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(long id) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfRemove.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, id);
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfRemove.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OrderCacheTable> getAll() {
        String _sql = "select * from order_cache";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from order_cache", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfEncryptedPayParams = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encrypted_pay_params");
            int _cursorIndexOfEncryptedInfo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encrypted_info");
            int _cursorIndexOfEncryptedExtra = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encrypted_extra");
            int _cursorIndexOfSpKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sp_key");
            ArrayList<OrderCacheTable> _result = new ArrayList<OrderCacheTable>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpEncryptedPayParams = _cursor.getString(_cursorIndexOfEncryptedPayParams);
                String _tmpEncryptedInfo = _cursor.getString(_cursorIndexOfEncryptedInfo);
                String _tmpSpKey = _cursor.getString(_cursorIndexOfSpKey);
                OrderCacheTable _item = new OrderCacheTable(_tmpEncryptedPayParams, _tmpEncryptedInfo, _tmpSpKey);
                _item.id = _cursor.getLong(_cursorIndexOfId);
                _item.encryptedExtra = _cursor.getString(_cursorIndexOfEncryptedExtra);
                _result.add(_item);
            }
            ArrayList<OrderCacheTable> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

