/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.game.datastore.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Transaction;
import com.transsion.game.datastore.table.PriceConverterTable;
import java.util.List;

@Dao
public abstract class PriceConverterDao {
    @Transaction
    public void clearAndInsertList(List<PriceConverterTable> priceConverterTableList) {
        int size;
        this.clearTable();
        int n = size = priceConverterTableList == null ? 0 : priceConverterTableList.size();
        if (size > 0) {
            this.insertList(priceConverterTableList);
        }
    }

    @Query(value="select * from price_convert where mcc=:mcc")
    public abstract PriceConverterTable getByMcc(String var1);

    @Query(value="select mcc from price_convert where country_code=:countryCode")
    public abstract String getMccByCountryCode(String var1);

    @Query(value="select * from price_convert where country_code=:countryCode")
    public abstract PriceConverterTable getByCountryCode(String var1);

    @Insert(onConflict=1)
    public abstract void insertList(List<PriceConverterTable> var1);

    @Query(value="delete from price_convert")
    public abstract void clearTable();

    @Query(value="select min(timestamp) from price_convert")
    public abstract Long getMinTimestamp();

    @Query(value="select 1 from price_convert limit 1")
    public abstract int[] existCount();
}

