/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.game.datastore.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.transsion.game.datastore.dao.PriceConverterDao;
import com.transsion.game.datastore.table.PriceConverterTable;
import java.util.List;

public final class PriceConverterDao_Impl
extends PriceConverterDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PriceConverterTable> __insertionAdapterOfPriceConverterTable;
    private final SharedSQLiteStatement __preparedStmtOfClearTable;

    public PriceConverterDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPriceConverterTable = new EntityInsertionAdapter<PriceConverterTable>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `price_convert` (`mcc`,`country_code`,`rate`,`currency`,`symbol`,`timestamp`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, PriceConverterTable value) {
                if (value.mcc == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.mcc);
                }
                if (value.countryCode == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.countryCode);
                }
                if (value.rate == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.rate);
                }
                if (value.currency == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.currency);
                }
                if (value.symbol == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.symbol);
                }
                stmt.bindLong(6, value.updateTimestamp);
            }
        };
        this.__preparedStmtOfClearTable = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from price_convert";
                return "delete from price_convert";
            }
        };
    }

    @Override
    public void insertList(List<PriceConverterTable> priceConverterTableList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPriceConverterTable.insert(priceConverterTableList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clearAndInsertList(List<PriceConverterTable> priceConverterTableList) {
        this.__db.beginTransaction();
        try {
            PriceConverterDao_Impl.super.clearAndInsertList(priceConverterTableList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clearTable() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClearTable.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClearTable.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PriceConverterTable getByMcc(String mcc) {
        String _sql = "select * from price_convert where mcc=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from price_convert where mcc=?", (int)1);
        int _argIndex = 1;
        if (mcc == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, mcc);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            PriceConverterTable _result;
            int _cursorIndexOfMcc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mcc");
            int _cursorIndexOfCountryCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"country_code");
            int _cursorIndexOfRate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rate");
            int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
            int _cursorIndexOfSymbol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"symbol");
            int _cursorIndexOfUpdateTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                String _tmpMcc = _cursor.getString(_cursorIndexOfMcc);
                String _tmpCountryCode = _cursor.getString(_cursorIndexOfCountryCode);
                String _tmpRate = _cursor.getString(_cursorIndexOfRate);
                String _tmpCurrency = _cursor.getString(_cursorIndexOfCurrency);
                _result = new PriceConverterTable(_tmpMcc, _tmpCountryCode, _tmpRate, _tmpCurrency);
                _result.symbol = _cursor.getString(_cursorIndexOfSymbol);
                _result.updateTimestamp = _cursor.getLong(_cursorIndexOfUpdateTimestamp);
            } else {
                _result = null;
            }
            PriceConverterTable priceConverterTable = _result;
            return priceConverterTable;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMccByCountryCode(String countryCode) {
        String _sql = "select mcc from price_convert where country_code=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select mcc from price_convert where country_code=?", (int)1);
        int _argIndex = 1;
        if (countryCode == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, countryCode);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            String _result = _cursor.moveToFirst() ? _cursor.getString(0) : null;
            String string = _result;
            return string;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PriceConverterTable getByCountryCode(String countryCode) {
        String _sql = "select * from price_convert where country_code=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from price_convert where country_code=?", (int)1);
        int _argIndex = 1;
        if (countryCode == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, countryCode);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            PriceConverterTable _result;
            int _cursorIndexOfMcc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mcc");
            int _cursorIndexOfCountryCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"country_code");
            int _cursorIndexOfRate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rate");
            int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
            int _cursorIndexOfSymbol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"symbol");
            int _cursorIndexOfUpdateTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                String _tmpMcc = _cursor.getString(_cursorIndexOfMcc);
                String _tmpCountryCode = _cursor.getString(_cursorIndexOfCountryCode);
                String _tmpRate = _cursor.getString(_cursorIndexOfRate);
                String _tmpCurrency = _cursor.getString(_cursorIndexOfCurrency);
                _result = new PriceConverterTable(_tmpMcc, _tmpCountryCode, _tmpRate, _tmpCurrency);
                _result.symbol = _cursor.getString(_cursorIndexOfSymbol);
                _result.updateTimestamp = _cursor.getLong(_cursorIndexOfUpdateTimestamp);
            } else {
                _result = null;
            }
            PriceConverterTable priceConverterTable = _result;
            return priceConverterTable;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getMinTimestamp() {
        String _sql = "select min(timestamp) from price_convert";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select min(timestamp) from price_convert", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Long _result;
            if (_cursor.moveToFirst()) {
                Long _tmp = _cursor.isNull(0) ? null : Long.valueOf(_cursor.getLong(0));
                _result = _tmp;
            } else {
                _result = null;
            }
            Long l = _result;
            return l;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] existCount() {
        String _sql = "select 1 from price_convert limit 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select 1 from price_convert limit 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int[] _result = new int[_cursor.getCount()];
            int _index = 0;
            while (_cursor.moveToNext()) {
                int _item;
                _result[_index] = _item = _cursor.getInt(0);
                ++_index;
            }
            int[] nArray = _result;
            return nArray;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

