/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.game.datastore.dao.proxy;

import com.transsion.game.datastore.DataInitializer;
import com.transsion.game.datastore.cache.DbInit;
import com.transsion.game.datastore.cache.DbInitRunnable;
import com.transsion.game.datastore.dao.GameConfigDao;
import com.transsion.game.datastore.table.GameConfigTable;
import java.util.List;

public class GameConfigDaoProxy
extends GameConfigDao {
    private static volatile boolean sInitialized;
    private final GameConfigDao realDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(GameConfigDao dao) {
        if (sInitialized) {
            return;
        }
        Class<GameConfigDao> clazz = GameConfigDao.class;
        synchronized (GameConfigDao.class) {
            if (sInitialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            DbInit<?, GameConfigDao> dbInit = DataInitializer.getDbInit(GameConfigDao.class);
            if (dbInit != null) {
                dbInit.injectDao(dao);
                new DbInitRunnable(dbInit).run();
            }
            sInitialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public GameConfigDaoProxy(GameConfigDao realDao) {
        this.realDao = realDao;
        GameConfigDaoProxy.init(this);
    }

    @Override
    public void insertGameConfig(List<GameConfigTable> list) {
        try {
            this.realDao.insertGameConfig(list);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void clearTable(String appKey) {
        try {
            this.realDao.clearTable(appKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int count() {
        try {
            return this.realDao.count();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public GameConfigTable getGameConfig(String appKey, String productId) {
        GameConfigTable table = null;
        try {
            table = this.realDao.getGameConfig(appKey, productId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return table;
    }

    @Override
    public List<GameConfigTable> getGameConfig(String appKey) {
        try {
            return this.realDao.getGameConfig(appKey);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void clearAndInsertWithoutNull(String appKey, List<GameConfigTable> list) {
        try {
            this.realDao.clearAndInsertWithoutNull(appKey, list);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

