/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.game.datastore.sp;

import android.content.Context;
import android.content.SharedPreferences;
import android.security.KeyPairGeneratorSpec;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.transsion.game.datastore.util.MD5Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;

public class EncryptedSP
implements SharedPreferences {
    private final SharedPreferences mSharedPreferences;
    private final Context context;
    private final String fileName;

    EncryptedSP(Context context, String fileName) {
        this.context = context;
        this.fileName = fileName;
        this.mSharedPreferences = context.getSharedPreferences(fileName, 0);
    }

    public Map<String, ?> getAll() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getString(String key, @Nullable String defValue) {
        String string = this.mSharedPreferences.getString(key, null);
        if (string == null) {
            return defValue;
        }
        String text = SecurityHelper.decrypt(this.context, this.fileName, string);
        if (text == null) {
            return defValue;
        }
        return text;
    }

    @Nullable
    public Set<String> getStringSet(String key, @Nullable Set<String> defValues) {
        throw new UnsupportedOperationException();
    }

    public int getInt(String key, int defValue) {
        String string = this.mSharedPreferences.getString(key, null);
        if (string == null) {
            return defValue;
        }
        String text = SecurityHelper.decrypt(this.context, this.fileName, string);
        if (text == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            return defValue;
        }
    }

    public long getLong(String key, long defValue) {
        String string = this.mSharedPreferences.getString(key, null);
        if (string == null) {
            return defValue;
        }
        String text = SecurityHelper.decrypt(this.context, this.fileName, string);
        if (text == null) {
            return defValue;
        }
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException numberFormatException) {
            return defValue;
        }
    }

    public float getFloat(String key, float defValue) {
        String string = this.mSharedPreferences.getString(key, null);
        if (string == null) {
            return defValue;
        }
        String text = SecurityHelper.decrypt(this.context, this.fileName, string);
        if (text == null) {
            return defValue;
        }
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException numberFormatException) {
            return defValue;
        }
    }

    public boolean getBoolean(String key, boolean defValue) {
        String string = this.mSharedPreferences.getString(key, null);
        if (string == null) {
            return defValue;
        }
        String text = SecurityHelper.decrypt(this.context, this.fileName, string);
        if (text == null) {
            return defValue;
        }
        try {
            return Boolean.parseBoolean(text);
        }
        catch (NumberFormatException numberFormatException) {
            return defValue;
        }
    }

    public boolean contains(String key) {
        return this.mSharedPreferences.contains(key);
    }

    public SharedPreferences.Editor edit() {
        return new SecurityEditor(this.context, this.mSharedPreferences.edit(), this.fileName);
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    private static class SecurityHelper {
        private static final String ANDROID_KEYSTORE = "AndroidKeyStore";
        private static final String RSA_MODE = "RSA/ECB/PKCS1Padding";
        private static final String AES_MODE_DEFAULT = "AES/ECB/PKCS7Padding";
        static final String MASTER_KEY_ALIAS = "_androidx_security_master_key_";
        private static final String SECURE_KEY = "EncryptSecureKey";

        private SecurityHelper() {
        }

        private static KeyStore getAndroidKeystore(Context context) {
            KeyStore keyStore = null;
            try {
                keyStore = KeyStore.getInstance(ANDROID_KEYSTORE);
                keyStore.load(null);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                e.printStackTrace();
            }
            if (keyStore == null) {
                return null;
            }
            try {
                KeyPair keyPair;
                if (!keyStore.containsAlias(MASTER_KEY_ALIAS) && (keyPair = SecurityHelper.genAndroidKeystoreRsaKeyPair(context)) == null) {
                    return null;
                }
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            return keyStore;
        }

        private static KeyPair genAndroidKeystoreRsaKeyPair(Context context) {
            KeyPairGenerator kpg = null;
            try {
                kpg = KeyPairGenerator.getInstance("RSA", ANDROID_KEYSTORE);
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                e.printStackTrace();
            }
            if (kpg == null) {
                return null;
            }
            Calendar start = Calendar.getInstance();
            Calendar end = Calendar.getInstance();
            end.add(1, 30);
            KeyPairGeneratorSpec algorithmParameterSpec = new KeyPairGeneratorSpec.Builder(context).setAlias(MASTER_KEY_ALIAS).setSubject(new X500Principal("CN=_androidx_security_master_key_")).setSerialNumber(BigInteger.TEN).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
            try {
                kpg.initialize((AlgorithmParameterSpec)algorithmParameterSpec);
            }
            catch (InvalidAlgorithmParameterException e) {
                e.printStackTrace();
                return null;
            }
            return kpg.generateKeyPair();
        }

        private static byte[] rsaEncrypt(Context context, byte[] secret) throws Exception {
            KeyStore keystore = SecurityHelper.getAndroidKeystore(context);
            if (keystore == null) {
                return null;
            }
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keystore.getEntry(MASTER_KEY_ALIAS, null);
            Cipher inputCipher = Cipher.getInstance(RSA_MODE, "AndroidOpenSSL");
            inputCipher.init(1, privateKeyEntry.getCertificate().getPublicKey());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, inputCipher);
            cipherOutputStream.write(secret);
            cipherOutputStream.close();
            return outputStream.toByteArray();
        }

        private static byte[] rsaDecrypt(Context context, byte[] encrypted) throws Exception {
            int nextByte;
            KeyStore keystore = SecurityHelper.getAndroidKeystore(context);
            if (keystore == null) {
                return null;
            }
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keystore.getEntry(MASTER_KEY_ALIAS, null);
            Cipher output = Cipher.getInstance(RSA_MODE, "AndroidOpenSSL");
            output.init(2, privateKeyEntry.getPrivateKey());
            CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(encrypted), output);
            ArrayList<Byte> values = new ArrayList<Byte>();
            while ((nextByte = cipherInputStream.read()) != -1) {
                values.add((byte)nextByte);
            }
            byte[] bytes = new byte[values.size()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (Byte)values.get(i);
            }
            return bytes;
        }

        private static Key getSecretKey(Context context, String fileName, @NonNull String secureKey) throws Exception {
            SharedPreferences pref = context.getSharedPreferences(fileName, 0);
            String encryptedKeyB64 = pref.getString(secureKey, null);
            if (encryptedKeyB64 == null) {
                byte[] key = new byte[16];
                SecureRandom secureRandom = new SecureRandom();
                secureRandom.nextBytes(key);
                byte[] rsaEncrypt = SecurityHelper.rsaEncrypt(context, key);
                byte[] base64Encrypt = Base64.encode((byte[])rsaEncrypt, (int)0);
                pref.edit().putString(secureKey, new String(base64Encrypt)).apply();
                return new SecretKeySpec(key, "AES");
            }
            byte[] encryptedKey = Base64.decode((String)encryptedKeyB64, (int)0);
            byte[] key = SecurityHelper.rsaDecrypt(context, encryptedKey);
            return new SecretKeySpec(key, "AES");
        }

        private static String getKeyOfKey() {
            return MD5Utils.md5(SECURE_KEY);
        }

        private static String encrypt(Context context, String fileName, byte[] input) {
            String key = SecurityHelper.getKeyOfKey();
            byte[] encodedBytes = null;
            try {
                Cipher c = Cipher.getInstance(AES_MODE_DEFAULT, "BC");
                c.init(1, SecurityHelper.getSecretKey(context, fileName, key));
                encodedBytes = c.doFinal(input);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (encodedBytes == null) {
                return null;
            }
            return Base64.encodeToString(encodedBytes, (int)0);
        }

        private static String decrypt(Context context, String fileName, String base64Text) {
            if (base64Text == null) {
                return null;
            }
            byte[] encrypted = Base64.decode((String)base64Text, (int)0);
            if (encrypted == null || encrypted.length == 0) {
                return null;
            }
            String key = SecurityHelper.getKeyOfKey();
            byte[] decodedBytes = null;
            try {
                Cipher c = Cipher.getInstance(AES_MODE_DEFAULT, "BC");
                c.init(2, SecurityHelper.getSecretKey(context, fileName, key));
                decodedBytes = c.doFinal(encrypted);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (decodedBytes == null) {
                return null;
            }
            return new String(decodedBytes);
        }
    }

    private static class SecurityEditor
    implements SharedPreferences.Editor {
        private final Context context;
        private final SharedPreferences.Editor editor;
        private final String fileName;

        private SecurityEditor(Context context, SharedPreferences.Editor editor, String fileName) {
            this.context = context;
            this.editor = editor;
            this.fileName = fileName;
        }

        public SharedPreferences.Editor putString(String key, @Nullable String value) {
            if (value == null) {
                this.editor.putString(key, null);
                return this;
            }
            String text = SecurityHelper.encrypt(this.context, this.fileName, value.getBytes());
            if (text == null) {
                return this;
            }
            this.editor.putString(key, text);
            return this;
        }

        public SharedPreferences.Editor putStringSet(String key, @Nullable Set<String> values) {
            throw new UnsupportedOperationException();
        }

        public SharedPreferences.Editor putInt(String key, int value) {
            String text = SecurityHelper.encrypt(this.context, this.fileName, String.valueOf(value).getBytes());
            if (text == null) {
                return this;
            }
            this.editor.putString(key, text);
            return this;
        }

        public SharedPreferences.Editor putLong(String key, long value) {
            String text = SecurityHelper.encrypt(this.context, this.fileName, String.valueOf(value).getBytes());
            if (text == null) {
                return this;
            }
            this.editor.putString(key, text);
            return this;
        }

        public SharedPreferences.Editor putFloat(String key, float value) {
            String text = SecurityHelper.encrypt(this.context, this.fileName, String.valueOf(value).getBytes());
            if (text == null) {
                return this;
            }
            this.editor.putString(key, text);
            return this;
        }

        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            String text = SecurityHelper.encrypt(this.context, this.fileName, String.valueOf(value).getBytes());
            if (text == null) {
                return this;
            }
            this.editor.putString(key, text);
            return this;
        }

        public SharedPreferences.Editor remove(String key) {
            this.editor.remove(key);
            return this;
        }

        public SharedPreferences.Editor clear() {
            return this.editor.clear();
        }

        public boolean commit() {
            return this.editor.commit();
        }

        public void apply() {
            this.editor.apply();
        }
    }
}

