/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.game.datastore.util;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Utils {
    public static String md5(String string) {
        byte[] hash = MD5Utils.md5ToBytes(string);
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static byte[] md5ToBytes(String string) {
        return MD5Utils.md5ToBytes(string.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] md5ToBytes(byte[] bytes) {
        try {
            return MessageDigest.getInstance("MD5").digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("oh, MD5 not be supported?", e);
        }
    }

    public static String getFileMd5(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        return MD5Utils.getFileMD5(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5(@NonNull File file) {
        MessageDigest digest;
        if (!file.isFile()) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        FileInputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            int len;
            digest = MessageDigest.getInstance("MD5");
            in = new FileInputStream(file);
            while ((len = in.read(buffer, 0, buffer.length)) != -1) {
                digest.update(buffer, 0, len);
            }
        }
        catch (Exception ignore) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return MD5Utils.bytesToHexString(digest.digest());
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (byte b : src) {
            int v = b & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }
}

