/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.gameplugins;

import android.os.Handler;
import android.os.Looper;

public class ThreadHelper {
    public static boolean isUiThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    public static Handler getMainThreadHandler() {
        return HandlerThreadSingleton.MAIN_HANDLER;
    }

    public static void runOnUiThread(Runnable runnable) {
        if (ThreadHelper.isUiThread()) {
            runnable.run();
        } else {
            HandlerThreadSingleton.MAIN_HANDLER.post(runnable);
        }
    }

    public static class HandlerThreadSingleton {
        private static final Handler MAIN_HANDLER = new Handler(Looper.getMainLooper());

        private HandlerThreadSingleton() {
        }
    }
}

