/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hippo.base.clickhouse.http;

import com.google.gson.Gson;
import com.transsion.hippo.base.clickhouse.http.model.ClickHouseResponse;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickHouseClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseClient.class);
    private static final String THREAD_POOL_NAME = "AHC-HIPPO-CH";
    private static final int MAX_CONNECTIONS_DEFAULT = 500;
    private static final int CONNECT_TIMEOUT_DEFAULT = 10000;
    private static final int REQUEST_TIMEOUT_DEFAULT = 30000;
    private static final int READ_TIMEOUT_DEFAULT = 30000;
    private static final String USER_AGENT = "hippo/1.0";
    private static final String INSERT_FORMAT = "TabSeparated";
    private static final String SELECT_FORMAT = "JSON";
    private final String endpoint;
    private final String threadPoolName;
    private final int maxConnections;
    private final int connectTimeout;
    private final int requestTimeout;
    private final int readTimeout;
    private final String userAgent;
    private final int ioThreadsCount;
    private final AsyncHttpClient asyncHttpClient;
    private static final Gson GSON = new Gson();

    public ClickHouseClient(String endpoint) {
        this.endpoint = endpoint;
        this.threadPoolName = THREAD_POOL_NAME;
        this.maxConnections = 500;
        this.connectTimeout = 10000;
        this.requestTimeout = 30000;
        this.readTimeout = 30000;
        this.userAgent = USER_AGENT;
        this.ioThreadsCount = Runtime.getRuntime().availableProcessors() * 2;
        this.asyncHttpClient = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setThreadPoolName(this.threadPoolName).setMaxConnections(this.maxConnections).setConnectTimeout(this.connectTimeout).setRequestTimeout(this.requestTimeout).setReadTimeout(this.readTimeout).setUserAgent(this.userAgent).setKeepAlive(true).setIoThreadsCount(this.ioThreadsCount));
        if (log.isInfoEnabled()) {
            log.info("ClickHouse Client [{}] inited!", (Object)endpoint);
        }
    }

    public ClickHouseClient(String endpoint, String username, String password) {
        this.endpoint = endpoint;
        this.threadPoolName = THREAD_POOL_NAME;
        this.maxConnections = 500;
        this.connectTimeout = 10000;
        this.requestTimeout = 30000;
        this.readTimeout = 30000;
        this.userAgent = USER_AGENT;
        this.ioThreadsCount = Runtime.getRuntime().availableProcessors() * 2;
        this.asyncHttpClient = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRealm(new Realm.Builder(username, password).setUsePreemptiveAuth(true).setScheme(Realm.AuthScheme.BASIC).build()).setThreadPoolName(this.threadPoolName).setMaxConnections(this.maxConnections).setConnectTimeout(this.connectTimeout).setRequestTimeout(this.requestTimeout).setReadTimeout(this.readTimeout).setUserAgent(this.userAgent).setKeepAlive(true).setIoThreadsCount(this.ioThreadsCount));
        if (log.isInfoEnabled()) {
            log.info("ClickHouse Client [{}] inited!", (Object)endpoint);
        }
    }

    public ClickHouseClient(String endpoint, String username, String password, int maxConnections, int connectTimeout, int requestTimeout, int readTimeout, int ioThreadsCount) {
        this.endpoint = endpoint;
        this.threadPoolName = THREAD_POOL_NAME;
        this.maxConnections = maxConnections;
        this.connectTimeout = connectTimeout;
        this.requestTimeout = requestTimeout;
        this.readTimeout = readTimeout;
        this.userAgent = USER_AGENT;
        this.ioThreadsCount = ioThreadsCount;
        this.asyncHttpClient = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRealm(new Realm.Builder(username, password).setUsePreemptiveAuth(true).setScheme(Realm.AuthScheme.BASIC).build()).setThreadPoolName(this.threadPoolName).setMaxConnections(maxConnections).setConnectTimeout(connectTimeout).setRequestTimeout(requestTimeout).setReadTimeout(readTimeout).setUserAgent(this.userAgent).setKeepAlive(true).setIoThreadsCount(ioThreadsCount));
        if (log.isInfoEnabled()) {
            log.info("ClickHouse Client [{}] inited!", (Object)endpoint);
        }
    }

    @Override
    public void close() {
        try {
            this.asyncHttpClient.close();
        }
        catch (Exception e) {
            log.error("ClickHouse Client close error: [{}]", (Object)e.getMessage(), (Object)e);
        }
        if (log.isInfoEnabled()) {
            log.info("ClickHouse Client closed!");
        }
    }

    public <T> CompletableFuture<ClickHouseResponse<T>> select(String sql, Class<T> clazz) {
        String queryWithFormat = sql + " FORMAT " + SELECT_FORMAT;
        Request request = ((BoundRequestBuilder)this.asyncHttpClient.preparePost(this.endpoint).setBody(queryWithFormat)).build();
        if (log.isDebugEnabled()) {
            log.debug("select[{}]", (Object)queryWithFormat);
        }
        try {
            return this.sendRequest(request).thenApply(ClickHouseClient.convert(clazz));
        }
        catch (Exception e) {
            log.error("select error: [{}][{}] - [{}]", new Object[]{this.endpoint, queryWithFormat, e.getMessage()});
            return null;
        }
    }

    public <T> ClickHouseResponse<T> select(String sql, Class<T> clazz, long timeout) {
        String queryWithFormat = sql + " FORMAT " + SELECT_FORMAT;
        Request request = ((BoundRequestBuilder)this.asyncHttpClient.preparePost(this.endpoint).setBody(queryWithFormat)).build();
        if (log.isDebugEnabled()) {
            log.debug("select[{}]", (Object)queryWithFormat);
        }
        try {
            return (ClickHouseResponse)((CompletableFuture)this.sendRequest(request).thenApply(ClickHouseClient.convert(clazz))).get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error("select error: [{}][{}] - [{}]", new Object[]{this.endpoint, queryWithFormat, e.getMessage()});
            return null;
        }
    }

    public CompletableFuture<Void> insert(String sql, List<Object[]> rows) {
        String queryWithFormat = sql + " FORMAT " + INSERT_FORMAT;
        String tabSeparatedRows = ClickHouseClient.tabSeparatedString(rows);
        Request request = ((BoundRequestBuilder)((BoundRequestBuilder)this.asyncHttpClient.preparePost(this.endpoint).addQueryParam("query", queryWithFormat)).setBody(tabSeparatedRows)).build();
        if (log.isDebugEnabled()) {
            log.debug("insert[{}][{}]", (Object)queryWithFormat, (Object)tabSeparatedRows);
        }
        try {
            return this.sendRequest(request).thenApply(rs -> null);
        }
        catch (Exception e) {
            log.error("insert error: [{}][{}][{}] - [{}]", new Object[]{this.endpoint, queryWithFormat, tabSeparatedRows, e.getMessage()});
            return null;
        }
    }

    public boolean insert(String sql, List<Object[]> rows, long timeout) {
        String queryWithFormat = sql + " FORMAT " + INSERT_FORMAT;
        String tabSeparatedRows = ClickHouseClient.tabSeparatedString(rows);
        Request request = ((BoundRequestBuilder)((BoundRequestBuilder)this.asyncHttpClient.preparePost(this.endpoint).addQueryParam("query", queryWithFormat)).setBody(tabSeparatedRows)).build();
        if (log.isDebugEnabled()) {
            log.debug("insert[{}][{}]", (Object)queryWithFormat, (Object)tabSeparatedRows);
        }
        try {
            ((CompletableFuture)this.sendRequest(request).thenApply(rs -> null)).get(timeout, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (Exception e) {
            log.error("insert error: [{}][{}][{}] - [{}]", new Object[]{this.endpoint, queryWithFormat, tabSeparatedRows, e.getMessage()});
            return false;
        }
    }

    public CompletableFuture<String> healthcheck() {
        return this.sendRequest(this.asyncHttpClient.prepareGet(this.endpoint).build());
    }

    private CompletableFuture<String> sendRequest(Request request) {
        return this.asyncHttpClient.executeRequest(request).toCompletableFuture().handle((response, t) -> {
            if (t != null) {
                throw new RuntimeException("sendRequest error: [" + t.getMessage() + "]", (Throwable)t);
            }
            int statusCode = response.getStatusCode();
            String body = response.getResponseBody();
            if (statusCode != 200) {
                throw new RuntimeException("sendRequest error: [" + statusCode + "][" + body + "]");
            }
            return body;
        });
    }

    private static String tabSeparatedString(List<Object[]> data) {
        return data.stream().map(row -> Arrays.stream(row).map(col -> col.toString()).collect(Collectors.joining("\t"))).collect(Collectors.joining("\n"));
    }

    private static String decodedUrl(Request request) {
        String url = request.getUrl();
        try {
            return URLDecoder.decode(url, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    private static Type getType(final Class<?> rawClass, final Class<?> parameter) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{parameter};
            }

            @Override
            public Type getRawType() {
                return rawClass;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    public static <T> Function<String, ClickHouseResponse<T>> convert(Class<T> clazz) {
        return res -> (ClickHouseResponse)GSON.fromJson(res, ClickHouseClient.getType(ClickHouseResponse.class, clazz));
    }
}

