/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hippo.base.ipb;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.transsion.hippo.base.ipb.Region;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.ipv6.IPv6Address;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpbDatabase {
    private static final Logger log = LoggerFactory.getLogger(IpbDatabase.class);
    private static final char COMMA = ',';
    private static final char DOT = '.';
    private static final int MAXSIZE_BASE_DEFAULT = 1000000;
    private static final int MAXSIZE_BASE_V6_DEFAULT = 1000000;
    private static final int MAXSIZE_REGION_DEFAULT = 10000;
    private static final int MAXSIZE_BLACK_DEFAULT = 10000000;
    private static final int EXPIRE_SECONDS_BASE_DEFAULT = 3600;
    private static final int EXPIRE_SECONDS_BASE_V6_DEFAULT = 3600;
    private int maxSizeBase = 1000000;
    private int maxSizeBaseV6 = 1000000;
    private int maxSizeRegion = 10000;
    private int maxSizeBlack = 10000000;
    private int expireSecondsBase = 3600;
    private int expireSecondsBaseV6 = 3600;
    private boolean enableBaseCache = false;
    private boolean enableBaseV6Cache = false;
    private boolean enableIpV6 = false;
    private String base;
    private String baseV6;
    private String region;
    private String black;
    private RangeMap<Long, String> baseMap;
    private RangeMap<BigInteger, String> baseV6Map;
    private LoadingCache<String, Region> baseCache;
    private LoadingCache<String, Region> baseV6Cache;
    private Cache<String, Region> regionCache;
    private Cache<String, Boolean> blackCache;
    private volatile boolean inited = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() {
        String[] split;
        String line;
        BufferedReader br = null;
        this.baseMap = TreeRangeMap.create();
        if (StringUtils.isNotBlank((CharSequence)this.base)) {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.base), "UTF-8"));
            line = br.readLine();
            if (line != null) {
                if (line.startsWith("\ufeff")) {
                    line = line.replace("\ufeff", "");
                }
                do {
                    if ((split = StringUtils.split((String)line, (char)',')) == null || split.length != 3) continue;
                    this.baseMap.put(Range.closed((Comparable)Long.valueOf(IpbDatabase.inetAton(split[0])), (Comparable)Long.valueOf(IpbDatabase.inetAton(split[1]))), (Object)split[2]);
                } while ((line = br.readLine()) != null);
            }
            br.close();
            br = null;
        }
        if (this.enableBaseCache) {
            this.baseCache = Caffeine.newBuilder().maximumSize((long)this.maxSizeBase).expireAfterAccess((long)this.expireSecondsBase, TimeUnit.SECONDS).recordStats().build(ip -> this.internalFind((String)ip));
        }
        if (this.enableIpV6) {
            this.baseV6Map = TreeRangeMap.create();
            if (StringUtils.isNotBlank((CharSequence)this.baseV6)) {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.baseV6), "UTF-8"));
                line = br.readLine();
                if (line != null) {
                    if (line.startsWith("\ufeff")) {
                        line = line.replace("\ufeff", "");
                    }
                    do {
                        if ((split = StringUtils.split((String)line, (char)',')) == null || split.length != 3) continue;
                        this.baseV6Map.put(Range.closed((Comparable)IpbDatabase.inetAtonV6(split[0]), (Comparable)IpbDatabase.inetAtonV6(split[1])), (Object)split[2]);
                    } while ((line = br.readLine()) != null);
                }
                br.close();
                br = null;
            }
            if (this.enableBaseV6Cache) {
                this.baseV6Cache = Caffeine.newBuilder().maximumSize((long)this.maxSizeBaseV6).expireAfterAccess((long)this.expireSecondsBaseV6, TimeUnit.SECONDS).recordStats().build(ipV6 -> this.internalFindV6((String)ipV6));
            }
        }
        this.regionCache = Caffeine.newBuilder().maximumSize((long)this.maxSizeRegion).recordStats().build();
        if (StringUtils.isNotBlank((CharSequence)this.region)) {
            br = new BufferedReader(new FileReader(this.region));
            line = br.readLine();
            if (line != null) {
                if (line.startsWith("\ufeff")) {
                    line = line.replace("\ufeff", "");
                }
                do {
                    if ((split = StringUtils.split((String)line, (char)',')) == null || split.length != 3) continue;
                    if (split[2].endsWith("\u7701") || split[2].endsWith("\u81ea\u6cbb\u533a")) {
                        this.regionCache.put((Object)split[0], (Object)new Region(split[0], split[1], split[2], 3));
                        continue;
                    }
                    if (split[2].endsWith("\u4e2d\u56fd") || split[2].endsWith("\u4e2d\u56fd\u5927\u9646")) {
                        this.regionCache.put((Object)split[0], (Object)new Region(split[0], split[1], split[2], 2));
                        continue;
                    }
                    if (split[2].endsWith("\u5168\u7403")) {
                        this.regionCache.put((Object)split[0], (Object)new Region(split[0], split[1], split[2], 1));
                        continue;
                    }
                    if (!split[2].endsWith("NULL")) continue;
                    this.regionCache.put((Object)split[0], (Object)new Region(split[0], split[1], split[2], 0));
                } while ((line = br.readLine()) != null);
            }
            br.close();
            br = null;
        }
        this.blackCache = Caffeine.newBuilder().maximumSize((long)this.maxSizeBlack).recordStats().build();
        if (StringUtils.isNotBlank((CharSequence)this.black)) {
            br = new BufferedReader(new FileReader(this.black));
            line = br.readLine();
            if (line != null) {
                if (line.startsWith("\ufeff")) {
                    line = line.replace("\ufeff", "");
                }
                do {
                    this.blackCache.put((Object)line, (Object)true);
                } while ((line = br.readLine()) != null);
            }
            br.close();
            br = null;
        }
        this.inited = true;
        if (log.isInfoEnabled()) {
            log.info("Ipb Database inited!");
        }
        if (br == null) return;
        try {
            br.close();
            return;
        }
        catch (IOException line2) {
            return;
        }
        finally {
            br = null;
        }
        catch (Exception e) {
            try {
                log.error("Ipb Database init error: [{}]", (Object)e.getMessage(), (Object)e);
                if (br == null) return;
            }
            catch (Throwable throwable) {
                if (br == null) throw throwable;
                try {
                    br.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw throwable;
                }
                finally {
                    br = null;
                }
            }
            try {
                br.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
            finally {
                br = null;
            }
        }
    }

    public void close() {
        if (this.blackCache != null) {
            this.blackCache.invalidateAll();
            this.blackCache = null;
        }
        if (this.regionCache != null) {
            this.regionCache.invalidateAll();
            this.regionCache = null;
        }
        if (this.enableIpV6) {
            if (this.enableBaseV6Cache && this.baseV6Cache != null) {
                this.baseV6Cache.invalidateAll();
                this.baseV6Cache = null;
            }
            if (this.baseV6Map != null) {
                this.baseV6Map.clear();
                this.baseV6Map = null;
            }
        }
        if (this.enableBaseCache && this.baseCache != null) {
            this.baseCache.invalidateAll();
            this.baseCache = null;
        }
        if (this.baseMap != null) {
            this.baseMap.clear();
            this.baseMap = null;
        }
        this.inited = false;
        if (log.isInfoEnabled()) {
            log.info("Ipb Database closed!");
        }
    }

    private Region internalFind(String ip) {
        try {
            String code = (String)this.baseMap.get((Comparable)Long.valueOf(IpbDatabase.inetAton(ip)));
            if (StringUtils.isNotBlank((CharSequence)code)) {
                return (Region)this.regionCache.getIfPresent((Object)code);
            }
        }
        catch (Exception e) {
            log.error("Ipb Database find error: [{}] - [{}]", (Object)ip, (Object)e.getMessage());
        }
        return null;
    }

    private Region internalFindV6(String ipV6) {
        try {
            String code = (String)this.baseV6Map.get((Comparable)IpbDatabase.inetAtonV6(ipV6));
            if (StringUtils.isNotBlank((CharSequence)code)) {
                return (Region)this.regionCache.getIfPresent((Object)code);
            }
        }
        catch (Exception e) {
            log.error("Ipb Database findV6 error: [{}] - [{}]", (Object)ipV6, (Object)e.getMessage());
        }
        return null;
    }

    public Region find(String ip) {
        if (this.enableIpV6 && IpbDatabase.isIpV6(ip)) {
            if (this.enableBaseV6Cache) {
                return (Region)this.baseV6Cache.get((Object)ip);
            }
            return this.internalFindV6(ip);
        }
        if (this.enableBaseCache) {
            return (Region)this.baseCache.get((Object)ip);
        }
        return this.internalFind(ip);
    }

    public boolean inBlack(String ip) {
        return this.blackCache.getIfPresent((Object)ip) != null;
    }

    public String baseCacheStats() {
        if (this.enableBaseCache) {
            return this.baseCache.stats().toString();
        }
        return null;
    }

    public String baseV6CacheStats() {
        if (this.enableIpV6 && this.enableBaseV6Cache) {
            return this.baseV6Cache.stats().toString();
        }
        return null;
    }

    public static long inetAton(String add) {
        String[] segments = StringUtils.split((String)add, (char)'.');
        return Long.parseLong(segments[0]) * 0x1000000L + Long.parseLong(segments[1]) * 65536L + Long.parseLong(segments[2]) * 256L + Long.parseLong(segments[3]);
    }

    public static String inetNtoa(long add) {
        return "" + ((add & 0xFFFFFFFFFF000000L) >> 24) + '.' + ((add & 0xFF0000L) >> 16) + '.' + ((add & 0xFF00L) >> 8) + '.' + (add & 0xFFL);
    }

    public static BigInteger inetAtonV6(String add) {
        return new IPAddressString(add).getAddress().getValue();
    }

    public static String inetNtoaV6(BigInteger add) {
        return new IPv6Address(add).toNormalizedString();
    }

    public static boolean isIpV6(String ip) {
        return new IPAddressString(ip).isIPv6();
    }

    public int getMaxSizeBase() {
        return this.maxSizeBase;
    }

    public void setMaxSizeBase(int maxSizeBase) {
        this.maxSizeBase = maxSizeBase;
    }

    public int getMaxSizeBaseV6() {
        return this.maxSizeBaseV6;
    }

    public void setMaxSizeBaseV6(int maxSizeBaseV6) {
        this.maxSizeBaseV6 = maxSizeBaseV6;
    }

    public int getMaxSizeRegion() {
        return this.maxSizeRegion;
    }

    public void setMaxSizeRegion(int maxSizeRegion) {
        this.maxSizeRegion = maxSizeRegion;
    }

    public int getMaxSizeBlack() {
        return this.maxSizeBlack;
    }

    public void setMaxSizeBlack(int maxSizeBlack) {
        this.maxSizeBlack = maxSizeBlack;
    }

    public int getExpireSecondsBase() {
        return this.expireSecondsBase;
    }

    public void setExpireSecondsBase(int expireSecondsBase) {
        this.expireSecondsBase = expireSecondsBase;
    }

    public int getExpireSecondsBaseV6() {
        return this.expireSecondsBaseV6;
    }

    public void setExpireSecondsBaseV6(int expireSecondsBaseV6) {
        this.expireSecondsBaseV6 = expireSecondsBaseV6;
    }

    public boolean isEnableBaseCache() {
        return this.enableBaseCache;
    }

    public void setEnableBaseCache(boolean enableBaseCache) {
        this.enableBaseCache = enableBaseCache;
    }

    public boolean isEnableBaseV6Cache() {
        return this.enableBaseV6Cache;
    }

    public void setEnableBaseV6Cache(boolean enableBaseV6Cache) {
        this.enableBaseV6Cache = enableBaseV6Cache;
    }

    public boolean isEnableIpV6() {
        return this.enableIpV6;
    }

    public void setEnableIpV6(boolean enableIpV6) {
        this.enableIpV6 = enableIpV6;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getBaseV6() {
        return this.baseV6;
    }

    public void setBaseV6(String baseV6) {
        this.baseV6 = baseV6;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getBlack() {
        return this.black;
    }

    public void setBlack(String black) {
        this.black = black;
    }
}

