/*
 * Decompiled with CFR 0.152.
 */
package com.zero.common.toolbox;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.LruCache;
import com.transsion.core.CoreUtil;
import com.transsion.http.util.MD5;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.toolbox.interfacez.ResponseListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.mediation.c.b.b;
import com.zero.mediation.util.a;
import com.zero.ta.common.bean.AdImage;
import com.zero.ta.common.constant.ComConstant;
import com.zero.ta.common.gif.DefaultImageHeaderParser;
import com.zero.ta.common.gif.ImageHeaderParser;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

public class AdImageLoadHelper {
    private static final String TAG = "AdImageLoadHelper";
    private static AdImageLoadHelper loader;
    private static LruCache<String, WeakReference<AdImage>> cache;
    private ReferenceQueue<AdImage> queue;
    private static final int MB = 0x100000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdImageLoadHelper with() {
        if (loader != null) return loader;
        Class<AdImageLoadHelper> clazz = AdImageLoadHelper.class;
        synchronized (AdImageLoadHelper.class) {
            if (loader != null) return loader;
            loader = new AdImageLoadHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return loader;
        }
    }

    private AdImageLoadHelper() {
        long l = Runtime.getRuntime().maxMemory() / 8L;
        int n = Math.min(Math.max(0x1400000, (int)l), 0xC800000);
        cache = new LruCache<String, WeakReference<AdImage>>(n){

            protected int sizeOf(String string, WeakReference<AdImage> weakReference) {
                if (weakReference.get() != null) {
                    ((AdImage)weakReference.get()).getByteSize();
                }
                return super.size();
            }
        };
        this.queue = new ReferenceQueue();
    }

    public void loadImage(@NonNull String string, ResponseListener responseListener) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.dispatchResult("", null, responseListener);
            return;
        }
        String string2 = MD5.MD5Encode((String)string);
        WeakReference weakReference = (WeakReference)cache.get((Object)string2);
        if (weakReference != null && weakReference.get() != null && ((AdImage)weakReference.get()).isRecycled()) {
            this.dispatchResult(null, (AdImage)weakReference.get(), responseListener);
        } else {
            this.downloadBitmap(string2, string, responseListener);
        }
    }

    private void downloadBitmap(final String string, String string2, final ResponseListener responseListener) {
        b b2 = new b().a(new com.zero.mediation.c.a.b(){

            @Override
            protected void onRequestError(TAdErrorCode tAdErrorCode) {
                AdLogUtil.Log().e(AdImageLoadHelper.TAG, "download fail code:" + tAdErrorCode.toString());
                AdImageLoadHelper.this.dispatchResult(string, null, responseListener);
            }

            @Override
            public void onServerRequestSuccess(int n, byte[] byArray, String string2) {
                try {
                    DefaultImageHeaderParser defaultImageHeaderParser = new DefaultImageHeaderParser();
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                    ImageHeaderParser.ImageType imageType = defaultImageHeaderParser.getType(byteBuffer);
                    Bitmap bitmap = null;
                    boolean bl = false;
                    if (imageType != ImageHeaderParser.ImageType.GIF || !ComConstant.isGlideExisted) {
                        bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                    } else if (imageType == ImageHeaderParser.ImageType.GIF) {
                        bl = true;
                        AdLogUtil.Log().d(AdImageLoadHelper.TAG, "Image type is gif");
                    }
                    Drawable drawable = bitmap == null ? null : AdImageLoadHelper.this.transform(bitmap);
                    AdImage adImage = new AdImage(drawable, (byte[])(bl ? byArray : null), string2);
                    AdImageLoadHelper.this.dispatchResult(string, adImage, responseListener);
                }
                catch (Throwable throwable) {
                    AdImageLoadHelper.this.dispatchResult(string, null, responseListener);
                }
            }
        }).c(string2);
        b2.netRequestPreExecute();
    }

    private void dispatchResult(final String string, final AdImage adImage, final ResponseListener responseListener) {
        a.a(new Runnable(){

            @Override
            public void run() {
                if (adImage == null) {
                    if (responseListener != null) {
                        responseListener.onFail();
                    }
                    return;
                }
                if (!adImage.isRecycled() && !TextUtils.isEmpty((CharSequence)string)) {
                    cache.put((Object)string, new WeakReference<AdImage>(adImage, AdImageLoadHelper.this.queue));
                }
                if (responseListener != null) {
                    if (adImage.isRecycled()) {
                        responseListener.onFail();
                    } else {
                        responseListener.onSuccess(adImage);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Drawable transform(@NonNull Bitmap bitmap) {
        BitmapDrawable bitmapDrawable = null;
        if (bitmap == null) {
            return null;
        }
        try {
            bitmapDrawable = new BitmapDrawable(CoreUtil.getContext().getResources(), bitmap);
            return bitmapDrawable;
        }
        catch (Throwable throwable) {
            AdLogUtil.Log().e(TAG, "transform bitmap to drawable exception");
        }
        finally {
            return bitmapDrawable;
        }
    }
}

