/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.ad.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.zero.common.base.BaseNativeViewHolder;
import com.zero.common.bean.NativeVideoParam;
import com.zero.common.bean.TAdNativeInfo;
import com.zero.common.utils.AdLogUtil;
import com.zero.mediation.R;
import com.zero.ta.api.view.MediaView;
import com.zero.ta.common.bean.AdImage;

public class TMediaView
extends FrameLayout {
    private static final ImageView.ScaleType[] S = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};
    private ImageView.ScaleType T = ImageView.ScaleType.FIT_CENTER;

    public TMediaView(@NonNull Context context) {
        this(context, null);
    }

    public TMediaView(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TMediaView(@NonNull Context context, @Nullable AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TMediaView, n, 0);
        int n2 = typedArray.getInt(R.styleable.TMediaView_sspScaleType, 3);
        if (n2 >= 0 && n2 < S.length) {
            this.T = S[n2];
        }
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        this.T = scaleType;
    }

    public void attachLayout(@NonNull BaseNativeViewHolder baseNativeViewHolder, TAdNativeInfo tAdNativeInfo, NativeVideoParam nativeVideoParam) {
        this.removeAllViews();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        View view = baseNativeViewHolder.getMediaView(this.getContext(), tAdNativeInfo, nativeVideoParam);
        layoutParams.gravity = 17;
        if (view != null) {
            this.addView(view, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void setMediaView(AdImage adImage) {
        View view = this.getMediaView();
        if (view == null) {
            AdLogUtil.Log().e("TMediaView", "childView is null");
            return;
        }
        if (view instanceof MediaView) {
            ((MediaView)view).setMediaView(adImage, this.T);
        }
    }

    void a(View view) {
        this.removeAllViews();
        if (view.getParent() != null) {
            ((ViewGroup)view.getParent()).removeView(view);
        }
        this.addView(view);
    }

    public View getMediaView() {
        View view = this.getChildAt(0);
        return view;
    }
}

