/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.iot.communication;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.transsion.iot.communication.ConnectListener;
import com.transsion.iot.communication.MeshSearchListener;
import com.transsion.iot.communication.MessageReceiveListener;
import com.transsion.iot.communication.packet.RequestData;
import com.transsion.iot.communication.packet.ResponseData;
import com.transsion.iot.communication.packet.req.AdminPassword;
import com.transsion.iot.communication.packet.req.BaseParam;
import com.transsion.iot.communication.packet.req.DisableDeviceParam;
import com.transsion.iot.communication.packet.req.GetSupportBandwidthParam;
import com.transsion.iot.communication.packet.req.GetSupportChannelParam;
import com.transsion.iot.communication.packet.req.MeshSearchState;
import com.transsion.iot.communication.packet.req.SendWIFIMeshParam;
import com.transsion.iot.communication.packet.req.SetBandWidthParam;
import com.transsion.iot.communication.packet.req.SetChannelParam;
import com.transsion.iot.communication.packet.req.SetPasswordParam;
import com.transsion.iot.communication.packet.req.SetSSIDParam;
import com.transsion.iot.communication.packet.req.SetSignalPowerParam;
import com.transsion.iot.communication.packet.req.SetVisibleParam;
import com.transsion.iot.communication.packet.req.SetWIFICombineParam;
import com.transsion.iot.communication.packet.req.SetWIFIStateParam;
import com.transsion.iot.communication.packet.req.SwitchStateParam;
import com.transsion.iot.communication.packet.resp.BaseResult;
import com.transsion.iot.communication.packet.resp.ConnectedDeviceList;
import com.transsion.iot.communication.packet.resp.DeviceBasicInfo;
import com.transsion.iot.communication.packet.resp.MeshedNodes;
import com.transsion.iot.communication.packet.resp.NetworkSettings;
import com.transsion.iot.communication.packet.resp.NetworkSpeedInfo;
import com.transsion.iot.communication.packet.resp.OnlineDeviceCount;
import com.transsion.iot.communication.packet.resp.SearchedMeshNodes;
import com.transsion.iot.communication.packet.resp.SupportBandwidthList;
import com.transsion.iot.communication.packet.resp.SupportChannelList;
import com.transsion.iot.communication.tcp.TCPClient;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0018\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u000f\u001a\u00020\bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u0011\u001a\u00020\u000bJ\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J%\u0010\u0016\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J%\u0010\u0016\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u0004\u0018\u00010 J\b\u0010!\u001a\u0004\u0018\u00010\"J\b\u0010#\u001a\u0004\u0018\u00010$J\b\u0010%\u001a\u0004\u0018\u00010&J\u0010\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u000bJ\u0018\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u0004J\b\u0010-\u001a\u0004\u0018\u00010.J\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u0004\u0018\u00010\rJ\u0010\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\u0004H\u0016J\u0010\u00104\u001a\u0004\u0018\u00010\r2\u0006\u00105\u001a\u00020\u0004J\b\u00106\u001a\u0004\u0018\u00010\rJ\b\u00107\u001a\u0004\u0018\u00010\rJ\u0012\u00108\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u00108\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u00109\u001a\u0004\u0018\u00010\r2\u0006\u0010:\u001a\u00020\u0004J\u000e\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020=J\u0018\u0010>\u001a\u0004\u0018\u00010\r2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020\u0004J\u0018\u0010@\u001a\u0004\u0018\u00010\r2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\u000bJ\u0018\u0010B\u001a\u0004\u0018\u00010\r2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010C\u001a\u00020\u000bJ\u0010\u0010D\u001a\u0004\u0018\u00010\r2\u0006\u0010E\u001a\u00020\u000bJ\u000e\u0010F\u001a\u00020\b2\u0006\u0010<\u001a\u00020\u0006J\u0018\u0010G\u001a\u0004\u0018\u00010\r2\u0006\u0010)\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u0004J\u0018\u0010H\u001a\u0004\u0018\u00010\r2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020\u0004J\u0010\u0010I\u001a\u0004\u0018\u00010\r2\u0006\u0010E\u001a\u00020\u000bJ(\u0010J\u001a\u0004\u0018\u00010\r2\u0006\u0010K\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u0004J\u0018\u0010O\u001a\u0004\u0018\u00010\r2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010P\u001a\u00020\u000bJ\u0018\u0010Q\u001a\u0004\u0018\u00010\r2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010R\u001a\u00020\u000bJ\u0010\u0010S\u001a\u0004\u0018\u00010\r2\u0006\u0010T\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/transsion/iot/communication/WIFIClient;", "Lcom/transsion/iot/communication/MessageReceiveListener;", "()V", "TAG", "", "mMeshSearchListener", "Lcom/transsion/iot/communication/MeshSearchListener;", "connect", "", "ip", "port", "", "disableDevice", "Lcom/transsion/iot/communication/packet/resp/BaseResult;", "deviceMac", "disconnect", "enableDevice", "getConnectState", "getConnectedDeviceList", "Lcom/transsion/iot/communication/packet/resp/ConnectedDeviceList;", "getCurDeviceNetworkSpeedInfo", "Lcom/transsion/iot/communication/packet/resp/NetworkSpeedInfo;", "getData", "obj", "Lcom/transsion/iot/communication/packet/RequestData;", "T", "type", "Ljava/lang/reflect/Type;", "(Lcom/transsion/iot/communication/packet/RequestData;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "serviceId", "(Ljava/lang/String;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "getDeviceBasicInfo", "Lcom/transsion/iot/communication/packet/resp/DeviceBasicInfo;", "getNetworkSettings", "Lcom/transsion/iot/communication/packet/resp/NetworkSettings;", "getOnlineDeviceCount", "Lcom/transsion/iot/communication/packet/resp/OnlineDeviceCount;", "getSearchedMeshNodes", "Lcom/transsion/iot/communication/packet/resp/SearchedMeshNodes;", "getSupportBandWidthList", "Lcom/transsion/iot/communication/packet/resp/SupportBandwidthList;", "frequency", "getSupportChannelList", "Lcom/transsion/iot/communication/packet/resp/SupportChannelList;", "countryCode", "getWIFIMeshInfo", "Lcom/transsion/iot/communication/packet/resp/MeshedNodes;", "isConnected", "", "networkOptimization", "onMessageReceived", "msg", "passwordAuthentication", "password", "rebootDevice", "resetFactory", "sendData", "sendWIFIMesh", "ssid", "setConnectListener", "listener", "Lcom/transsion/iot/communication/ConnectListener;", "setCurBandwidth", "bandWidth", "setCurChannel", "channel", "setCurSignalPower", "signalPower", "setHwNATState", "state", "setMeshSearchListener", "setPassword", "setSSID", "setWIFI5State", "setWIFICombineState", "wifiCombineMode", "wifiCombineRfOnOff", "wifiXGSsid", "wifiXGPasswd", "setWIFIState", "workMode", "setWIFIVisibility", "visible", "startOrStopMeshSearch", "mode", "communication_release"})
public final class WIFIClient
implements MessageReceiveListener {
    @NotNull
    private final String TAG;
    private MeshSearchListener mMeshSearchListener;

    public WIFIClient() {
        this.TAG = "WIFIClient";
    }

    public final int getConnectState() {
        return TCPClient.INSTANCE.getConnectState();
    }

    public final boolean isConnected() {
        return TCPClient.INSTANCE.isConnected();
    }

    public final void setConnectListener(@NotNull ConnectListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        TCPClient.INSTANCE.setOnConnectListener(listener);
    }

    public final void setMeshSearchListener(@NotNull MeshSearchListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.mMeshSearchListener = listener;
    }

    public final void connect(@NotNull String ip, int port) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        TCPClient.INSTANCE.setMessageReceiveListener(this);
        TCPClient.INSTANCE.setIP(ip);
        TCPClient.INSTANCE.setPort(port);
        TCPClient.INSTANCE.connect();
    }

    public final void connect() {
        TCPClient.INSTANCE.setMessageReceiveListener(this);
        TCPClient.INSTANCE.connect();
    }

    /*
     * WARNING - void declaration
     */
    private final String sendData(RequestData obj) {
        String string;
        if (!this.isConnected()) {
            Log.d((String)this.TAG, (String)"sendData not connected");
            string = "";
        } else {
            void var3_3;
            Log.d((String)this.TAG, (String)Intrinsics.stringPlus((String)"sendData obj=", (Object)obj));
            String jsonStr = new Gson().toJson((Object)obj, (Type)((Object)RequestData.class));
            Log.d((String)this.TAG, (String)Intrinsics.stringPlus((String)"sendData jsonStr=", (Object)jsonStr));
            String string2 = obj.getServiceId();
            Intrinsics.checkNotNullExpressionValue((Object)jsonStr, (String)"jsonStr");
            String resultStr = TCPClient.INSTANCE.send(string2, jsonStr);
            Log.d((String)this.TAG, (String)Intrinsics.stringPlus((String)"sendData resultStr=", (Object)resultStr));
            string = var3_3;
        }
        return string;
    }

    private final String sendData(String serviceId) {
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new BaseParam(), serviceId, null, 18, null);
        String responseStr = this.sendData(requestData);
        Log.d((String)this.TAG, (String)Intrinsics.stringPlus((String)"sendData responseStr=", (Object)responseStr));
        return responseStr;
    }

    public final void disconnect() {
        TCPClient.INSTANCE.disconnect();
    }

    private final <T> T getData(String serviceId, Type type2) {
        String responseStr = this.sendData(serviceId);
        ResponseData response = (ResponseData)new Gson().fromJson(responseStr, type2);
        if (response != null && response.getCode() == 200) {
            return response.getData();
        }
        return null;
    }

    private final <T> T getData(RequestData obj, Type type2) {
        String responseStr = this.sendData(obj);
        ResponseData response = (ResponseData)new Gson().fromJson(responseStr, type2);
        if (response != null && response.getCode() == 200) {
            return response.getData();
        }
        return null;
    }

    private final BaseResult getData(RequestData obj) {
        String responseStr = this.sendData(obj);
        Type type2 = new TypeToken<ResponseData<BaseResult>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<ResponseData<BaseResult>>(){}.type");
        Type type3 = type2;
        ResponseData response = (ResponseData)new Gson().fromJson(responseStr, type3);
        if (response != null && response.getCode() == 200) {
            return (BaseResult)response.getData();
        }
        return null;
    }

    private final BaseResult getData(String serviceId) {
        String responseStr = this.sendData(serviceId);
        Type type2 = new TypeToken<ResponseData<BaseResult>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<ResponseData<BaseResult>>(){}.type");
        Type type3 = type2;
        ResponseData response = (ResponseData)new Gson().fromJson(responseStr, type3);
        if (response != null && response.getCode() == 200) {
            return (BaseResult)response.getData();
        }
        return null;
    }

    @Nullable
    public final NetworkSpeedInfo getCurDeviceNetworkSpeedInfo() {
        Type type2 = new TypeToken<ResponseData<NetworkSpeedInfo>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<ResponseData<NetworkSpeedInfo>>(){}.type");
        Type type3 = type2;
        return (NetworkSpeedInfo)this.getData("getCurDeviceNetworkSpeedInfo", type3);
    }

    @Nullable
    public final OnlineDeviceCount getOnlineDeviceCount() {
        Type type2 = new TypeToken<ResponseData<OnlineDeviceCount>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<ResponseData<OnlineDeviceCount>>(){}.type");
        Type type3 = type2;
        return (OnlineDeviceCount)this.getData("getOnlineDeviceCount", type3);
    }

    @Nullable
    public final DeviceBasicInfo getDeviceBasicInfo() {
        Type type2 = new TypeToken<ResponseData<DeviceBasicInfo>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<ResponseData<DeviceBasicInfo>>(){}.type");
        Type type3 = type2;
        return (DeviceBasicInfo)this.getData("getDeviceBasicInfo", type3);
    }

    @Nullable
    public final ConnectedDeviceList getConnectedDeviceList() {
        Type type2 = new TypeToken<ResponseData<ConnectedDeviceList>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<ResponseData<ConnectedDeviceList>>(){}.type");
        Type type3 = type2;
        return (ConnectedDeviceList)this.getData("getConnectedDeviceList", type3);
    }

    @Nullable
    public final BaseResult disableDevice(@NotNull String deviceMac) {
        Intrinsics.checkNotNullParameter((Object)deviceMac, (String)"deviceMac");
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new DisableDeviceParam(deviceMac), "disableDevice", null, 18, null);
        return this.getData(requestData);
    }

    @Nullable
    public final BaseResult enableDevice(@NotNull String deviceMac) {
        Intrinsics.checkNotNullParameter((Object)deviceMac, (String)"deviceMac");
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new DisableDeviceParam(deviceMac), "enableDevice", null, 18, null);
        return this.getData(requestData);
    }

    @Nullable
    public final NetworkSettings getNetworkSettings() {
        Type type2 = new TypeToken<ResponseData<NetworkSettings>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<ResponseData<NetworkSettings>>(){}.type");
        Type type3 = type2;
        return (NetworkSettings)this.getData("getNetworkSettings", type3);
    }

    @Nullable
    public final BaseResult setSSID(int frequency, @NotNull String ssid) {
        Intrinsics.checkNotNullParameter((Object)ssid, (String)"ssid");
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new SetSSIDParam(frequency, ssid), "setSSID", null, 18, null);
        return this.getData(requestData);
    }

    @Nullable
    public final BaseResult setPassword(int frequency, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new SetPasswordParam(frequency, password), "setPassword", null, 18, null);
        return this.getData(requestData);
    }

    @Nullable
    public final BaseResult setWIFIVisibility(int frequency, int visible) {
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new SetVisibleParam(frequency, visible), "setWIFIVisibility", null, 18, null);
        return this.getData(requestData);
    }

    @Nullable
    public final BaseResult setWIFIState(int frequency, int workMode) {
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new SetWIFIStateParam(frequency, workMode), "setWIFIState", null, 18, null);
        return this.getData(requestData);
    }

    @Nullable
    public final BaseResult setWIFICombineState(int wifiCombineMode, int wifiCombineRfOnOff, @NotNull String wifiXGSsid, @NotNull String wifiXGPasswd) {
        Intrinsics.checkNotNullParameter((Object)wifiXGSsid, (String)"wifiXGSsid");
        Intrinsics.checkNotNullParameter((Object)wifiXGPasswd, (String)"wifiXGPasswd");
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new SetWIFICombineParam(wifiCombineMode, wifiCombineRfOnOff, wifiXGSsid, wifiXGPasswd), "setWIFICombineState", null, 18, null);
        return this.getData(requestData);
    }

    @Nullable
    public final SupportChannelList getSupportChannelList(int frequency, @NotNull String countryCode) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new GetSupportChannelParam(frequency, countryCode), "getSupportChannelList", null, 18, null);
        Type type2 = new TypeToken<ResponseData<SupportChannelList>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<ResponseData<SupportChannelList>>(){}.type");
        Type type3 = type2;
        return (SupportChannelList)this.getData(requestData, type3);
    }

    @Nullable
    public final SupportBandwidthList getSupportBandWidthList(int frequency) {
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new GetSupportBandwidthParam(frequency), "getSupportBandWidthList", null, 18, null);
        Type type2 = new TypeToken<ResponseData<SupportBandwidthList>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<ResponseData<SupportBandwidthList>>(){}.type");
        Type type3 = type2;
        return (SupportBandwidthList)this.getData(requestData, type3);
    }

    @Nullable
    public final BaseResult setWIFI5State(int state) {
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new SwitchStateParam(state), "setWIFI5State", null, 18, null);
        return this.getData(requestData);
    }

    @Nullable
    public final BaseResult setHwNATState(int state) {
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new SwitchStateParam(state), "setHwNATState", null, 18, null);
        return this.getData(requestData);
    }

    @Nullable
    public final BaseResult setCurChannel(int frequency, int channel) {
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new SetChannelParam(frequency, channel), "setCurChannel", null, 18, null);
        return this.getData(requestData);
    }

    @Nullable
    public final BaseResult setCurSignalPower(int frequency, int signalPower) {
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new SetSignalPowerParam(frequency, signalPower), "setCurSignalPower", null, 18, null);
        return this.getData(requestData);
    }

    @Nullable
    public final BaseResult setCurBandwidth(int frequency, @NotNull String bandWidth) {
        Intrinsics.checkNotNullParameter((Object)bandWidth, (String)"bandWidth");
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new SetBandWidthParam(frequency, bandWidth), "setCurBandwidth", null, 18, null);
        return this.getData(requestData);
    }

    @Nullable
    public final MeshedNodes getWIFIMeshInfo() {
        Type type2 = new TypeToken<ResponseData<MeshedNodes>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<ResponseData<MeshedNodes>>(){}.type");
        Type type3 = type2;
        return (MeshedNodes)this.getData("getWIFIMeshInfo", type3);
    }

    @Nullable
    public final SearchedMeshNodes getSearchedMeshNodes() {
        Type type2 = new TypeToken<ResponseData<SearchedMeshNodes>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<ResponseData<SearchedMeshNodes>>(){}.type");
        Type type3 = type2;
        return (SearchedMeshNodes)this.getData("getSearchedMeshNodes", type3);
    }

    @Nullable
    public final BaseResult sendWIFIMesh(@NotNull String ssid) {
        Intrinsics.checkNotNullParameter((Object)ssid, (String)"ssid");
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new SendWIFIMeshParam(ssid), "sendWIFIMesh", null, 18, null);
        return this.getData(requestData);
    }

    @Nullable
    public final BaseResult startOrStopMeshSearch(int mode) {
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new MeshSearchState(mode), "setSearchedMeshMode", null, 18, null);
        return this.getData(requestData);
    }

    @Nullable
    public final BaseResult networkOptimization() {
        return this.getData("networkOptimization");
    }

    @Nullable
    public final BaseResult resetFactory() {
        return this.getData("resetFactory");
    }

    @Nullable
    public final BaseResult rebootDevice() {
        return this.getData("rebootDevice");
    }

    @Nullable
    public final BaseResult passwordAuthentication(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        RequestData requestData = new RequestData(String.valueOf(System.currentTimeMillis()), null, new AdminPassword(password), "passwordAuthentication", null, 18, null);
        return this.getData(requestData);
    }

    @Override
    public void onMessageReceived(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Type type2 = new TypeToken<ResponseData<SearchedMeshNodes>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<ResponseData<SearchedMeshNodes>>(){}.type");
        Type type3 = type2;
        ResponseData response = (ResponseData)new Gson().fromJson(msg, type3);
        if (response != null && response.getCode() == 200) {
            MeshSearchListener meshSearchListener = this.mMeshSearchListener;
            if (meshSearchListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mMeshSearchListener");
                throw null;
            }
            meshSearchListener.onMeshInfoResolved(((SearchedMeshNodes)response.getData()).getList());
        }
    }
}

