package com.transsion.iot.communication.http

import java.nio.charset.StandardCharsets
import java.security.MessageDigest
import java.security.NoSuchAlgorithmException
import java.util.*

/*
 * Transsion Top Secret
 * Copyright (C) 2020 Transsion Inc.
 * WeLife
 * @author OS : wenbin.zhou (18647502)
 * @version 1.0
 */
object EncryptUtils {

    /**
     * 计算sig
     * */
    fun sign(dynamicMap: TreeMap<String, String?>): String? {
        val sb = StringBuilder()
        for ((key, value) in dynamicMap) {
            sb.append(key).append("=").append(value).append("&")
        }
        var signStr = sb.toString()
        if (signStr.endsWith("&")) {
            signStr = signStr.substring(0, signStr.length - 1);
        }
//        try {
//            signStr =
//                URLDecoder.decode(signStr, StandardCharsets.UTF_8.name())
//        } catch (exception: UnsupportedEncodingException) {
//            exception.printStackTrace()
//        }
        return md5(signStr)
    }

    /**
     * 将url参数转换成map
     * */
    fun getUrlParams(param: String?): TreeMap<String, String?> {
        val map = TreeMap<String, String?>()
        param?.let {
            val params = it.split("&").toTypedArray()
            for (i in params.indices) {
                val p = params[i].split("=").toTypedArray()
                if (p.size == 2) {
                    map[p[0]] = p[1]
                }
            }
        }
        return map
    }


    /**
     * 签名的MD5算法
     */
    fun md5(s: String): String? {
        return try {
            val md5 = MessageDigest.getInstance("MD5")
            md5.update(s.toByteArray(StandardCharsets.UTF_8))
            val encryption = md5.digest()
            val strBuf = StringBuffer()
            for (i in encryption.indices) {
                if (Integer.toHexString(0xff and encryption[i].toInt()).length == 1) {
                    strBuf.append("0").append(
                        Integer.toHexString(0xff and encryption[i].toInt())
                    )
                } else {
                    strBuf.append(Integer.toHexString(0xff and encryption[i].toInt()))
                }
            }
            strBuf.toString()
        } catch (e: NoSuchAlgorithmException) {
            null
        }
    }

    /**
     * @Comment SHA1实现
     * @Author Ron
     * @Date 2017年9月13日 下午3:30:36
     * @return
     */
    fun sha1(inStr: String): String? {
        val sha: MessageDigest
        sha = try { MessageDigest.getInstance("SHA")
        } catch (e: NoSuchAlgorithmException) {
            e.printStackTrace()
            return null
        }
        val byteArray = inStr.toByteArray(charset("UTF-8"))
        val md5Bytes = sha.digest(byteArray)
        val hexValue = StringBuffer()
        for (i in md5Bytes.indices) {
            val `val` = md5Bytes[i].toInt() and 0xff
            if (`val` < 16) {
                hexValue.append("0")
            }
            hexValue.append(Integer.toHexString(`val`))
        }
        return hexValue.toString()
    }

}