package com.transsion.iot.communication.http

import android.annotation.SuppressLint
import android.content.Context
import android.icu.text.SimpleDateFormat
import android.os.Build
import com.transsion.core.deviceinfo.DeviceInfo
import okhttp3.Interceptor
import okhttp3.Response
import java.util.*

/*
 * Transsion Top Secret
 * Copyright (C) 2020 Transsion Inc.
 * WeLife
 * @author OS : wenbin.zhou (18647502)
 * @version 1.0
 */
class HeadInterceptor(context: Context, var token: String) : Interceptor {

    val format = SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US)
    val versionName = context.packageManager.getPackageInfo(context.packageName, 0).versionName
    @SuppressLint("SimpleDateFormat")
    override fun intercept(chain: Interceptor.Chain): Response {
        var request = chain.request()
        request = request.newBuilder()
            .header("Content-Type", "application/json")
            .header("eDevId", "1000")
            .header("transId", UUID.randomUUID().toString())
            .header("appVersion", versionName)
            .header("appName", "WELIFE")
            .header("gaid", getGaid())
            .header("brand", Build.BRAND)
            .header("deviceModel", Build.MODEL)
            .header("Authorization","Bearer $token")
            .header("Date", format.format(Date()))
            .build()
        return chain.proceed(request)
    }
}

fun getGaid(): String? {
    try {
        return DeviceInfo.getGAId()
    } catch (e: Exception) {
        return ""
    }
}