package com.transsion.iot.communication.http

import android.util.Log
import com.smartlife.nebula.librarybase.net.ResponseThrowable
import com.transsion.iot.communication.http.bean.BaseResult
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

/*
 * Transsion Top Secret
 * Copyright (C) 2020 Transsion Inc.
 * WeLife
 * @author OS : wenbin.zhou (18647502)
 * @version 1.0
 */
suspend fun <T> HttpRequest(
    block: suspend CoroutineScope.() -> BaseResult<T>,
    successCallBack: (T?) -> Unit,
    errorCallBack: (ResponseThrowable) -> Unit,
    complete: () -> Unit = {}
) {
    ExceptionHandle.handleException(
        {
            withContext(Dispatchers.IO) {
                block().let {
                    if (it.isSuccess()) {
                        successCallBack(it.ret)
                    } else {
                        Log.e("HttpRequest", "errorCallBack : flag:${it.flag}  msg : ${it.msg}")
                        errorCallBack(ResponseThrowable(it.flag, msg = it.msg))
                    }
                }
            }
        },
        {
            errorCallBack(it)
        },
        {
            complete()
        }
    )
}
