/*
 * Transsion Top Secret
 * Copyright (C) 2021 Transsion Inc.
 * Welife
 * @author OS : fuhuang.fan (18650792)
 * @version 1.0
 */

package com.transsion.iot.communication.http.api

import com.transsion.iot.communication.http.bean.BaseResult
import com.transsion.iot.communication.http.bean.BaseInfoData
import com.transsion.iot.communication.http.bean.ClientInfoData
import com.transsion.iot.communication.http.bean.WifiInfoData
import com.transsion.iot.communication.packet.resp.MeshedNodes
import okhttp3.RequestBody
import retrofit2.http.Body
import retrofit2.http.POST
import retrofit2.http.Path

/**
 * @Author fuhuang.fan
 * @Date 2022/3/30/030 19:41
 * @Description
 */
interface DeviceControlService {

    @POST("weLink/app/properties/{pid}/{psn}")
    suspend fun getBaseInfo(@Path("pid") pid: String, @Path("psn") psn: String, @Body requestBody: RequestBody): BaseResult<BaseInfoData>

    @POST("weLink/app/properties/{pid}/{psn}")
    suspend fun getWifiInfo(@Path("pid") pid: String, @Path("psn") psn: String, @Body requestBody: RequestBody): BaseResult<WifiInfoData>

    @POST("weLink/app/properties/{pid}/{psn}")
    suspend fun getMeshInfo(@Path("pid") pid: String, @Path("psn") psn: String, @Body requestBody: RequestBody): BaseResult<MeshedNodes>

    @POST("weLink/app/properties/{pid}/{psn}")
    suspend fun getClientInfo(@Path("pid") pid: String, @Path("psn") psn: String, @Body requestBody: RequestBody): BaseResult<ClientInfoData>

    @POST("weLink/app/service/{pid}/{psn}/down")
    suspend fun serviceSet(@Path("pid") pid: String, @Path("psn") psn: String, @Body requestBody: RequestBody): BaseResult<Any>

}