package com.transsion.iot.communication.http.repository

import android.content.Context
import android.util.Log
import com.transsion.iot.communication.http.HttpRequest
import com.transsion.iot.communication.http.IRetrofitClientSpi
import com.transsion.iot.communication.http.api.DeviceControlService
import com.transsion.iot.communication.http.bean.BaseInfo
import com.transsion.iot.communication.http.getRequestBody
import com.transsion.iot.communication.packet.resp.MeshNode
import com.transsion.iot.communication.packet.resp.Settings
import kotlinx.coroutines.sync.Mutex
import java.util.*

object DeviceControlRepository {

    const val TAG = "DeviceControlRepository"
    private var mClient: DeviceControlService? = null
    private val mMutex = Mutex()

    private suspend fun getDeviceControlService(context: Context, token: String): DeviceControlService {
        mMutex.lock()
        if (mClient == null) {
            val retrofit = ServiceLoader.load(IRetrofitClientSpi::class.java).first().getRetrofit(context, token)
            Log.d(TAG, "getDeviceControlService retrofit=${retrofit}")
            Log.d(TAG, "getDeviceControlService baseUrl=${retrofit.baseUrl()}")
            mClient = retrofit.create(DeviceControlService::class.java)
        }
        mMutex.unlock()
        Log.d(TAG, "getDeviceControlService client=$mClient")
        return mClient!!
    }

    suspend fun getBaseInfo(context: Context, token: String, pid: String, psn: String, result:(result:BaseInfo?)->Unit) {
        Log.d(TAG, "token=$token,pid=$pid, psn=$psn")
        HttpRequest({
            val map = TreeMap<String, Any?>()
            map["id"] = System.currentTimeMillis().toString()
            map["version"] = "1.0"
            map["params"] = arrayOf("baseInf")
            map["method"] = "app.property.get"
            Log.d(TAG, "token=$token,pid=$pid, psn=$psn, body=${map.getRequestBody()}")
            val result = getDeviceControlService(context, token).getBaseInfo(pid, psn, map.getRequestBody())
            Log.d(TAG, "result:${result}")
            result
        },{
            Log.d(TAG, "baseInfo:${it?.baseInf}")
            it?.let {
                result.invoke(it.baseInf)
            }
            if (it == null) {
                result.invoke(null)
            }
        },{
            Log.e(TAG, "error:${it.errMsg}, ${it.code}")
            result.invoke(null)
        })
    }

    suspend fun getWifiInfo(context: Context, token: String, pid: String, psn: String, result:(result:Settings?)->Unit) {
        HttpRequest({
            val map = TreeMap<String, Any?>()
            map["id"] = System.currentTimeMillis().toString()
            map["version"] = "1.0"
            map["params"] = arrayOf("wifiInfo")
            map["method"] = "app.property.get"
            getDeviceControlService(context, token).getWifiInfo(pid, psn, map.getRequestBody())
        },{
            Log.d(TAG, "wifiInfo:${it?.wifiInfo}")
            it?.let {
                result.invoke(it.wifiInfo)
            }
            if (it == null) {
                result.invoke(null)
            }
        },{
            Log.e(TAG, "error:${it.errMsg}, ${it.code}")
            result.invoke(null)
        })
    }

    suspend fun getMeshInfo(context: Context, token: String, pid: String, psn: String, result:(result:List<MeshNode>?)->Unit) {
        HttpRequest({
            val map = TreeMap<String, Any?>()
            map["id"] = System.currentTimeMillis().toString()
            map["version"] = "1.0"
            map["params"] = arrayOf("meshInf")
            map["method"] = "app.property.get"
            getDeviceControlService(context, token).getMeshInfo(pid, psn, map.getRequestBody())
        },{
            it?.let {
                result.invoke(it.list)
            }
            if (it == null) {
                result.invoke(null)
            }
        },{
            Log.e(TAG, "error:${it.errMsg}, ${it.code}")
            result.invoke(null)
        })
    }

    suspend fun getClientInfo(context: Context, token: String, pid: String, psn: String, result:(result:String?)->Unit) {
        HttpRequest({
            val map = TreeMap<String, Any?>()
            map["id"] = System.currentTimeMillis().toString()
            map["version"] = "1.0"
            map["params"] = arrayOf("clientInf")
            map["method"] = "app.property.get"
            getDeviceControlService(context, token).getClientInfo(pid, psn, map.getRequestBody())
        },{
            it?.let {
                result.invoke(it.clientInf)
            }
            if (it == null) {
                result.invoke(null)
            }
        },{
            Log.e(TAG, "error:${it.errMsg}, ${it.code}")
            result.invoke(null)
        })
    }

    suspend fun <T> serviceWrite(context: Context, token: String, pid: String, psn: String,serviceId: String , params: T, result:(result:Boolean)->Unit) {
        HttpRequest({
            val map = TreeMap<String, Any?>()
            map["id"] = System.currentTimeMillis().toString()
            map["version"] = "1.0"
            map["params"] = params
            map["method"] = "service"
            map["serviceId"] = serviceId
            Log.d(TAG, "token=$token,pid=$pid, psn=$psn, body=${map.getRequestBody()}")
            getDeviceControlService(context, token).serviceSet(pid, psn, map.getRequestBody())
        },{
            result.invoke(true)
        },{
            Log.e(TAG, "error:${it.errMsg}, ${it.code}")
            result.invoke(false)
        })
    }

}