/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.iot.communication.http;

import android.annotation.SuppressLint;
import android.content.Context;
import android.icu.text.SimpleDateFormat;
import android.os.Build;
import com.transsion.iot.communication.http.HeadInterceptorKt;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\u0005\u0010\u0006R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0019\u0010\u000f\u001a\u00020\u000e8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0014\u001a\n \u0013*\u0004\u0018\u00010\u00070\u00078\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\t\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/transsion/iot/communication/http/HeadInterceptor;", "Lokhttp3/Interceptor;", "Lokhttp3/Interceptor$Chain;", "chain", "Lokhttp3/Response;", "intercept", "(Lokhttp3/Interceptor$Chain;)Lokhttp3/Response;", "", "token", "Ljava/lang/String;", "getToken", "()Ljava/lang/String;", "setToken", "(Ljava/lang/String;)V", "Landroid/icu/text/SimpleDateFormat;", "format", "Landroid/icu/text/SimpleDateFormat;", "getFormat", "()Landroid/icu/text/SimpleDateFormat;", "kotlin.jvm.PlatformType", "versionName", "getVersionName", "Landroid/content/Context;", "context", "<init>", "(Landroid/content/Context;Ljava/lang/String;)V", "communication_release"})
public final class HeadInterceptor
implements Interceptor {
    @NotNull
    private String token;
    @NotNull
    private final SimpleDateFormat format;
    private final String versionName;

    public HeadInterceptor(@NotNull Context context, @NotNull String string) {
        HeadInterceptor headInterceptor = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string, (String)"token");
        headInterceptor.token = string;
        headInterceptor.format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        this.versionName = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    public final void setToken(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.token = string;
    }

    @NotNull
    public final SimpleDateFormat getFormat() {
        return this.format;
    }

    public final String getVersionName() {
        return this.versionName;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain object) {
        Interceptor.Chain chain = object;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request.Builder builder = chain.request().newBuilder().header("Content-Type", "application/json").header("eDevId", "1000").header("transId", UUID.randomUUID().toString()).header("appVersion", this.versionName).header("appName", "WELIFE").header("gaid", HeadInterceptorKt.getGaid()).header("brand", Build.BRAND).header("deviceModel", Build.MODEL);
        object = this.token;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bearer ");
        stringBuilder.append((String)object);
        Response response = chain.proceed(builder.header("Authorization", stringBuilder.toString()).header("Date", this.format.format(new Date())).build());
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"chain.proceed(request)");
        return response;
    }
}

