/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.iot.communication.udp;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.transsion.iot.communication.packet.resp.BasicInfo;
import com.transsion.iot.communication.udp.IUDPMessageReceiver;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001$B\t\b\u0002\u00a2\u0006\u0004\b#\u0010\u0015J\u0019\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\t\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0015R\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u00020\u00108\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001eR\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u00a8\u0006%"}, d2={"Lcom/transsion/iot/communication/udp/UDPClient;", "", "Lcom/transsion/iot/communication/packet/resp/BasicInfo;", "basicInfo", "", "onReceiveMessage", "(Lcom/transsion/iot/communication/packet/resp/BasicInfo;)V", "", "errMsg", "onReceiveError", "(Ljava/lang/String;)V", "Lcom/transsion/iot/communication/udp/IUDPMessageReceiver;", "receiver", "registerMessageReceiver", "(Lcom/transsion/iot/communication/udp/IUDPMessageReceiver;)V", "unregisterMessageReceiver", "", "port", "startReceive", "(I)V", "stopReceive", "()V", "onDestroy", "Lcom/transsion/iot/communication/udp/UDPClient$SocketReceiveThread;", "mReceiveThread", "Lcom/transsion/iot/communication/udp/UDPClient$SocketReceiveThread;", "Ljava/net/DatagramSocket;", "mSocket", "Ljava/net/DatagramSocket;", "mPort", "I", "BROADCAST_PORT", "Ljava/util/concurrent/CopyOnWriteArrayList;", "mMessageReceivers", "Ljava/util/concurrent/CopyOnWriteArrayList;", "<init>", "SocketReceiveThread", "communication_release"})
public final class UDPClient {
    @NotNull
    public static final UDPClient INSTANCE = new UDPClient();
    public static final int BROADCAST_PORT = 6000;
    @Nullable
    private static SocketReceiveThread mReceiveThread;
    private static int mPort;
    @Nullable
    private static DatagramSocket mSocket;
    @NotNull
    private static CopyOnWriteArrayList<IUDPMessageReceiver> mMessageReceivers;

    private UDPClient() {
    }

    private final void onReceiveMessage(BasicInfo basicInfo) {
        Iterator<IUDPMessageReceiver> iterator = mMessageReceivers.iterator();
        while (iterator.hasNext()) {
            ((IUDPMessageReceiver)iterator.next()).onMessageReceived(basicInfo);
        }
    }

    private final void onReceiveError(String string) {
        Iterator<IUDPMessageReceiver> iterator = mMessageReceivers.iterator();
        while (iterator.hasNext()) {
            ((IUDPMessageReceiver)iterator.next()).onErrorReceived(string);
        }
    }

    public static /* synthetic */ void startReceive$default(UDPClient uDPClient, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 6000;
        }
        uDPClient.startReceive(n);
    }

    static {
        mPort = 6000;
        mMessageReceivers = new CopyOnWriteArrayList();
    }

    public final void registerMessageReceiver(@NotNull IUDPMessageReceiver iUDPMessageReceiver) {
        Intrinsics.checkNotNullParameter((Object)iUDPMessageReceiver, (String)"receiver");
        if (!mMessageReceivers.contains(iUDPMessageReceiver)) {
            mMessageReceivers.add(iUDPMessageReceiver);
        }
    }

    public final void unregisterMessageReceiver(@NotNull IUDPMessageReceiver iUDPMessageReceiver) {
        Intrinsics.checkNotNullParameter((Object)iUDPMessageReceiver, (String)"receiver");
        if (mMessageReceivers.contains(iUDPMessageReceiver)) {
            mMessageReceivers.remove(iUDPMessageReceiver);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void startReceive(int n) {
        SocketReceiveThread socketReceiveThread;
        Object object;
        block8: {
            DatagramSocket datagramSocket;
            mPort = n;
            object = datagramSocket;
            try {
                mSocket = new DatagramSocket(null);
                if (object != null) {
                    ((DatagramSocket)object).setReuseAddress(true);
                }
                object = mSocket;
                if (object == null) {
                    break block8;
                }
            }
            catch (Exception exception) {
                this.onReceiveError(exception.getMessage());
                return;
            }
            {
                ((DatagramSocket)object).bind(new InetSocketAddress(mPort));
            }
        }
        object = socketReceiveThread;
        {
            mReceiveThread = new SocketReceiveThread();
            if (object == null) {
                return;
            }
            ((Thread)object).start();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void stopReceive() {
        Object object = mReceiveThread;
        if (object != null) {
            ((SocketReceiveThread)object).threadExit();
        }
        try {
            object = mSocket;
            if (!(object != null && !((DatagramSocket)object).isClosed())) return;
            object = mSocket;
            if (object != null) {
                ((DatagramSocket)object).close();
            }
            mSocket = null;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onDestroy() {
        try {
            Object object = mSocket;
            if (!(object != null && !((DatagramSocket)object).isClosed())) return;
            object = mSocket;
            if (object != null) {
                ((DatagramSocket)object).close();
            }
            mSocket = null;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\b\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004R\u0016\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/transsion/iot/communication/udp/UDPClient$SocketReceiveThread;", "Ljava/lang/Thread;", "", "run", "()V", "threadExit", "Ljava/util/concurrent/atomic/AtomicBoolean;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "<init>", "communication_release"})
    public static final class SocketReceiveThread
    extends Thread {
        @NotNull
        private AtomicBoolean threadExit;

        public SocketReceiveThread() {
            AtomicBoolean atomicBoolean;
            AtomicBoolean atomicBoolean2 = atomicBoolean;
            atomicBoolean = new AtomicBoolean(false);
            v1.threadExit = atomicBoolean2;
        }

        @Override
        public void run() {
            int n = 1024;
            byte[] byArray = new byte[1024];
            while (!this.threadExit.get()) {
                String string;
                Object object;
                block20: {
                    DatagramPacket datagramPacket;
                    object = datagramPacket;
                    datagramPacket = new DatagramPacket(byArray, n);
                    DatagramSocket datagramSocket = mSocket;
                    if (datagramSocket == null) break block20;
                    datagramSocket.receive((DatagramPacket)object);
                }
                int n2 = 0;
                int n3 = ((DatagramPacket)object).getLength();
                String string2 = string;
                string = new String(byArray, n2, n3, Charsets.UTF_8);
                String string3 = string2;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("receiveData=");
                stringBuilder.append(string3);
                Log.d((String)"UDPClient", (String)stringBuilder.toString());
                object = (BasicInfo)new Gson().fromJson(string2, BasicInfo.class);
                Object object2 = object;
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append("basicInfo=");
                stringBuilder2.append(object2);
                Log.d((String)"UDPClient", (String)stringBuilder2.toString());
                try {
                    INSTANCE.onReceiveMessage((BasicInfo)object);
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    jsonSyntaxException.printStackTrace();
                    INSTANCE.onReceiveError(jsonSyntaxException.getMessage());
                    this.threadExit();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    INSTANCE.onReceiveError(iOException.getMessage());
                    this.threadExit();
                }
            }
        }

        public final void threadExit() {
            this.threadExit.set(true);
        }
    }
}

