/*
 * Transsion Top Secret
 * Copyright (C) 2021 Transsion Inc.
 * Welife
 * @author OS : fuhuang.fan (18650792)
 * @version 1.0
 */

package com.transsion.iot.commons.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.annotation.LayoutRes
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.ListAdapter
import androidx.recyclerview.widget.RecyclerView

/**
 * @Author fuhuang.fan
 * @Date 2022/2/25/025 10:09
 * @Description
 */
abstract class BaseDataBindingAdapter<T, B : ViewDataBinding>(
    var mContext: Context,
    diffCallback: DiffUtil.ItemCallback<T>,
) : ListAdapter<T, RecyclerView.ViewHolder>(diffCallback) {

    override fun submitList(list: MutableList<T>?) {
        super.submitList(if (list != null) ArrayList(list) else ArrayList())
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        val binding: B = DataBindingUtil.inflate(
            LayoutInflater.from(mContext),
            getLayoutResId(viewType), parent, false
        )
        return BaseBindingViewHolder(binding.root)
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        val binding: B? = DataBindingUtil.getBinding(holder.itemView)
        onBindItem(binding, this.getItem(position), holder)
        binding?.executePendingBindings()
    }

    @LayoutRes
    protected abstract fun getLayoutResId(viewType: Int): Int

    protected abstract fun onBindItem(binding: B?, item: T?, holder: RecyclerView.ViewHolder)

    interface OnItemLongClickListener<T> {
        fun onLongClick(view: View, item: T): Boolean
    }

    interface OnItemClickListener<T> {
        fun onClick(view: View, item: T)
    }

    class BaseBindingViewHolder internal constructor(itemView: View) :
        RecyclerView.ViewHolder(itemView)
}
