/*
 * Transsion Top Secret
 * Copyright (C) 2021 Transsion Inc.
 * Welife
 *  @author OS : fuhuang.fan (18650792)
 *  @version 1.0
 */

package com.transsion.iot.commons.adapter

import android.graphics.drawable.Drawable
import android.text.TextUtils
import android.view.ViewGroup
import android.widget.ImageView
import androidx.annotation.Keep
import androidx.databinding.BindingAdapter
import androidx.databinding.ViewDataBinding
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.bumptech.glide.integration.webp.decoder.WebpDrawable
import com.bumptech.glide.integration.webp.decoder.WebpDrawableTransformation
import com.bumptech.glide.load.engine.DiskCacheStrategy
import com.bumptech.glide.load.resource.bitmap.FitCenter
import com.bumptech.glide.request.RequestOptions
import com.transsion.iot.commons.R
import com.transsion.iot.commons.constant.ImageType
import com.transsion.iot.commons.constant.ItemSize

/**
 * @Author fuhuang.fan
 * @Date 2022/3/18/018 11:21
 * @Description 各个模块共用的的自定义BindingAdapter
 */
@Keep
object CommonBindAdapter {

    @BindingAdapter(value = ["setAdapter", "submitList"], requireAll = true)
    @JvmStatic
    fun <T, B : ViewDataBinding, V: RecyclerView.ViewHolder> setAdapter(recyclerView: RecyclerView, adapter: RecyclerView.Adapter<V>, list: MutableList<T>?) {
        recyclerView.adapter = adapter
        (adapter as BaseDataBindingAdapter<T, B>).submitList(list)
    }

    @BindingAdapter("addItemDecoration")
    @JvmStatic
    fun addItemDecoration(recyclerView: RecyclerView, decor: RecyclerView.ItemDecoration) {
        recyclerView.addItemDecoration(decor)
    }

    @BindingAdapter(value = ["setImgResourceRemote", "setPlaceHolder", "setImgType"], requireAll = true)
    @JvmStatic
    fun setImgResourceRemote(imageView: ImageView, remoteUrl: String?, localDrawable: Drawable?, imageType: Int) {
        if (TextUtils.isEmpty(remoteUrl)) {
            val requestOptions: RequestOptions = when(imageType) {
                ImageType.IMG_ROUND.type -> RequestOptions.circleCropTransform()
                ImageType.IMG_SQUARE.type -> RequestOptions()
                else -> RequestOptions.circleCropTransform()
            }
            localDrawable?.let {
                Glide.with(imageView)
                    .load(localDrawable)
                    .apply(requestOptions)
                    .into(imageView)
            }
        } else {
            val requestOptions: RequestOptions = when(imageType) {
                ImageType.IMG_ROUND.type -> RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.ALL).circleCrop()
                ImageType.IMG_SQUARE.type -> RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.ALL)
                else -> RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.ALL).circleCrop()
            }
            val apply = Glide.with(imageView)
                .load(remoteUrl)
                .placeholder(localDrawable)
                .apply(requestOptions)
            if (remoteUrl?.endsWith(".webp") == true) {
                val transformation = FitCenter()
                apply.optionalTransform(transformation)
                    .optionalTransform(
                        WebpDrawable::class.java,
                        WebpDrawableTransformation(transformation)
                    )
            }
            apply.into(imageView)
        }
    }

    @BindingAdapter("setItemHeight")
    @JvmStatic
    fun setItemHeight(viewGroup: ViewGroup, itemSize: Int){
        viewGroup.layoutParams.height = when(itemSize) {
            ItemSize.SIZE_SMALL.size -> viewGroup.context.resources.getDimensionPixelSize(R.dimen.dp_60)
            ItemSize.SIZE_MEDIUM.size -> viewGroup.context.resources.getDimensionPixelSize(R.dimen.dp_70)
            else -> viewGroup.context.resources.getDimensionPixelSize(R.dimen.dp_60)
        }
    }
}