package com.transsion.iot.commons.bean

import android.graphics.drawable.Drawable
import android.text.TextUtils
import com.transsion.iot.commons.constant.ColorType
import com.transsion.iot.commons.constant.ImageType
import com.transsion.iot.commons.constant.ItemSize

/**
 * @Author fuhuang.fan
 * @Date 2022/3/22/022 12:07
 * @Description
 */
abstract class IOTBaseItemBean() {
    var mLeftIconUrl : String? = null
    var mLeftIconLocal: Drawable? = null
    var mLeftTopText : String? = null
    var mLeftBottomText: String? = null
    var mRightText:String? = null
    var mRightIconLocal: Drawable? = null
    var mItemSize: ItemSize = ItemSize.SIZE_SMALL
    var mImageType: ImageType = ImageType.IMG_ROUND
    var mColorType: ColorType = ColorType.COLOR_NOT

    fun isLeftIconShow():Boolean {
        return !TextUtils.isEmpty(mLeftIconUrl) || mLeftIconLocal != null
    }

    fun isLeftTopShow(): Boolean {
        return !TextUtils.isEmpty(mLeftTopText)
    }

    fun isLeftBottomShow(): Boolean {
        return !TextUtils.isEmpty(mLeftBottomText)
    }

    fun isRightTextShow(): Boolean {
        return !TextUtils.isEmpty(mRightText)
    }

    fun isRightIconShow(): Boolean {
        return mRightIconLocal != null
    }

    fun getItemSize(): Int {
        return mItemSize.size
    }

    fun getColorType(): Int {
        return mColorType.type
    }

    fun getImageType(): Int {
        return mImageType.type
    }

    override fun equals(other: Any?): Boolean {
        return this === other
    }

    override fun hashCode(): Int {
        var result = mLeftIconUrl?.hashCode() ?: 0
        result = 31 * result + (mLeftIconLocal?.hashCode() ?: 0)
        result = 31 * result + (mLeftTopText?.hashCode() ?: 0)
        result = 31 * result + (mLeftBottomText?.hashCode() ?: 0)
        result = 31 * result + (mRightText?.hashCode() ?: 0)
        result = 31 * result + (mRightIconLocal?.hashCode() ?: 0)
        result = 31 * result + mItemSize.hashCode()
        result = 31 * result + mImageType.hashCode()
        result = 31 * result + mColorType.hashCode()
        return result
    }


}