/*
 * Transsion Top Secret
 * Copyright (C) 2021 Transsion Inc.
 * Welife
 *  @author OS : fuhuang.fan (18650792)
 *  @version 1.0
 */

package com.transsion.iot.widget.popwindow

import android.content.Context
import android.graphics.drawable.ColorDrawable
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.PopupWindow


/**
 * @Author fuhuang.fan
 * @Date 2022/3/18/018 15:40
 * @Description
 */
class IOTCustomPopWindow : PopupWindow() {

    inner class Builder(var context: Context) {
        private var mPopupWindowWidth: Int = ViewGroup.LayoutParams.WRAP_CONTENT
        private var mPopupWindowHeight: Int = ViewGroup.LayoutParams.WRAP_CONTENT
        private var mContentView: View? = null
        private var mBackgroundColor: Int = 0
        private var mAnimStyle: Int = 0
        private var mElevation: Float = 0.0f
        private var isOutsideTouchable: Boolean = true
        private var isFocusable: Boolean = false
        private var onDismissListener: OnDismissListener? = null
        private var onTouchListener: View.OnTouchListener? = null

        fun setWidth(width : Int) : Builder {
            mPopupWindowWidth = width
            return this
        }

        fun setHeight(height: Int) : Builder {
            mPopupWindowHeight = height
            return this
        }

        fun setContentView(contentView : View): Builder {
            mContentView = contentView
            return this
        }

        fun setContentView(viewId: Int) : Builder {
            mContentView = LayoutInflater.from(context).inflate(viewId, null)
            return this
        }

        fun setBackgroundDrawable(color: Int): Builder {
            mBackgroundColor = color
            return this
        }

        fun setAnimationStyle(animStyle: Int): Builder {
            mAnimStyle = animStyle
            return this
        }

        fun setElevation(elevation: Float): Builder {
            mElevation = elevation
            return this
        }

        fun setIsOutsideTouchable(isOutsideTouchable: Boolean): Builder {
            this.isOutsideTouchable = isOutsideTouchable
            return this
        }

        fun setIsFocusable(isFocusable : Boolean) : Builder {
            this.isFocusable = isFocusable
            return this
        }

        fun setOnDismissListener(onDismissListener: OnDismissListener): Builder {
            this.onDismissListener = onDismissListener
            return this
        }

        fun setTouchInterceptor(onTouchListener: View.OnTouchListener): Builder {
            this.onTouchListener = onTouchListener
            return this
        }

        fun build() : IOTCustomPopWindow {
            this@IOTCustomPopWindow.width = mPopupWindowWidth
            this@IOTCustomPopWindow.height = mPopupWindowHeight
            this@IOTCustomPopWindow.animationStyle = mAnimStyle
            this@IOTCustomPopWindow.contentView = mContentView
            this@IOTCustomPopWindow.elevation = mElevation
            this@IOTCustomPopWindow.isFocusable = isFocusable
            this@IOTCustomPopWindow.isOutsideTouchable = isOutsideTouchable
            val backgroundDrawable = ColorDrawable(mBackgroundColor)
            this@IOTCustomPopWindow.setBackgroundDrawable(backgroundDrawable)
            this@IOTCustomPopWindow.setOnDismissListener(onDismissListener)
            this@IOTCustomPopWindow.setTouchInterceptor(onTouchListener)
            return this@IOTCustomPopWindow
        }
    }
}