/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.iot.widget.text;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.transsion.iot.widget.text.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0014J\b\u0010\u0011\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/transsion/iot/widget/text/IOTDotTextView;", "Landroid/widget/TextView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "getDotIndex", "lastEndIndex", "onMeasure", "", "widthMeasureSpec", "heightMeasureSpec", "updateText", "IOTTextView_release"})
public final class IOTDotTextView
extends TextView {
    public IOTDotTextView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public IOTDotTextView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
    }

    public IOTDotTextView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        Log.d((String)"IOTDotTextView", (String)("measuredHeight=" + this.getMeasuredHeight()));
        if (heightMode == Integer.MIN_VALUE) {
            heightSize = this.getMeasuredHeight() / this.getLineCount() + this.getPaddingTop() + this.getPaddingBottom();
        }
        if (widthMode == Integer.MIN_VALUE) {
            if (this.getLineCount() > 1) {
                this.updateText();
            }
            widthSize = (int)this.getPaint().measureText(((Object)this.getText()).toString()) + this.getPaddingStart() + this.getPaddingEnd();
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    private final void updateText() {
        int lineEndIndex = this.getLayout().getLineEnd(0);
        int dotIndex = this.getDotIndex(lineEndIndex);
        if (dotIndex < 1) {
            return;
        }
        Log.d((String)"IOTDotTextView", (String)("dotIndex=" + dotIndex));
        Object[] objectArray = new Object[]{((Object)this.getText().subSequence(0, lineEndIndex - dotIndex)).toString()};
        this.setText(this.getResources().getString(R.string.iot_text_with_dot, objectArray));
    }

    private final int getDotIndex(int lastEndIndex) {
        if (lastEndIndex < 3) {
            return 0;
        }
        float endTextLength = 0.0f;
        Object[] objectArray = new Object[]{""};
        float dotLength = this.getPaint().measureText(this.getResources().getString(R.string.iot_text_with_dot, objectArray));
        int i = 1;
        while (dotLength > endTextLength && i < 3) {
            endTextLength = this.getPaint().measureText(this.getText(), lastEndIndex - i, lastEndIndex);
            int n = i;
            i = n + 1;
        }
        return i;
    }
}

