/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.iotservice.pc.helper;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import com.transsion.iotservice.pc.IDeviceService;
import com.transsion.iotservice.pc.bean.ThumbBean;
import com.transsion.iotservice.pc.service.FileToConnection;
import com.transsion.iotservice.pc.utils.HiUtils;
import com.transsion.iotservice.pc.utils.STEP;
import com.transsion.iotservice.pc.utils.pt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\u0016\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bJ-\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0016\u0010\u001c\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040\u001d\"\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010\u001f\u001a\u00020\u00152\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!J\u0006\u0010#\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/transsion/iotservice/pc/helper/FileHelper;", "", "()V", "TAG", "", "connectionTo", "Lcom/transsion/iotservice/pc/service/FileToConnection;", "context", "Landroid/content/Context;", "intentTo", "Landroid/content/Intent;", "lock", "", "pkgTo", "serviceTo", "toInterface", "Lcom/transsion/iotservice/pc/IDeviceService;", "versionCode", "", "versionName", "bindTo", "", "getVersion", "getVersionCode", "register", "sendStep", "step", "Lcom/transsion/iotservice/pc/utils/STEP;", "attach", "", "(Lcom/transsion/iotservice/pc/utils/STEP;[Ljava/lang/String;)V", "sendThumbs", "thumbs", "", "Lcom/transsion/iotservice/pc/bean/ThumbBean;", "unRegister", "filetransfersdk_release"})
@SuppressLint(value={"StaticFieldLeak"})
public final class FileHelper {
    @NotNull
    public static final FileHelper INSTANCE = new FileHelper();
    private static final int versionCode = 16;
    @NotNull
    private static final String versionName = "1.0.16";
    @NotNull
    private static final String TAG = "FileSDK";
    @Nullable
    private static Context context;
    @NotNull
    private static final String pkgTo;
    @NotNull
    private static final String serviceTo;
    @Nullable
    private static Intent intentTo;
    @Nullable
    private static FileToConnection connectionTo;
    @Nullable
    private static IDeviceService toInterface;
    private static boolean lock;

    private FileHelper() {
    }

    public final void register(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!lock) {
            return;
        }
        lock = false;
        pt.v(TAG, "\u6ce8\u518c\u7ed1\u5b9aWLS\u8fdc\u7a0b\u670d\u52a1");
        FileHelper.context = context;
        this.bindTo(context);
    }

    public final void sendThumbs(@NotNull List<ThumbBean> thumbs) {
        Intrinsics.checkNotNullParameter(thumbs, (String)"thumbs");
        pt.v(TAG, Intrinsics.stringPlus((String)"\u53d1\u9001\u7f29\u7565\u56fe, \u6570\u91cf\u4e3a: ", (Object)thumbs.size()));
        String[] stringArray = new String[]{HiUtils.INSTANCE.turnListToJson(thumbs)};
        this.sendStep(STEP.THUMB, stringArray);
    }

    private final void bindTo(Context context) {
        pt.v(TAG, "\u7ed1\u5b9a\u4ed6\u4eba\u670d\u52a1 - \u53d1\u9001\u6d88\u606f\u7ed9\u522b\u4eba");
        intentTo = new Intent().setComponent(new ComponentName(pkgTo, serviceTo));
        FileToConnection fileToConnection = connectionTo = new FileToConnection();
        Intrinsics.checkNotNull((Object)fileToConnection);
        context.bindService(intentTo, (ServiceConnection)fileToConnection, 1);
    }

    public final void unRegister() {
        pt.v(TAG, "\u6ce8\u9500\u7ed1\u5b9aWLS\u8fdc\u7a0b\u670d\u52a1");
        this.sendStep(STEP.UNREGISTE, new String[0]);
        Object object = context;
        Intrinsics.checkNotNull((Object)object);
        Context context = object;
        object = connectionTo;
        Intrinsics.checkNotNull((Object)object);
        context.unbindService((ServiceConnection)object);
        lock = true;
    }

    private final void sendStep(STEP step, String ... attach) {
        String[] attach2 = attach;
        if (lock) {
            return;
        }
        try {
            Object object = connectionTo;
            Intrinsics.checkNotNull((Object)object);
            toInterface = ((FileToConnection)object).iDeviceService;
            if (toInterface == null) {
                object = context;
                Intrinsics.checkNotNull((Object)object);
                this.register((Context)object);
                pt.w(TAG, "WLS\u6587\u4ef6\u7ba1\u7406\u8fdc\u7a0b\u8fde\u63a5\u4e2d, \u8bf7\u7a0d\u540e\u518d\u8bd5");
                return;
            }
            pt.i(TAG, Intrinsics.stringPlus((String)"\u5f53\u524d\u6b65\u9aa4\u662f: ", (Object)step.value));
            object = attach2;
            boolean bl = false;
            if (((String[])object).length == 0) {
                object = new String[]{""};
                attach2 = object;
            }
            object = toInterface;
            Intrinsics.checkNotNull((Object)object);
            object.obtainStep(step.value, attach2[0]);
        }
        catch (Exception e) {
            pt.e(TAG, Intrinsics.stringPlus((String)"WLS\u6587\u4ef6\u7ba1\u7406\u8fdc\u7a0b\u63a5\u53e3\u51fa\u9519: ", (Object)e.getMessage()));
            e.printStackTrace();
        }
    }

    public final int getVersionCode() {
        return 16;
    }

    @NotNull
    public final String getVersion() {
        return versionName;
    }

    static {
        pkgTo = "com.transsion.iotservice.multiscreen.pc";
        serviceTo = "com.transsion.iotservice.multiscreen.pc.helper.FileService";
        lock = true;
    }
}

