/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.aidatacenter.exported.data;

import com.transsion.kolun.aidatacenter.exported.data.MixSensorData;
import java.util.ArrayList;
import java.util.List;

public class MixSensorOnnxData
extends MixSensorData {
    private final List<Float> onnxData = new ArrayList<Float>();

    @Override
    protected void onDataUpdate() {
        super.onDataUpdate();
        this.listenSensorTypeList.forEach(type -> {
            MixSensorData.SensorData sd = (MixSensorData.SensorData)this.dataMap.get(type);
            if (sd == null) {
                this.appendFloatDef((String)type, this.onnxData);
            } else {
                this.onnxData.addAll(sd.getValueList());
            }
        });
    }

    private void appendFloatDef(String type, List<Float> onnxData) {
        int valueSize = this.getSensorValueSize(type);
        for (int i = 0; i < valueSize; ++i) {
            onnxData.add(Float.valueOf(0.0f));
        }
    }

    public float[] getOnnxData() {
        float[] data = new float[this.onnxData.size()];
        int i = 0;
        for (Float e : this.onnxData) {
            data[i++] = e.floatValue();
        }
        return data;
    }

    public List<Float> getOnnxDataAsList() {
        return this.onnxData;
    }
}

