/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.aidatacenter.exported.utils;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ParcelTools {
    private static final String TAG = "ParcelTools";

    public static <T extends Parcelable> String getStrFromParcelObject(T parcelable) {
        if (parcelable == null) {
            return "";
        }
        Parcel parcelRead = Parcel.obtain();
        parcelable.writeToParcel(parcelRead, 0);
        byte[] rawData = parcelRead.marshall();
        parcelRead.recycle();
        return Base64.encodeToString((byte[])rawData, (int)0);
    }

    public static <T extends Parcelable> T getParcelObjectFromStr(String data, Class<T> clz) {
        if (TextUtils.isEmpty((CharSequence)data)) {
            Log.w((String)TAG, (String)"getParcelObjectFromStr null data ");
            return null;
        }
        byte[] rawData = Base64.decode((String)data, (int)0);
        Parcel parcelRead = Parcel.obtain();
        parcelRead.unmarshall(rawData, 0, rawData.length);
        parcelRead.setDataPosition(0);
        try {
            Field field = clz.getDeclaredField("CREATOR");
            Object object = field.get(null);
            Method method = object.getClass().getDeclaredMethod("createFromParcel", Parcel.class);
            method.setAccessible(true);
            return (T)((Parcelable)method.invoke(object, parcelRead));
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("getParcelObjectFromStr fail " + e.getMessage()));
            return null;
        }
    }
}

