/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.apiinvoke.common.router;

import com.transsion.apiinvoke.common.annotation.RouterApi;
import com.transsion.apiinvoke.common.router.APIClassEntity;
import com.transsion.apiinvoke.common.router.ChannelEntity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ApiRouterManager {
    private static final String REGISTER_CHANNEL_METHOD = "loadApiChannels";
    private static final String REGISTER_MANAGER_METHOD = "loadApiRouters";
    private static List<String> registerList = new ArrayList<String>();
    private static Map<String, ChannelEntity> channelMap = new HashMap<String, ChannelEntity>();
    private static Map<String, APIClassEntity> routerMap = new HashMap<String, APIClassEntity>();
    private static volatile ApiRouterManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApiRouterManager getInstance() {
        if (instance != null) return instance;
        Class<ApiRouterManager> clazz = ApiRouterManager.class;
        synchronized (ApiRouterManager.class) {
            if (instance != null) return instance;
            instance = new ApiRouterManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ApiRouterManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerApi(Class clazz) {
        RouterApi[] apis = (RouterApi[])clazz.getAnnotationsByType(RouterApi.class);
        if (apis == null || apis.length == 0) {
            return;
        }
        RouterApi routerApi = apis[0];
        APIClassEntity entity = APIClassEntity.createLocalServer(routerApi.packageName(), routerApi.apiName(), clazz, routerApi.constructorType(), routerApi.livingTime());
        Map<String, APIClassEntity> map = routerMap;
        synchronized (map) {
            routerMap.put(entity.apiName, entity);
        }
    }

    public static void register(String packageClass) {
        try {
            ApiRouterManager.register(Class.forName(packageClass));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void register(String packageClass, ClassLoader loader) {
        try {
            ApiRouterManager.register(Class.forName(packageClass, true, loader));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void register(Class clazz) {
        if (registerList.contains(clazz.getName())) {
            return;
        }
        registerList.add(clazz.getName());
        ApiRouterManager.registerApiRouter(clazz);
        ApiRouterManager.registerChannel(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerApiRouter(Class clazz) {
        Map<String, APIClassEntity> map = routerMap;
        synchronized (map) {
            try {
                if (clazz == null) {
                    return;
                }
                Method method = clazz.getMethod(REGISTER_MANAGER_METHOD, Map.class);
                method.invoke(null, routerMap);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            System.out.println("ApiRouterManager init success ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerChannel(Class clazz) {
        Map<String, ChannelEntity> map = channelMap;
        synchronized (map) {
            try {
                if (clazz == null) {
                    return;
                }
                Method method = clazz.getMethod(REGISTER_CHANNEL_METHOD, Map.class);
                method.invoke(null, channelMap);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            System.out.println("ApiRouterManager init success ");
        }
    }

    public static Map<String, APIClassEntity> getRouterMap() {
        return routerMap;
    }

    public static Map<String, ChannelEntity> getChannelMap() {
        return channelMap;
    }

    public static APIClassEntity getApiEntity(String apiName) {
        return routerMap.get(apiName);
    }

    public static boolean isInService(String apiName) {
        return routerMap.containsKey(apiName);
    }

    public static ChannelEntity getChannel(String channelName) {
        return channelMap.get(channelName);
    }

    public static void addNewChannel(ChannelEntity entity) {
        channelMap.put(entity.channelName, entity);
    }

    public static void addLocalChannel(String channelName, String[] services) {
        channelMap.put(channelName, ChannelEntity.createLocalChannel(channelName, services));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChannelEntity findChannel(String apiName) {
        Map<String, ChannelEntity> map = channelMap;
        synchronized (map) {
            for (Map.Entry<String, ChannelEntity> entity : channelMap.entrySet()) {
                ChannelEntity channelEntity = entity.getValue();
                if (channelEntity == null || channelEntity.channelService == null || channelEntity.channelService.length == 0) continue;
                for (String apis : channelEntity.channelService) {
                    if (!apis.equals(apiName)) continue;
                    return channelEntity;
                }
            }
        }
        return null;
    }

    public static void listRegisterServer() {
        for (Map.Entry<String, APIClassEntity> entity : routerMap.entrySet()) {
            System.out.println("ApiRouterManager ==>>  key " + entity.getKey() + " entity : " + entity);
        }
    }
}

