/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.apiinvoke.ipc;

import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.transsion.apiinvoke.invoke.ApiRequest;
import com.transsion.apiinvoke.invoke.ApiResponse;
import com.transsion.apiinvoke.invoke.TypeValuePair;
import com.transsion.apiinvoke.ipc.ITypeParcel;
import com.transsion.apiinvoke.ipc.typeparcel.ApiRequestTypeParcel;
import com.transsion.apiinvoke.ipc.typeparcel.ApiResponseTypeParcel;
import com.transsion.apiinvoke.ipc.typeparcel.BundleTypeParcel;
import com.transsion.apiinvoke.ipc.typeparcel.IBinderTypeParcel;
import com.transsion.apiinvoke.ipc.typeparcel.PublishDataTypeParcel;
import com.transsion.apiinvoke.ipc.typeparcel.TypeValuePairTypeParcel;
import com.transsion.apiinvoke.subscribe.PublishData;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TypeParcelFactor {
    private static TypeParcelFactor defaultInstance;
    private ITypeParcel mDefaultTypeParcel = new PrimitiveTypeTypeParcel();
    private ITypeParcel mArrayTypeParcel = new ArrayTypeTypeParcel();
    private static final List<Class> TYPE_CONST;
    private final Map<Class, ITypeParcel> mTypeParcelMap = new HashMap<Class, ITypeParcel>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeParcelFactor getFactor() {
        if (defaultInstance != null) return defaultInstance;
        Class<TypeParcelFactor> clazz = TypeParcelFactor.class;
        synchronized (TypeParcelFactor.class) {
            if (defaultInstance != null) return defaultInstance;
            defaultInstance = new TypeParcelFactor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultInstance;
        }
    }

    private TypeParcelFactor() {
        this.registerTypeParcel(HashMap.class, new HashMapTypeTypeParcel());
        this.registerTypeParcel(LinkedHashMap.class, new LinkedHashMapTypeTypeParcel());
        this.registerTypeParcel(Hashtable.class, new HashtableTypeTypeParcel());
        ArrayListTypeTypeParcel arrayListTypeTypeParcel = new ArrayListTypeTypeParcel();
        this.registerTypeParcel(ArrayList.class, arrayListTypeTypeParcel);
        this.registerTypeParcel(List.class, arrayListTypeTypeParcel);
        this.registerTypeParcel(Parcelable.class, new ParcelableTypeTypeParcel());
        this.registerTypeParcel(Serializable.class, new SerializableTypeTypeParcel());
        this.registerTypeParcel(ApiRequest.class, new ApiRequestTypeParcel());
        this.registerTypeParcel(ApiResponse.class, new ApiResponseTypeParcel());
        this.registerTypeParcel(TypeValuePair.class, new TypeValuePairTypeParcel());
        this.registerTypeParcel(Bundle.class, new BundleTypeParcel());
        this.registerTypeParcel(IBinder.class, new IBinderTypeParcel());
        this.registerTypeParcel(PublishData.class, new PublishDataTypeParcel());
    }

    public synchronized void registerTypeParcel(Class type, ITypeParcel typeParcel) {
        this.mTypeParcelMap.put(type, typeParcel);
    }

    public synchronized void unRegisterTypeParcel(Class type) {
        this.mTypeParcelMap.remove(type);
    }

    public synchronized Object readFormParcel(Parcel parcel, Class valueType) {
        if (parcel.readInt() == 0) {
            return null;
        }
        ITypeParcel typeParcel = TypeParcelFactor.findTypeParcel(valueType);
        if (typeParcel != null) {
            return typeParcel.readFormParcel(parcel, valueType);
        }
        return null;
    }

    public synchronized void writeToParcel(Parcel dest, Class type, Object value, int flags) {
        ITypeParcel typeParcel;
        if (value == null) {
            dest.writeInt(0);
            return;
        }
        dest.writeInt(1);
        if (type == null) {
            type = value.getClass();
        }
        if ((typeParcel = TypeParcelFactor.findTypeParcel(type)) != null) {
            typeParcel.writeToParcel(dest, type, value, flags);
        }
    }

    private static ITypeParcel findTypeParcel(Class cassType) {
        TypeParcelFactor factor = TypeParcelFactor.getFactor();
        if (cassType.isArray()) {
            return factor.mArrayTypeParcel;
        }
        int typeIndex = TYPE_CONST.indexOf(cassType);
        if (typeIndex != -1) {
            return factor.mDefaultTypeParcel;
        }
        ITypeParcel typeParcel = factor.mTypeParcelMap.get(cassType);
        if (typeParcel != null) {
            return typeParcel;
        }
        if (TypeParcelFactor.isAssignableFrom(cassType, HashMap.class)) {
            return factor.mTypeParcelMap.get(HashMap.class);
        }
        if (TypeParcelFactor.isAssignableFrom(cassType, LinkedHashMap.class)) {
            return factor.mTypeParcelMap.get(LinkedHashMap.class);
        }
        if (TypeParcelFactor.isAssignableFrom(cassType, Hashtable.class)) {
            return factor.mTypeParcelMap.get(Hashtable.class);
        }
        if (TypeParcelFactor.isAssignableFrom(cassType, ArrayList.class) || TypeParcelFactor.isAssignableFrom(cassType, List.class)) {
            return factor.mTypeParcelMap.get(ArrayList.class);
        }
        if (TypeParcelFactor.isAssignableFrom(cassType, Parcelable.class)) {
            return factor.mTypeParcelMap.get(Parcelable.class);
        }
        if (TypeParcelFactor.isAssignableFrom(cassType, Serializable.class)) {
            return factor.mTypeParcelMap.get(Serializable.class);
        }
        if (TypeParcelFactor.isAssignableFrom(cassType, IBinder.class)) {
            return factor.mTypeParcelMap.get(IBinder.class);
        }
        return null;
    }

    private static Object readPrimitiveType(Parcel parcel, int constIndex) {
        switch (constIndex) {
            case 0: 
            case 1: {
                return parcel.readInt();
            }
            case 2: 
            case 3: {
                return parcel.readLong();
            }
            case 4: 
            case 5: {
                return Float.valueOf(parcel.readFloat());
            }
            case 6: 
            case 7: {
                return parcel.readDouble();
            }
            case 8: 
            case 9: {
                return parcel.readByte();
            }
            case 10: {
                return parcel.readString();
            }
            case 11: {
                return parcel.readBundle();
            }
        }
        Log.w((String)"TypeParcelFactor", (String)"readPrimitiveType not support");
        return null;
    }

    private static void writePrimitiveType(Parcel in, Object value, int constIndex) {
        switch (constIndex) {
            case 0: 
            case 1: {
                in.writeInt(((Integer)value).intValue());
                break;
            }
            case 2: 
            case 3: {
                in.writeLong(((Long)value).longValue());
                break;
            }
            case 4: 
            case 5: {
                in.writeFloat(((Float)value).floatValue());
                break;
            }
            case 6: 
            case 7: {
                in.writeDouble(((Double)value).doubleValue());
                break;
            }
            case 8: 
            case 9: {
                in.writeByte(((Byte)value).byteValue());
                break;
            }
            case 10: {
                in.writeString((String)value);
                break;
            }
            case 11: {
                in.writeBundle((Bundle)value);
                break;
            }
            default: {
                Log.w((String)"TypeParcelFactor", (String)"writePrimitiveType not support");
            }
        }
    }

    private static boolean isAssignableFrom(Class parent, Class child) {
        if (parent == null || child == null) {
            return false;
        }
        return child.isAssignableFrom(parent);
    }

    static {
        TYPE_CONST = new ArrayList<Class>();
        TYPE_CONST.add(Integer.TYPE);
        TYPE_CONST.add(Integer.class);
        TYPE_CONST.add(Long.TYPE);
        TYPE_CONST.add(Long.class);
        TYPE_CONST.add(Float.TYPE);
        TYPE_CONST.add(Float.class);
        TYPE_CONST.add(Double.TYPE);
        TYPE_CONST.add(Double.class);
        TYPE_CONST.add(Byte.TYPE);
        TYPE_CONST.add(Byte.class);
        TYPE_CONST.add(String.class);
        TYPE_CONST.add(Bundle.class);
    }

    private static class SerializableTypeTypeParcel
    implements ITypeParcel<Serializable> {
        private SerializableTypeTypeParcel() {
        }

        @Override
        public Serializable readFormParcel(Parcel parcel, Class type) {
            return parcel.readSerializable();
        }

        @Override
        public void writeToParcel(Parcel in, Class type, Serializable value, int flags) {
            in.writeSerializable(value);
        }
    }

    private static class ParcelableTypeTypeParcel
    implements ITypeParcel<Parcelable> {
        private ParcelableTypeTypeParcel() {
        }

        @Override
        public Parcelable readFormParcel(Parcel parcel, Class type) {
            return parcel.readParcelable(this.getClass().getClassLoader());
        }

        @Override
        public void writeToParcel(Parcel in, Class type, Parcelable value, int flags) {
            in.writeParcelable(value, flags);
        }
    }

    private static class ArrayListTypeTypeParcel
    implements ITypeParcel<List> {
        private ArrayListTypeTypeParcel() {
        }

        @Override
        public List readFormParcel(Parcel parcel, Class type) {
            ArrayList list = new ArrayList();
            parcel.readList(list, this.getClass().getClassLoader());
            return list;
        }

        @Override
        public void writeToParcel(Parcel in, Class type, List value, int flags) {
            in.writeList(value);
        }
    }

    private static class HashtableTypeTypeParcel
    implements ITypeParcel<Hashtable> {
        private HashtableTypeTypeParcel() {
        }

        @Override
        public Hashtable readFormParcel(Parcel parcel, Class type) {
            Hashtable map = new Hashtable();
            parcel.readMap(map, this.getClass().getClassLoader());
            return map;
        }

        @Override
        public void writeToParcel(Parcel in, Class type, Hashtable value, int flags) {
            in.writeMap((Map)value);
        }
    }

    private static class LinkedHashMapTypeTypeParcel
    implements ITypeParcel<LinkedHashMap> {
        private LinkedHashMapTypeTypeParcel() {
        }

        @Override
        public LinkedHashMap readFormParcel(Parcel parcel, Class type) {
            LinkedHashMap map = new LinkedHashMap();
            parcel.readMap(map, this.getClass().getClassLoader());
            return map;
        }

        @Override
        public void writeToParcel(Parcel in, Class type, LinkedHashMap value, int flags) {
            in.writeMap((Map)value);
        }
    }

    private static class HashMapTypeTypeParcel
    implements ITypeParcel<HashMap> {
        private HashMapTypeTypeParcel() {
        }

        @Override
        public HashMap readFormParcel(Parcel parcel, Class type) {
            HashMap map = new HashMap();
            parcel.readMap(map, this.getClass().getClassLoader());
            return map;
        }

        @Override
        public void writeToParcel(Parcel in, Class type, HashMap value, int flags) {
            in.writeMap((Map)value);
        }
    }

    private static class PrimitiveTypeTypeParcel
    implements ITypeParcel {
        private PrimitiveTypeTypeParcel() {
        }

        public Object readFormParcel(Parcel parcel, Class type) {
            int typeIndex = TYPE_CONST.indexOf(type);
            return TypeParcelFactor.readPrimitiveType(parcel, typeIndex);
        }

        public void writeToParcel(Parcel in, Class type, Object value, int flags) {
            TypeParcelFactor.writePrimitiveType(in, value, TYPE_CONST.indexOf(type));
        }
    }

    private static class ArrayTypeTypeParcel
    implements ITypeParcel {
        private ArrayTypeTypeParcel() {
        }

        public Object readFormParcel(Parcel parcel, Class type) {
            int arrayLength = parcel.readInt();
            Class componentType = (Class)parcel.readSerializable();
            Object arrayObject = Array.newInstance(componentType, arrayLength);
            ITypeParcel componentTypeParcel = TypeParcelFactor.findTypeParcel(componentType);
            for (int i = 0; i < arrayLength; ++i) {
                if (componentTypeParcel == null || parcel.readInt() == 0) continue;
                Array.set(arrayObject, i, componentTypeParcel.readFormParcel(parcel, componentType));
            }
            return arrayObject;
        }

        public void writeToParcel(Parcel in, Class type, Object value, int flags) {
            int arrayLength = Array.getLength(value);
            in.writeInt(arrayLength);
            if (type == null) {
                type = value.getClass();
            }
            Class<?> componentType = type.getComponentType();
            in.writeSerializable(componentType);
            ITypeParcel componentTypeParcel = TypeParcelFactor.findTypeParcel(componentType);
            for (int i = 0; i < arrayLength; ++i) {
                Object object = Array.get(value, i);
                if (componentTypeParcel == null) continue;
                in.writeInt(1);
                componentTypeParcel.writeToParcel(in, componentType, componentType.cast(object), flags);
            }
        }
    }
}

