/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.apiinvoke.ipc.connect;

import com.transsion.apiinvoke.ipc.connect.ApiMessageReceiver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class ApiServerReceiverObserver
implements ApiMessageReceiver {
    private List<ApiMessageReceiver> mReceivers = Collections.synchronizedList(new ArrayList());
    private ExecutorService mExecute;

    public ApiServerReceiverObserver(ExecutorService execute) {
        this.mExecute = execute;
    }

    public void registerReceiver(ApiMessageReceiver receiver) {
        if (this.mReceivers != null) {
            this.mReceivers.add(receiver);
        }
    }

    public void unRegisterReceiver(ApiMessageReceiver receiver) {
        this.mReceivers.remove(receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMessageReceive(String routerUri, Object data) {
        List<ApiMessageReceiver> list = this.mReceivers;
        synchronized (list) {
            for (ApiMessageReceiver receiver : this.mReceivers) {
                receiver.onReceiveMessage(routerUri, data);
            }
        }
    }

    @Override
    public void onReceiveMessage(String routerUri, Object data) {
        if (this.mExecute != null) {
            this.mExecute.execute(() -> this.notifyMessageReceive(routerUri, data));
        } else {
            this.notifyMessageReceive(routerUri, data);
        }
    }
}

